/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.tok;

import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.Token;

public final class Buffer {
    private static final int INIT_SIZE = 64;
    private char[] buf = new char[64];
    private int len;

    public void clear() {
        this.len = 0;
    }

    public void append(char c) {
        this.need(1);
        this.buf[this.len++] = c;
    }

    public void appendRefCharPair(Token token) {
        this.need(2);
        token.getRefCharPair(this.buf, this.len);
        this.len += 2;
    }

    public void append(Encoding encoding, byte[] byArray, int n, int n2) {
        this.need((n2 - n) / encoding.getMinBytesPerChar());
        this.len += encoding.convert(byArray, n, n2, this.buf, this.len);
    }

    private void need(int n) {
        if (this.len + n <= this.buf.length) {
            return;
        }
        char[] cArray = this.buf;
        this.buf = n > cArray.length ? new char[n * 2] : new char[cArray.length << 1];
        System.arraycopy(cArray, 0, this.buf, 0, cArray.length);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.len << 1];
        int n = 0;
        int n2 = 0;
        while (n2 < this.len) {
            char c = this.buf[n2];
            byArray[n++] = (byte)(c >> 8);
            byArray[n++] = (byte)(c & 0xFF);
            ++n2;
        }
        return byArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.len);
    }

    public int length() {
        return this.len;
    }

    public char charAt(int n) {
        if (n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[n];
    }

    public void chop() {
        --this.len;
    }
}

