/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.tok;

import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.Position;

final class SingleByteEncoding
extends Encoding {
    private final byte[] byteTypeTable = new byte[256];
    private final int[] asciiToByte = new int[128];
    private final String map;

    SingleByteEncoding(String string) {
        super(1);
        this.map = string;
        int n = 0;
        while (n < 128) {
            this.asciiToByte[n] = 255;
            ++n;
        }
        int n2 = 0;
        while (n2 < 256) {
            char c = string.charAt(n2);
            if (c != '\ufffd') {
                this.byteTypeTable[n2] = Encoding.charTypeTable[c >> 8][c & 0xFF];
                if (c < '\u0080') {
                    this.asciiToByte[c] = (byte)n2;
                }
            } else {
                this.byteTypeTable[n2] = -6;
            }
            ++n2;
        }
    }

    int byteType(byte[] byArray, int n) {
        return this.byteTypeTable[byArray[n] & 0xFF];
    }

    int byteToAscii(byte[] byArray, int n) {
        return this.map.charAt(byArray[n] & 0xFF);
    }

    boolean charMatches(byte[] byArray, int n, char c) {
        return this.asciiToByte[c] == byArray[n];
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        int n4 = n3;
        while (n != n2) {
            cArray[n3++] = this.map.charAt(byArray[n++] & 0xFF);
        }
        return n3 - n4;
    }

    public int getFixedBytesPerChar() {
        return 1;
    }

    public void movePosition(byte[] byArray, int n, int n2, Position position) {
        int n3 = n - position.columnNumber;
        int n4 = position.lineNumber;
        while (n != n2) {
            switch (this.byteTypeTable[byArray[n++] & 0xFF]) {
                case -10: {
                    ++n4;
                    n3 = n;
                    break;
                }
                case -11: {
                    ++n4;
                    if (n == n2 || byArray[n] == this.asciiToByte[10]) {
                        // empty if block
                    }
                    n3 = ++n;
                }
            }
        }
        position.columnNumber = n - n3;
        position.lineNumber = n4;
    }

    int extendData(byte[] byArray, int n, int n2) {
        while (n != n2 && this.byteTypeTable[byArray[n] & 0xFF] >= 0) {
            ++n;
        }
        return n;
    }
}

