/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

class genmaps {
    private static byte[] bytes256 = new byte[256];

    genmaps() {
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("usage: java genmap encoding ... encoding");
            System.exit(1);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("SingleByteEncodings.java"));
        bufferedWriter.write("package com.jclark.xml.tok;\n\nimport java.util.Hashtable;\n\nfinal class SingleByteEncodings {\n");
        bufferedWriter.write("  private static final String[] maps = {\n");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            bufferedWriter.write("    \"" + string + "\",\n");
            bufferedWriter.write("    \"");
            boolean bl = genmaps.generateEncoding(string, bufferedWriter);
            bufferedWriter.write("\",\n");
            ++n;
        }
        bufferedWriter.write("  };\n\n  private static Hashtable encodings = new Hashtable();\n  static {\n    for (int i = 0; i < maps.length; i += 2)\n      encodings.put(maps[i].toLowerCase(),\n                    new SingleByteEncoding(maps[i+1]));\n  }\n\n");
        bufferedWriter.write("  public static SingleByteEncoding get(String name) {\n    return (SingleByteEncoding)encodings.get(name.toLowerCase());\n  }\n}\n");
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private static boolean generateEncoding(String string, Writer writer) throws IOException {
        int n;
        String string2 = new String(bytes256, string);
        int n2 = 0;
        while (n2 < 256) {
            n = string2.charAt(n2);
            switch (n) {
                case 92: {
                    writer.write("\\\\");
                    break;
                }
                case 39: {
                    writer.write("\\'");
                    break;
                }
                case 34: {
                    writer.write("\\\"");
                    break;
                }
                case 10: {
                    writer.write("\\n");
                    break;
                }
                case 13: {
                    writer.write("\\r");
                    break;
                }
                default: {
                    writer.write("\\u");
                    String string3 = Integer.toString(n, 16);
                    int n3 = string3.length();
                    while (n3 < 4) {
                        writer.write(48);
                        ++n3;
                    }
                    writer.write(string3);
                }
            }
            ++n2;
        }
        n = 1;
        int n4 = 0;
        while (n4 < 128) {
            if (string2.charAt(n4) != n4) {
                n = 0;
                break;
            }
            ++n4;
        }
        return n != 0;
    }

    static {
        int n = 0;
        while (n < 256) {
            genmaps.bytes256[n] = (byte)n;
            ++n;
        }
    }
}

