/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledittool.convert;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.process.ProcessCommand;
import com.xmlmind.xmleditapp.process.ProcessCommandItem;
import com.xmlmind.xmleditapp.process.SubProcessItem;
import com.xmlmind.xmleditapp.process.TransformItem;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class ConvertDoc
extends App
implements Console {
    private String guiSpecLocation;
    private boolean listEnv;
    private URL styleSheetURL;
    private ArrayList parameters = new ArrayList();
    private String commandName;
    private URL docURL;
    private String[] arguments;
    private boolean verbose;

    public ConvertDoc(HashMap hashMap) {
        super(hashMap);
        this.guiSpecLocation = (String)hashMap.get("guiSpecLocation");
        if (this.guiSpecLocation != null) {
            this.initGUISpecLocation(this.guiSpecLocation);
        }
    }

    public ConvertDoc() {
    }

    public void initGUISpecLocation(String string) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.guiSpecLocation = string;
    }

    public String getGUISpecLocation() {
        return this.guiSpecLocation;
    }

    protected void doInitialize() {
        Locale.setDefault(Locale.US);
        this.parseArgs();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        this.doInitialize1(linkedHashMap, linkedHashMap2);
        this.doInitialize2(linkedHashMap, linkedHashMap2);
        if (this.listEnv) {
            this.listEnv();
        } else {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.run();
        }
        System.exit(0);
    }

    protected Preferences loadPreferences() {
        File file = null;
        if (this.userPreferencesDirectory != null) {
            file = new File(this.userPreferencesDirectory, "preferences.properties");
        }
        Preferences preferences = new Preferences(file == null || !file.isFile() ? null : file, "");
        preferences.putBoolean("warnAboutLossOfPhysicalStructure", false);
        preferences.putBoolean("infoAboutReadOnlyInclusions", false);
        return preferences;
    }

    protected void createGUI(HashMap hashMap) {
    }

    protected void showConfigErrors(String[] stringArray, HashMap hashMap, HashMap hashMap2, HashMap hashMap3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer.append("Start Errors:\n");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("- ");
                stringBuffer.append(stringArray[n]);
                stringBuffer.append('\n');
                ++n;
            }
            stringBuffer.append('\n');
        }
        if (hashMap != null && hashMap.size() > 0) {
            stringBuffer.append("GUI Errors:\n");
            ConvertDoc.appendErrors(hashMap, stringBuffer);
            stringBuffer.append('\n');
        }
        if (hashMap2 != null && hashMap2.size() > 0) {
            stringBuffer.append("Plug-in Errors:\n");
            ConvertDoc.appendErrors(hashMap2, stringBuffer);
            stringBuffer.append('\n');
        }
        if (hashMap3 != null && hashMap3.size() > 0) {
            stringBuffer.append("Configuration Errors:\n");
            ConvertDoc.appendErrors(hashMap3, stringBuffer);
            stringBuffer.append('\n');
        }
        ConvertDoc.fatalError(stringBuffer.toString());
    }

    private static final void appendErrors(HashMap hashMap, StringBuffer stringBuffer) {
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            stringBuffer.append("- ");
            stringBuffer.append(k.toString());
            stringBuffer.append('\n');
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("-- ");
                stringBuffer.append((String)arrayList.get(n2));
                stringBuffer.append('\n');
                ++n2;
            }
        }
    }

    public void addOpenedDocument(OpenedDocument openedDocument) {
    }

    public void removeOpenedDocument(OpenedDocument openedDocument) {
    }

    public OpenedDocument[] getOpenedDocuments() {
        return new OpenedDocument[0];
    }

    public void addEditor(Editor editor, Object object) {
    }

    public void removeEditor(Editor editor) {
    }

    public Editor[] getEditors() {
        return new Editor[0];
    }

    public void setActiveEditor(Editor editor) {
    }

    public Editor getActiveEditor() {
        return null;
    }

    public Component getDialogParent() {
        return null;
    }

    public void waitCursor(boolean bl) {
    }

    protected void doShowStatus(String string) {
        if (string != null && string.length() > 0) {
            this.info(string);
        }
    }

    private void parseArgs() {
        String string;
        int n = 0;
        while (n < this.commandLineArguments.length) {
            string = this.commandLineArguments[n];
            if ("-p".equals(string)) {
                if (n + 2 >= this.commandLineArguments.length) {
                    ConvertDoc.usage("too few arguments");
                }
                this.parameters.add(this.commandLineArguments[n + 1]);
                this.parameters.add(this.commandLineArguments[n + 2]);
                n += 2;
            } else if ("-t".equals(string)) {
                if (n + 1 >= this.commandLineArguments.length) {
                    ConvertDoc.usage("too few arguments");
                }
                this.styleSheetURL = ConvertDoc.toURL(this.commandLineArguments[n + 1], true);
                if (this.styleSheetURL == null) {
                    ConvertDoc.usage("'" + this.commandLineArguments[n + 1] + "' not a file or URL");
                }
                ++n;
            } else if ("-v".equals(string)) {
                this.verbose = true;
            } else if ("-l".equals(string)) {
                this.listEnv = true;
            } else {
                if (!string.startsWith("-")) break;
                ConvertDoc.usage("'" + string + "' unknown option");
            }
            ++n;
        }
        if (this.listEnv) {
            return;
        }
        if (n + 1 >= this.commandLineArguments.length) {
            ConvertDoc.usage("too few arguments");
        }
        this.commandName = this.commandLineArguments[n];
        string = this.commandLineArguments[n + 1];
        if (this.commandLineArguments.length > (n += 2)) {
            this.arguments = new String[(this.commandLineArguments.length - n) / 2];
            int n2 = 0;
            while (n < this.commandLineArguments.length) {
                String string2 = this.commandLineArguments[n];
                if ("-s".equals(string2) || "-u".equals(string2)) {
                    String string3;
                    if (n + 1 >= this.commandLineArguments.length) {
                        ConvertDoc.usage("too few arguments");
                    }
                    if ("-u".equals(string2)) {
                        URL uRL = ConvertDoc.toURL(this.commandLineArguments[n + 1], false);
                        if (uRL == null) {
                            ConvertDoc.usage("'" + this.commandLineArguments[n + 1] + "' not a file or URL");
                        }
                        string3 = uRL.toExternalForm();
                    } else {
                        string3 = this.commandLineArguments[n + 1];
                    }
                    this.arguments[n2++] = string3;
                    ++n;
                } else {
                    ConvertDoc.usage("'" + string2 + "' unknown option");
                }
                ++n;
            }
        } else {
            this.arguments = new String[0];
        }
        this.docURL = ConvertDoc.toURL(string, true);
        if (this.docURL == null) {
            ConvertDoc.usage("'" + string + "' not a file or URL");
        }
    }

    private static final URL toURL(String string, boolean bl) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null) {
            File file = new File(string);
            uRL = bl && !file.isFile() ? null : FileUtil.fileToURL(file);
        }
        return uRL;
    }

    private static void usage(String string) {
        if (string != null) {
            ConvertDoc.error(string);
        }
        System.err.println("usage: convertdoc -l |\nconvertdoc ?-v? ?-t XSLT_stylesheet_file_or_URL?\n   ?-p XSLT_stylesheet_param_name XSLT_stylesheet_param_value? ...\n   ?-p XSLT_stylesheet_param_name XSLT_stylesheet_param_value?\n   process_command_name doc_file_or_URL\n   ?-s|-u process_command_arg? ... ?-s|-u process_command_arg?\n\nConverts XML document doc_file_or_URL using process command\ncalled process_command_name, found in any of the XXE\nconfiguration files scanned during the startup of convertdoc.\n\nOptions:\n-l\n    Print XXE configuration and exit.\n-v\n    Turn verbosity on.\n-t XSLT_stylesheet_file_or_URL\n    Use this alternate XSLT style sheet instead of the one\n    specified in the first the first <transform>\n    child element of the process command.\n-p XSLT_stylesheet_param_name XSLT_stylesheet_param_value\n    Add/replace corresponding XSLT style sheet parameter in\n    the first <transform> child element of the process command.\n-s|-u process_command_arg ... -s|-u process_command_arg\n    Pass these arguments to the process command as the values of\n    process variables %0, %1, ..., %9.\n    If -s (String) is specified, the argument is passed as is.\n    If -u (URL) is specified, the argument, a file or directory\n    name, is first converted to an URL.");
        System.exit(1);
    }

    private void listEnv() {
        URL[] uRLArray;
        ClassLoader classLoader;
        int n;
        if (this.configurationURLs.length > 0) {
            System.out.println("Configurations:");
            n = 0;
            while (n < this.configurationURLs.length) {
                System.out.print("  ");
                System.out.println(this.configurationURLs[n]);
                ++n;
            }
        }
        if (this.xmlCatalogURLs.length > 0) {
            System.out.println("\nXML catalogs:");
            n = 0;
            while (n < this.xmlCatalogURLs.length) {
                System.out.print("  ");
                System.out.println(this.xmlCatalogURLs[n]);
                ++n;
            }
        }
        if (this.formatPluginClassNames.length > 0) {
            System.out.println("\nFormat plug-ins:");
            n = 0;
            while (n < this.formatPluginClassNames.length) {
                System.out.print("  ");
                System.out.println(this.formatPluginClassNames[n]);
                ++n;
            }
        }
        if (this.foProcessorPluginClassNames.length > 0) {
            System.out.println("\nFO processor plug-ins:");
            n = 0;
            while (n < this.foProcessorPluginClassNames.length) {
                System.out.print("  ");
                System.out.println(this.foProcessorPluginClassNames[n]);
                ++n;
            }
        }
        if (this.imageToolkitPluginClassNames.length > 0) {
            System.out.println("\nImage toolkit plug-ins:");
            n = 0;
            while (n < this.imageToolkitPluginClassNames.length) {
                System.out.print("  ");
                System.out.println(this.imageToolkitPluginClassNames[n]);
                ++n;
            }
        }
        if (this.dictionaryURLs.length > 0) {
            System.out.println("\nSpell checker dictionaries:");
            n = 0;
            while (n < this.dictionaryURLs.length) {
                System.out.print("  ");
                System.out.println(this.dictionaryURLs[n]);
                ++n;
            }
        }
        if (this.guiSpecLocation != null) {
            System.out.println("\nGUI specification: " + this.guiSpecLocation);
        }
        if ((classLoader = this.getClass().getClassLoader()) instanceof URLClassLoader && (uRLArray = ((URLClassLoader)classLoader).getURLs()) != null && uRLArray.length > 0) {
            System.out.println("\nClass path:");
            int n2 = 0;
            while (n2 < uRLArray.length) {
                System.out.print("  ");
                System.out.println(uRLArray[n2]);
                ++n2;
            }
        }
    }

    private void run() {
        Object object;
        OpenedDocument openedDocument = this.createOpenedDocument();
        if (!openedDocument.opening(this.docURL) || !openedDocument.open(this.docURL)) {
            ConvertDoc.fatalError("cannot open '" + this.docURL + "'");
        }
        Document document = openedDocument.getDocument();
        Command command = Commands.getCommand(this.commandName);
        if (command == null) {
            ConvertDoc.fatalError("command '" + this.commandName + "' not found");
        }
        if (!(command instanceof ProcessCommand)) {
            ConvertDoc.fatalError("command '" + this.commandName + "' is not a process command");
        }
        ProcessCommand processCommand = (ProcessCommand)command;
        int n = this.parameters.size();
        if (n > 0 || this.styleSheetURL != null) {
            object = ConvertDoc.findTransformItem(processCommand);
            if (object == null) {
                ConvertDoc.fatalError("cannot apply -t and/or -p options: process command '" + this.commandName + "' (and, recursively, all its <subProcess> children)" + " has no <transform> child element");
            }
            if (this.styleSheetURL != null) {
                ((TransformItem)object).setStyleSheet(this.styleSheetURL.toExternalForm());
            }
            if (n > 0) {
                String[] stringArray;
                String[] stringArray2 = ((TransformItem)object).getParameters();
                if (stringArray2 != null && stringArray2.length > 0) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        hashMap.put(stringArray2[n2], stringArray2[n2 + 1]);
                        n2 += 2;
                    }
                    int n3 = 0;
                    while (n3 < n) {
                        hashMap.put((String)this.parameters.get(n3), (String)this.parameters.get(n3 + 1));
                        n3 += 2;
                    }
                    stringArray = new String[hashMap.size() * 2];
                    int n4 = 0;
                    Iterator iterator = hashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        stringArray[n4++] = (String)entry.getKey();
                        stringArray[n4++] = (String)entry.getValue();
                    }
                } else {
                    stringArray = new String[n];
                    this.parameters.toArray(stringArray);
                }
                ((TransformItem)object).setParameters(stringArray);
            }
        }
        if ((object = processCommand.execute(document, this.arguments, this)) != null) {
            ConvertDoc.fatalError((String)object);
        }
    }

    private static final TransformItem findTransformItem(ProcessCommand processCommand) {
        TransformItem transformItem = null;
        ProcessCommandItem[] processCommandItemArray = processCommand.getItems();
        int n = 0;
        while (n < processCommandItemArray.length) {
            if (processCommandItemArray[n] instanceof TransformItem) {
                transformItem = (TransformItem)processCommandItemArray[n];
                break;
            }
            ++n;
        }
        if (transformItem == null) {
            int n2 = 0;
            while (n2 < processCommandItemArray.length) {
                if (processCommandItemArray[n2] instanceof SubProcessItem) {
                    SubProcessItem subProcessItem = (SubProcessItem)processCommandItemArray[n2];
                    ProcessCommand processCommand2 = null;
                    Command command = Commands.getCommand(subProcessItem.getCommandName());
                    if (command != null && command instanceof ProcessCommand) {
                        processCommand2 = (ProcessCommand)command;
                    }
                    if (processCommand2 != null && (transformItem = ConvertDoc.findTransformItem(processCommand2)) != null) break;
                }
                ++n2;
            }
        }
        return transformItem;
    }

    public void showMessage(String string, int n) {
        if (this.verbose) {
            String string2 = "";
            switch (n) {
                case 1: {
                    string2 = "warning: ";
                    break;
                }
                case 2: {
                    string2 = "error: ";
                }
            }
            this.info(string2 + string);
        }
    }

    private void info(String string) {
        if (this.verbose) {
            System.out.println("convertdoc: " + string);
        }
    }

    private static void warning(String string) {
        System.err.println("convertdoc: warning: " + string);
    }

    private static void error(String string) {
        System.err.println("convertdoc: *** error: " + string);
    }

    private static void fatalError(String string) {
        ConvertDoc.error(string);
        System.exit(2);
    }
}

