/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledittool.deploy;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledittool.deploy.DeployTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class DeployApplet
extends DeployTool {
    private String defaultCharset;
    private String charset;
    private String name;
    private int width;
    private boolean percent;
    private int height;
    private int defaultVersion;
    private int version;
    private ArrayList preferencesList;
    private File preferencesFile;
    private int hoursBeforeDeletingLocalCopy;
    private File indexFile;
    private PrintWriter index;
    private static final int HOURS_BEFORE_DELETING_LOCAL_COPY = 48;

    public static void main(String[] stringArray) {
        DeployApplet deployApplet = new DeployApplet();
        deployApplet.run(stringArray);
    }

    public DeployApplet() {
        super("deployapplet", "applet");
    }

    protected String[] getExcludedJarNames() {
        return new String[]{"xsdvalid.jar", "xxe_tool.jar", "xxe_help.jar", "kunststoff.jar"};
    }

    protected void parseOptions(String[] stringArray) {
        this.charset = this.defaultCharset = FileUtil.defaultEncoding();
        this.name = "XXE";
        this.width = 90;
        this.percent = true;
        this.height = 550;
        this.version = this.defaultVersion = (int)((System.currentTimeMillis() - 1133513321620L) / 1000L);
        this.preferencesList = new ArrayList();
        this.preferencesFile = null;
        this.hoursBeforeDeletingLocalCopy = 48;
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2 = stringArray[n];
            if ("-version".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                try {
                    this.version = Integer.parseInt(stringArray[++n]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.version = -1;
                }
                if (this.version < 0) {
                    this.usage(null);
                }
            } else if ("-pref".equals(string2)) {
                if (n + 2 >= stringArray.length) {
                    this.usage(null);
                }
                string = stringArray[++n].trim();
                String string3 = stringArray[++n];
                if (string.length() == 0) {
                    this.usage("empty preference key");
                }
                this.preferencesList.add(string);
                this.preferencesList.add(string3);
            } else if ("-prefs".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.preferencesFile = new File(stringArray[++n]);
                if (!this.preferencesFile.isFile()) {
                    this.usage("'" + this.preferencesFile + "' is not a file");
                }
            } else if ("-width".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                if ((string = stringArray[++n]).endsWith("%")) {
                    this.percent = true;
                    string = string.substring(0, string.length() - 1);
                } else {
                    this.percent = false;
                }
                try {
                    this.width = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.width = -1;
                }
                if (this.width <= 0) {
                    this.usage(null);
                }
            } else if ("-height".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                try {
                    this.height = Integer.parseInt(stringArray[++n]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.height = -1;
                }
                if (this.height <= 0) {
                    this.usage(null);
                }
            } else if ("-name".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.name = stringArray[++n];
            } else if ("-keepcopy".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                try {
                    this.hoursBeforeDeletingLocalCopy = Integer.parseInt(stringArray[++n]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.hoursBeforeDeletingLocalCopy = -1;
                }
                if (this.hoursBeforeDeletingLocalCopy <= 0) {
                    this.usage(null);
                }
            } else if ("-charset".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.charset = stringArray[++n];
                try {
                    Charset.forName(this.charset);
                }
                catch (Exception exception) {
                    this.usage("'" + this.charset + "' unknown charset");
                }
            } else if ("-storepass".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.storepass = stringArray[++n];
            } else if ("-keystore".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.keystore = stringArray[++n];
            } else if ("-keypass".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.keypass = stringArray[++n];
            } else if ("-alias".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.alias = stringArray[++n];
            } else if ("-online".equals(string2)) {
                this.online = true;
            } else if ("-selfsigner".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage(null);
                }
                this.genkeyDname = stringArray[++n];
                if (!DeployTool.checkDname(this.genkeyDname)) {
                    System.err.println(DeployTool.dnameHelpString());
                    System.exit(1);
                }
            } else if ("-quiet".equals(string2)) {
                this.quiet = true;
            } else {
                this.usage(null);
            }
            ++n;
        }
    }

    private void usage(String string) {
        if (string != null) {
            System.err.println("*** error: " + string);
        }
        System.err.println("usage: deployapplet ?options?\nOptions are:\n  -storepass <password> Password for keystore.\n      Default: teststorepass\n  -keystore <url> Keystore location.\n      Default: <XXE_install_dir>/applet/testkeystore\n  -keypass <password> Password for private key.\n      Default: testkeypass\n  -alias <alias> Alias of keystore entry.\n      Default: " + this.defaultAlias + "\n" + "\n" + "  -width <width> Specifies the width of the applet\n" + "      in pixels (no unit) or in percent (ends with '%')\n" + "      Default: 90%\n" + "  -height <height> Specifies the height of the applet\n" + "      in pixels\n" + "      Default: 550\n" + "\n" + "  -prefs <properties file> Java[tm] .properties file\n" + "      specifying user preferences. Content similar to\n" + "      <XXE_user_preferences_dir>/preferences.properties.\n" + "      Default: none (built-in defaults)\n" + "  -pref <key> <value> Specifies a single user preference.\n" + "      Up to 20 -pref command-line options may be used.\n" + "      Overrides user preferences specified using -prefs.\n" + "      Default: none (built-in defaults)\n" + "\n" + "  -keepcopy <hours> The local copy of a document is deleted\n" + "      after specified number of hours following its\n" + "      last modification.\n" + "      Default: " + 48 + "\n" + "\n" + "Advanced options:\n" + "  -name <name> Specifies the name of the applet\n" + "      (useful for scripting it)\n" + "      Default: XXE\n" + "\n" + "  -version <version> Specifies a version number\n" + "      (decimal, >=0) for *current deployment*.\n" + "      The hexadecimal, composite, version number of\n" + "      the *cached applet* is built using <XXE_major>,\n" + "      <XXE_minor>, <XXE_patch> and specified <version>\n" + "      Default: automatically generated (which gives composite\n" + "      version number '" + DeployApplet.hexVersion(this.defaultVersion) + "')\n" + "\n" + "  -charset <charset> Specifies the charset of the generated\n" + "      index.html\n" + "      Default: " + this.defaultCharset + " (platform native)\n" + "\n" + "  -selfsigner <dname> Specifies a distinguished name (dname)\n" + "      for *testkeystore*.\n" + "      Ignored unless testkeystore is used. That is, this\n" + "      option is ignored when a real certificate is used.\n" + "      Use '-selfsigner help' to print a description of\n" + "      the syntax of distinguished names.\n" + "      Default: CN=" + this.defaultAlias + "\n" + "\n" + "  -online Force the applet to download its configuration\n" + "      files from its server.\n" + "\n" + "  -quiet Turns verbosity off.");
        System.exit(1);
    }

    protected void beginProcess() {
        try {
            this.indexFile = new File(this.deployDir, "index.html");
            this.index = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.indexFile), this.charset), true);
        }
        catch (Exception exception) {
            this.fatalError("cannot create file " + this.indexFile + ": " + MiscUtil.reason(exception));
        }
        this.index.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.index.println("<html>");
        this.index.println("<head>");
        this.index.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.charset + "\" />");
        String string = XMLUtil.escapeXML("XMLmind XML Editor Professional Edition V3.0p1");
        this.index.println("<title>" + string + "</title>");
        this.index.println("</head>");
        this.index.println("<body>");
        this.index.println("<h1>" + string + "</h1>");
    }

    protected String onlinePath(String string) {
        return string;
    }

    protected void processJarFiles(File[] fileArray) {
        String string = DeployApplet.joinEscaped(fileArray);
        this.index.print("<applet name=\"");
        this.index.print(XMLUtil.escapeXML(this.name));
        this.index.print("\" mayscript width=\"");
        this.index.print(this.width);
        if (this.percent) {
            this.index.print('%');
        }
        this.index.print("\" height=\"");
        this.index.print(this.height);
        this.index.print("\"");
        this.index.print("\n  code=\"com/xmlmind/xmleditapp/applet/XMLEditorApplet.class\"");
        this.index.print("\n  archive=\"");
        this.index.print(string);
        this.index.println("\">\n");
        this.index.println("  <param name=\"cache_archive\"");
        this.index.print("    value=\"");
        this.index.print(string);
        this.index.println("\" />\n");
        String string2 = DeployApplet.hexVersion(this.version);
        this.index.println("  <param name=\"cache_version\"");
        this.index.print("    value=\"");
        int n = 0;
        while (n < fileArray.length) {
            if (n > 0) {
                this.index.print(',');
            }
            this.index.print(string2);
            ++n;
        }
        this.index.println("\" />\n");
        this.index.println("  <param name=\"cache_version_ex\"");
        this.index.print("    value=\"");
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (n2 > 0) {
                this.index.print(',');
            }
            this.index.print(XMLUtil.escapeXML(fileArray[n2].getName()));
            this.index.print(";preload;");
            this.index.print(string2);
            ++n2;
        }
        this.index.println("\" />\n");
        if (this.hoursBeforeDeletingLocalCopy != 48) {
            this.index.println("  <param name=\"hoursBeforeDeletingLocalCopy\"");
            this.index.print("    value=\"");
            this.index.print(this.hoursBeforeDeletingLocalCopy);
            this.index.println("\" />\n");
        }
        if (this.preferencesFile != null) {
            if (!this.quiet) {
                System.out.println("copying '" + this.preferencesFile + "' to " + this.deployDir);
            }
            String string3 = this.preferencesFile.getName();
            try {
                FileUtil.copyFile(this.preferencesFile, new File(this.deployDir, string3));
            }
            catch (IOException iOException) {
                this.fatalError("cannot copy " + this.preferencesFile + " to " + this.deployDir + ": " + MiscUtil.reason(iOException));
            }
            this.index.println("  <param name=\"preferences\"");
            this.index.print("    value=\"");
            this.index.print(XMLUtil.escapeXML(string3));
            this.index.println("\" />\n");
        }
        int n3 = Math.min(40, this.preferencesList.size());
        int n4 = 0;
        while (n4 < n3) {
            String string4 = (String)this.preferencesList.get(n4);
            String string5 = (String)this.preferencesList.get(n4 + 1);
            this.index.print("  <param name=\"preference");
            this.index.print(n4 / 2);
            this.index.println("\"");
            this.index.print("    value=\"");
            this.index.print(XMLUtil.escapeXML(string4));
            this.index.print('=');
            this.index.print(XMLUtil.escapeXML(string5));
            this.index.println("\" />\n");
            n4 += 2;
        }
    }

    private static final String joinEscaped(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fileArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(XMLUtil.escapeXML(fileArray[n].getName()));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final String hexVersion(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(768));
        stringBuffer.append('.');
        stringBuffer.append(Integer.toHexString(1));
        stringBuffer.append('.');
        stringBuffer.append(Integer.toHexString(n >> 16 & 0xFFFF));
        stringBuffer.append('.');
        stringBuffer.append(Integer.toHexString(n & 0xFFFF));
        return stringBuffer.toString();
    }

    protected void processGUISpecLocation(String string) {
        this.index.println("  <param name=\"guiSpecification\"\n    value=\"" + XMLUtil.escapeXML(string) + "\" />\n");
    }

    protected void processConfigurationLocations(String[] stringArray) {
        this.index.println("  <param name=\"configurations\"\n    value=\"" + DeployTool.joinEscaped(stringArray) + "\" />\n");
    }

    protected void processXMLCatalogLocations(String[] stringArray) {
        this.index.println("  <param name=\"catalogs\"\n    value=\"" + DeployTool.joinEscaped(stringArray) + "\" />\n");
    }

    protected void processFormatPluginClassNames(String[] stringArray) {
        this.index.println("  <param name=\"formatPluginClassNames\"\n    value=\"" + DeployTool.joinEscaped(stringArray) + "\" />\n");
    }

    protected void processFOProcessorPluginClassNames(String[] stringArray) {
        this.index.println("  <param name=\"foProcessorPluginClassNames\"\n    value=\"" + DeployTool.joinEscaped(stringArray) + "\" />\n");
    }

    protected void processImageToolkitPluginClassNames(String[] stringArray) {
        this.index.println("  <param name=\"imageToolkitPluginClassNames\"\n    value=\"" + DeployTool.joinEscaped(stringArray) + "\" />\n");
    }

    protected void endProcess() {
        this.index.println("This applet requires the Java<sup>TM</sup> Plug-in 1.4.1+.<br />\nThe Java Plug-in is part of the Java 2 Runtime Environment,\nStandard Edition (JRE).<br />\nPlease download the JRE from\n<a href=\"http://java.sun.com/getjava/download.html\">http://java.sun.com/getjava/download.html</a>\nand install it on your computer.");
        this.index.println("</applet>");
        this.index.println("</body>");
        this.index.println("</html>\n");
        this.index.flush();
        this.index.close();
        if (this.index.checkError()) {
            this.fatalError("cannot write '" + this.indexFile + "'");
        }
    }
}

