/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledittool.deploy;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.start.Start;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public abstract class DeployTool {
    protected String toolName;
    protected String deployDirName;
    protected String keystore;
    protected String storepass;
    protected String keypass;
    protected String defaultAlias;
    protected String alias;
    protected String genkeyDname;
    protected boolean online;
    protected boolean quiet;
    protected File appDir;
    protected File addonDir;
    protected File deployDir;
    protected File addonJarFile;
    protected static final String[] NO_STRINGS = new String[0];
    protected static final File[] NO_FILES = new File[0];
    protected static final String TITLE = "XMLmind XML Editor Professional Edition V3.0p1";

    protected DeployTool(String string, String string2) {
        this.toolName = string;
        this.deployDirName = string2;
    }

    protected void error(String string) {
        System.err.println(this.toolName + ": error: " + string + "\n");
    }

    protected void fatalError(String string) {
        this.error(string);
        System.exit(2);
    }

    protected void run(String[] stringArray) {
        Object object;
        Object object2;
        String[] stringArray2;
        URL[] uRLArray;
        URL[] uRLArray2;
        this.keystore = null;
        this.storepass = "teststorepass";
        this.keypass = "testkeypass";
        this.alias = this.defaultAlias = System.getProperty("user.name");
        if (this.alias == null) {
            this.defaultAlias = "test";
            this.alias = "test";
        }
        this.genkeyDname = "CN=" + this.defaultAlias;
        this.online = false;
        this.quiet = false;
        this.parseOptions(stringArray);
        this.init();
        this.beginProcess();
        Start start = new Start();
        start.scanAddonDir(this.addonDir);
        String[] stringArray3 = start.getErrors();
        if (stringArray3.length > 0) {
            int n = 0;
            while (n < stringArray3.length) {
                this.error(stringArray3[n]);
                ++n;
            }
            System.exit(3);
        }
        String[] stringArray4 = this.getExcludedJarNames();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        URL[] uRLArray3 = start.getClassPath();
        int n = 0;
        while (n < uRLArray3.length) {
            uRLArray2 = FileUtil.urlToFile(uRLArray3[n]);
            String string = uRLArray2.getName();
            if (string.endsWith(".jar") && !StringUtil.contains(stringArray4, string)) {
                arrayList.add(this.copySignJar((File)uRLArray2));
            }
            ++n;
        }
        if (this.online) {
            if (!this.quiet) {
                System.out.println("unzipping \"" + this.addonJarFile + "\" in \"" + this.deployDir + "\" and then deleting it");
            }
            try {
                DeployTool.unzip(this.addonJarFile, this.deployDir);
            }
            catch (IOException iOException) {
                this.fatalError("cannot unzip \"" + this.addonJarFile + "\" in \"" + this.deployDir + "\": " + MiscUtil.reason(iOException));
            }
            if (!this.addonJarFile.delete()) {
                this.error("cannot delete \"" + this.addonJarFile + "\"");
            }
        } else {
            this.signJar(this.addonJarFile);
            arrayList.add(this.addonJarFile);
        }
        uRLArray2 = start.getDictionaries();
        int n2 = 0;
        while (n2 < uRLArray2.length) {
            File file = FileUtil.urlToFile(uRLArray2[n2]);
            arrayList.add(this.copySignJar(file));
            ++n2;
        }
        this.processJarFiles(arrayList.toArray(NO_FILES));
        int n3 = FileUtil.fileToURL(this.appDir).toExternalForm().length();
        URL uRL = start.getGUISpecURL();
        if (uRL != null) {
            uRLArray = uRL.toExternalForm().substring(n3);
            String string = this.online ? this.onlinePath((String)uRLArray) : "addon:" + uRLArray.substring(6);
            this.processGUISpecLocation(string);
        }
        arrayList.clear();
        uRLArray = start.getConfigurations();
        if (uRLArray.length > 0) {
            int n4 = 0;
            while (n4 < uRLArray.length) {
                stringArray2 = uRLArray[n4];
                object2 = stringArray2.toExternalForm().substring(n3);
                object = this.online ? this.onlinePath((String)object2) : "addon:" + ((String)object2).substring(6);
                arrayList.add(object);
                ++n4;
            }
            this.processConfigurationLocations(arrayList.toArray(NO_STRINGS));
        }
        arrayList.clear();
        URL[] uRLArray4 = start.getXMLCatalogs();
        if (uRLArray4.length > 0) {
            int n5 = 0;
            while (n5 < uRLArray4.length) {
                object2 = uRLArray4[n5];
                object = ((URL)object2).toExternalForm().substring(n3);
                String string = this.online ? this.onlinePath((String)object) : "addon:" + ((String)object).substring(6);
                arrayList.add(string);
                ++n5;
            }
            this.processXMLCatalogLocations(arrayList.toArray(NO_STRINGS));
        }
        if ((stringArray2 = start.getFormatPluginClassNames()).length > 0) {
            this.processFormatPluginClassNames(stringArray2);
        }
        if (((String[])(object2 = start.getFOProcessorPluginClassNames())).length > 0) {
            this.processFOProcessorPluginClassNames((String[])object2);
        }
        if (((String[])(object = start.getImageToolkitPluginClassNames())).length > 0) {
            this.processImageToolkitPluginClassNames((String[])object);
        }
        this.endProcess();
    }

    protected String[] getExcludedJarNames() {
        return new String[]{"xsdvalid.jar", "xxe_tool.jar"};
    }

    protected void init() {
        this.findAppDir();
        this.createDeployDir();
        this.createDefaultKeystore();
        this.createAddonJar();
    }

    protected void findAppDir() {
        this.appDir = Start.appDir();
        if (this.appDir == null) {
            this.fatalError("cannot find XMLmind XML Editor install directory");
        }
        this.addonDir = new File(this.appDir, "addon");
        if (!this.addonDir.isDirectory()) {
            this.fatalError("\"" + this.addonDir + "\" is not a directory");
        }
    }

    protected void createDeployDir() {
        this.deployDir = new File(this.appDir, this.deployDirName);
        if (this.deployDir.exists()) {
            FileUtil.removeFile(this.deployDir, true);
        }
        if (!this.deployDir.mkdir()) {
            this.fatalError("cannot create directory " + this.deployDir);
        }
    }

    protected void createDefaultKeystore() {
        String string = new File(this.deployDir, "testkeystore").getPath();
        if (this.keystore == null) {
            this.keystore = string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("keytool -genkey -keyalg rsa -storepass teststorepass");
        stringBuffer.append(" -keystore ");
        DeployTool.appendQuoted(stringBuffer, string);
        stringBuffer.append(" -validity 365 -keypass testkeypass -alias ");
        DeployTool.appendQuoted(stringBuffer, this.defaultAlias);
        stringBuffer.append(" -dname ");
        DeployTool.appendQuoted(stringBuffer, this.genkeyDname);
        this.shellExec(stringBuffer.toString());
    }

    protected static final void appendQuoted(StringBuffer stringBuffer, String string) {
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    protected void shellExec(String string) {
        String[] stringArray = new String[2];
        int n = 0;
        try {
            n = PlatformUtil.shellExec(string, stringArray);
        }
        catch (Exception exception) {
            this.fatalError("cannot execute command \"" + string + "\": " + MiscUtil.reason(exception));
        }
        if (stringArray[0] != null && stringArray[0].length() > 0) {
            System.out.println(stringArray[0]);
        }
        if (stringArray[1] != null && stringArray[1].length() > 0) {
            System.err.println(stringArray[1]);
        }
        if (n != 0) {
            this.fatalError("command \"" + string + "\" exited abnormally (status = " + n + ")");
        }
    }

    protected void createAddonJar() {
        this.addonJarFile = new File(this.deployDir, "xxe_addon.jar");
        if (!this.quiet) {
            System.out.println("creating  \"" + this.addonJarFile + "\" by zipping the content of \"" + this.addonDir + "\"");
        }
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.addonJarFile));
            this.jarAll(this.addonDir, "addon", zipOutputStream);
            zipOutputStream.finish();
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            this.fatalError("cannot create .jar file by zipping the content of \"" + this.addonDir + "\": " + MiscUtil.reason(iOException));
        }
    }

    protected void jarAll(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string + '/');
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (!string2.endsWith(".jar") && !string2.endsWith(".dar")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                stringBuffer.append('/');
                stringBuffer.append(string2);
                String string3 = stringBuffer.toString();
                File file2 = new File(file, string2);
                if (file2.isDirectory()) {
                    this.jarAll(file2, string3, zipOutputStream);
                } else {
                    zipEntry = new ZipEntry(string3);
                    zipOutputStream.putNextEntry(zipEntry);
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    DeployTool.copyBytes(fileInputStream, zipOutputStream);
                    ((InputStream)fileInputStream).close();
                    zipOutputStream.closeEntry();
                }
            }
            ++n;
        }
    }

    protected static final void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    protected File copySignJar(File file) {
        File file2 = this.copyJar(file);
        this.signJar(file2);
        return file2;
    }

    protected File copyJar(File file) {
        File file2;
        String string = file.getName();
        if (string.endsWith(".dar")) {
            string = string.substring(0, string.length() - 4) + "_dict.jar";
        }
        if ((file2 = new File(this.deployDir, string)).exists()) {
            String string2;
            String string3;
            int n = string.lastIndexOf(46);
            if (n < 0) {
                string3 = string;
                string2 = "";
            } else {
                string3 = string.substring(0, n);
                string2 = string.substring(n);
            }
            int n2 = 2;
            while (n2 < 100) {
                string = string3 + Integer.toString(n2) + string2;
                file2 = new File(this.deployDir, string);
                if (!file2.exists()) break;
                ++n2;
            }
        }
        if (!this.quiet) {
            System.out.println("copying \"" + file.getPath() + "\" to \"" + file2.getPath() + "\"");
        }
        try {
            FileUtil.copyFile(file.getPath(), file2.getPath());
        }
        catch (IOException iOException) {
            this.fatalError("cannot copy " + file + " to " + file2 + ": " + MiscUtil.reason(iOException));
        }
        return file2;
    }

    protected void signJar(File file) {
        if (!this.quiet) {
            System.out.println("signing \"" + file.getName() + "\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jarsigner -keystore ");
        DeployTool.appendQuoted(stringBuffer, this.keystore);
        stringBuffer.append(" -storepass ");
        DeployTool.appendQuoted(stringBuffer, this.storepass);
        stringBuffer.append(" -keypass ");
        DeployTool.appendQuoted(stringBuffer, this.keypass);
        stringBuffer.append(' ');
        DeployTool.appendQuoted(stringBuffer, file.getPath());
        stringBuffer.append(' ');
        DeployTool.appendQuoted(stringBuffer, this.alias);
        String string = stringBuffer.toString();
        this.shellExec(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void unzip(File file, File file2) throws IOException {
        file2 = file2.getCanonicalFile();
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                Object var10_9;
                ZipEntry zipEntry = enumeration.nextElement();
                File file3 = new File(DeployTool.fromEntryName(file2, zipEntry.getName()));
                if (zipEntry.isDirectory()) {
                    if (file3.isDirectory() || file3.mkdirs()) continue;
                    throw new IOException("cannot create directory '" + file3.getPath() + "'");
                }
                File file4 = file3.getParentFile();
                if (!file4.isDirectory() && !file4.mkdirs()) {
                    throw new IOException("cannot create directory '" + file4.getPath() + "'");
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    DeployTool.copyBytes(inputStream, fileOutputStream);
                    fileOutputStream.flush();
                    ((OutputStream)fileOutputStream).close();
                    var10_9 = null;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                {
                }
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
    }

    private static String fromEntryName(File file, String string) {
        int n = string.length();
        if (n > 1 && string.endsWith("/")) {
            string = string.substring(0, n - 1);
        }
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return file.getPath() + File.separatorChar + string;
    }

    protected abstract void parseOptions(String[] var1);

    protected abstract void beginProcess();

    protected abstract String onlinePath(String var1);

    protected abstract void processJarFiles(File[] var1);

    protected abstract void processGUISpecLocation(String var1);

    protected abstract void processConfigurationLocations(String[] var1);

    protected abstract void processXMLCatalogLocations(String[] var1);

    protected abstract void processFormatPluginClassNames(String[] var1);

    protected abstract void processFOProcessorPluginClassNames(String[] var1);

    protected abstract void processImageToolkitPluginClassNames(String[] var1);

    protected abstract void endProcess();

    protected static final boolean checkDname(String string) {
        String string2 = string;
        if (string.indexOf("\\,") >= 0) {
            string2 = StringUtil.replaceAll(string, "\\,", "\ue000");
        }
        int n = 0;
        String[] stringArray = StringUtil.split(string2, ',');
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2].trim();
            int n3 = string3.indexOf(61);
            if (n3 <= 0 || n3 >= string3.length() - 1) {
                return false;
            }
            String string4 = string3.substring(0, n3).trim().toUpperCase();
            String string5 = string3.substring(n3 + 1).trim();
            if (string5.length() == 0) {
                return false;
            }
            if ("CN".equals(string4)) {
                if (n >= 1) {
                    return false;
                }
                n = 1;
            } else if ("OU".equals(string4)) {
                if (n >= 2) {
                    return false;
                }
                n = 2;
            } else if ("O".equals(string4)) {
                if (n >= 3) {
                    return false;
                }
                n = 3;
            } else if ("L".equals(string4)) {
                if (n >= 4) {
                    return false;
                }
                n = 4;
            } else if ("S".equals(string4)) {
                if (n >= 5) {
                    return false;
                }
                n = 5;
            } else if ("C".equals(string4)) {
                if (n >= 6) {
                    return false;
                }
                n = 6;
            } else {
                return false;
            }
            ++n2;
        }
        return n > 0;
    }

    protected static final String dnameHelpString() {
        return "The syntax for distinguished names (dname) is:\nCN=cName,OU=orgUnit,O=org,L=city,S=state,C=countryCode\n\nwhere:\n  cName - common name of a person, e.g., 'Susan Jones'\n  orgUnit - department or division name, e.g., 'Purchasing'\n  org - large organization name, e.g., 'ABCSystems\\, Inc.'\n        (notice the '\\' used to protect the ',')\n  city - city name, e.g., 'Palo Alto'\n  state - state or province name, e.g., 'California'\n  countryCode - two-letter country code, e.g., 'CH'\n\nEach field must appear in the above order but\nit is not necessary to specify all fields.";
    }

    protected static final String joinEscaped(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(XMLUtil.escapeXML(stringArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }
}

