/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledittool.deploy;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledittool.deploy.DeployTool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Calendar;

public final class DeployWebStart
extends DeployTool {
    private String defaultCodebase;
    private String codebase;
    private boolean index;
    private File jnlpFile;
    private PrintWriter jnlp;
    private static final String INDEX_TEMPLATE = "<html>\n  <head>\n    <title>%TITLE%</title>\n  </head>\n  <body bgcolor='white'>\n    <table border='0' width='100%' cellpadding='10'>\n      <tr>\n        <td valign='top'><img src='logo64.gif' alt='XMLmind'></td>\n        <td><bold><font color='navy' size='+3'>%TITLE%</font></bold><br>\n        Copyright (c) 2000-%YEAR% Pixware SARL, all\n        rights reserved.<br>For more information, please visit <a\n        href='http://www.xmlmind.com/xmleditor/'\n        >http://www.xmlmind.com/xmleditor/</a>.</td>\n      </tr>\n      <tr>\n        <td align='center' colspan='2'><form><input\n        onclick='window.location.href=&quot;%CODEBASE%/xxe.jnlp&quot;'\n        value='Launch XMLmind XML Editor' type='button'></form></td>\n      </tr>\n      <tr>\n        <td colspan='2'><b>Required Software:</b> Launching XMLmind XML\n        Editor requires having Java<sup><small>TM</small></sup> runtime\n        version 1.4.1+ and Java<sup><small>TM</small></sup> Web Start\n        installed on your computer.  <br>You can download and install all\n        the required software from <a\n        href='http://java.sun.com/getjava/download.html'\n        >http://java.sun.com/getjava/download.html</a>.</td>\n      </tr>\n    </table>\n  </body>\n</html>";
    static /* synthetic */ Class class$com$xmlmind$xmledittool$deploy$DeployWebStart;

    public static void main(String[] stringArray) {
        DeployWebStart deployWebStart = new DeployWebStart();
        deployWebStart.run(stringArray);
    }

    public DeployWebStart() {
        super("deploywebstart", "webstart");
    }

    protected void parseOptions(String[] stringArray) {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = "127.0.0.1";
        }
        this.codebase = this.defaultCodebase = "http://" + string + "/xxe";
        this.index = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if ("-codebase".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage();
                }
                this.codebase = stringArray[++n];
            } else if ("-storepass".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage();
                }
                this.storepass = stringArray[++n];
            } else if ("-keystore".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage();
                }
                this.keystore = stringArray[++n];
            } else if ("-keypass".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage();
                }
                this.keypass = stringArray[++n];
            } else if ("-alias".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage();
                }
                this.alias = stringArray[++n];
            } else if ("-index".equals(string2)) {
                this.index = true;
            } else if ("-online".equals(string2)) {
                this.online = true;
            } else if ("-selfsigner".equals(string2)) {
                if (n + 1 >= stringArray.length) {
                    this.usage();
                }
                this.genkeyDname = stringArray[++n];
                if (!DeployTool.checkDname(this.genkeyDname)) {
                    System.err.println(DeployTool.dnameHelpString());
                    System.exit(1);
                }
            } else if ("-quiet".equals(string2)) {
                this.quiet = true;
            } else {
                this.usage();
            }
            ++n;
        }
    }

    private void usage() {
        System.err.println("usage: deploywebstart ?options?\nOptions are:\n  -codebase <url> (possibly virtual) path of directory\n      containing xxe.jnlp.\n      Default: " + this.defaultCodebase + "\n" + "\n" + "  -storepass <password> Password for keystore.\n" + "      Default: teststorepass\n" + "  -keystore <url> Keystore location.\n" + "      Default: <XXE_install_dir>/webstart/testkeystore\n" + "  -keypass <password> Password for private key.\n" + "      Default: testkeypass\n" + "  -alias <alias> Alias of keystore entry.\n" + "      Default: " + this.defaultAlias + "\n" + "\n" + "  -index Generate a simple index.html.\n" + "\n" + "Advanced options:\n" + "  -selfsigner <dname> Specifies a distinguished name (dname)\n" + "      for *testkeystore*.\n" + "      Ignored unless testkeystore is used. That is, this\n" + "      option is ignored when a real certificate is used.\n" + "      Use '-selfsigner help' to print a description of\n" + "      the syntax of distinguished names.\n" + "      Default: CN=" + this.defaultAlias + "\n" + "\n" + "  -online Do not allow user to work off-line by forcing XXE\n" + "      to download its configuration files from the server.\n" + "\n" + "  -quiet Turns verbosity off.");
        System.exit(1);
    }

    protected void beginProcess() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(1133513321620L);
        String string = Integer.toString(calendar.get(1));
        String string2 = "XMLmind XML Editor Professional Edition V3.0p1. Copyright (c) 2000-" + string + " Pixware SARL, all rights reserved.";
        this.copyIcon("logo32.gif", new File(this.deployDir, "logo32.gif"));
        this.copyIcon("logo64.gif", new File(this.deployDir, "logo64.gif"));
        if (this.index) {
            if (!this.quiet) {
                System.out.println("creating \"index.html\"...");
            }
            String string3 = StringUtil.replaceAll(INDEX_TEMPLATE, "%TITLE%", XMLUtil.escapeXML("XMLmind XML Editor Professional Edition V3.0p1"));
            string3 = StringUtil.replaceAll(string3, "%YEAR%", string);
            string3 = StringUtil.replaceAll(string3, "%CODEBASE%", XMLUtil.escapeXML(this.codebase));
            File file = new File(this.deployDir, "index.html");
            try {
                FileUtil.saveString(string3, file);
            }
            catch (Exception exception) {
                this.fatalError("cannot create \"" + file + "\": " + MiscUtil.reason(exception));
            }
        }
        try {
            this.jnlpFile = new File(this.deployDir, "xxe.jnlp");
            this.jnlp = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.jnlpFile), "UTF8"), true);
        }
        catch (Exception exception) {
            this.fatalError("cannot create file " + this.jnlpFile + ": " + MiscUtil.reason(exception));
        }
        this.jnlp.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        this.jnlp.println("<jnlp codebase=\"" + XMLUtil.escapeXML(this.codebase) + "\" href=\"xxe.jnlp\">");
        this.jnlp.println("  <information>");
        this.jnlp.println("    <title>" + XMLUtil.escapeXML("XMLmind XML Editor Professional Edition V3.0p1") + "</title>");
        this.jnlp.println("    <vendor>Pixware SARL</vendor>");
        this.jnlp.println("    <homepage href=\"http://www.xmlmind.com/xmleditor\"/>");
        this.jnlp.println("    <description>" + XMLUtil.escapeXML("XMLmind XML Editor Professional Edition V3.0p1") + "</description>");
        this.jnlp.println("    <description kind=\"short\">" + XMLUtil.escapeXML(string2) + "</description>");
        this.jnlp.println("    <icon href=\"logo64.gif\" width=\"64\" height=\"64\"/>");
        this.jnlp.println("    <icon href=\"logo32.gif\" width=\"32\" height=\"32\"/>");
        this.jnlp.println("  </information>");
        this.jnlp.println("  <security>");
        this.jnlp.println("    <all-permissions/>");
        this.jnlp.println("  </security>");
        this.jnlp.println("  <resources>");
        this.jnlp.println("    <j2se version=\"1.4+\" max-heap-size=\"128m\"/>");
    }

    private void copyIcon(String string, File file) {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream((class$com$xmlmind$xmledittool$deploy$DeployWebStart == null ? (class$com$xmlmind$xmledittool$deploy$DeployWebStart = DeployWebStart.class$("com.xmlmind.xmledittool.deploy.DeployWebStart")) : class$com$xmlmind$xmledittool$deploy$DeployWebStart).getResourceAsStream(string));
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[8192];
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.fatalError("cannot copy icon " + string + " to " + file + ": " + MiscUtil.reason(iOException));
        }
    }

    protected String onlinePath(String string) {
        return this.codebase + '/' + string;
    }

    protected void processJarFiles(File[] fileArray) {
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getName();
            this.jnlp.println("    <jar download=\"eager\" href=\"" + XMLUtil.escapeXML(string) + "\"/>");
            ++n;
        }
    }

    protected void processGUISpecLocation(String string) {
        this.jnlp.println("    <property name=\"XXE_WEB_START.guiSpecification\"\n      value=\"" + XMLUtil.escapeXML(string) + "\"/>");
    }

    protected void processConfigurationLocations(String[] stringArray) {
        this.jnlp.println("    <property name=\"XXE_WEB_START.configurations\"\n      value=\"" + DeployTool.joinEscaped(stringArray) + "\"/>");
    }

    protected void processXMLCatalogLocations(String[] stringArray) {
        this.jnlp.println("    <property name=\"XXE_WEB_START.catalogs\"\n      value=\"" + DeployTool.joinEscaped(stringArray) + "\"/>");
    }

    protected void processFormatPluginClassNames(String[] stringArray) {
        this.jnlp.println("    <property name=\"XXE_WEB_START.formatPluginClassNames\"\n      value=\"" + DeployTool.joinEscaped(stringArray) + "\"/>");
    }

    protected void processFOProcessorPluginClassNames(String[] stringArray) {
        this.jnlp.println("    <property name=\"XXE_WEB_START.foProcessorPluginClassNames\"\n      value=\"" + DeployTool.joinEscaped(stringArray) + "\"/>");
    }

    protected void processImageToolkitPluginClassNames(String[] stringArray) {
        this.jnlp.println("    <property name=\"XXE_WEB_START.imageToolkitPluginClassNames\"\n      value=\"" + DeployTool.joinEscaped(stringArray) + "\"/>");
    }

    protected void endProcess() {
        this.jnlp.println("  </resources>");
        this.jnlp.println("  <application-desc main-class=\"com.xmlmind.xmleditapp.start.WebStart\"/>");
        this.jnlp.println("</jnlp>");
        this.jnlp.flush();
        this.jnlp.close();
        if (this.jnlp.checkError()) {
            this.fatalError("cannot write " + this.jnlpFile);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

