/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledittool.translate;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xsd.datatype.LanguageType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class TranslateXXE {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static boolean verbose = false;

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        File file = null;
        File file2 = null;
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String[] stringArray2;
            String string3 = stringArray[n2];
            if ("-v".equals(string3)) {
                verbose = true;
            } else if ("-l".equals(string3)) {
                if (n2 + 1 >= stringArray.length) {
                    TranslateXXE.usage(null);
                }
                string = stringArray[++n2];
            } else if ("-e".equals(string3)) {
                if (n2 + 1 >= stringArray.length) {
                    TranslateXXE.usage(null);
                }
                string2 = stringArray[++n2];
                stringArray2 = TranslateXXE.availableEncodings();
                if (!StringUtil.contains(stringArray2, string2)) {
                    TranslateXXE.usage("encoding must one of " + StringUtil.join(stringArray2, ", ") + ".");
                }
            } else if ("-m".equals(string3)) {
                if (n2 + 1 == stringArray.length - 1) {
                    file = new File(stringArray[++n2]);
                } else if (n2 + 2 == stringArray.length - 1) {
                    file = new File(stringArray[++n2]);
                    file2 = new File(stringArray[++n2]);
                } else {
                    TranslateXXE.usage("-m must be followed by one or two file names");
                }
                if (file2 != null && !file2.isFile()) {
                    TranslateXXE.usage("'" + file2 + "' does not exist or is not a file");
                }
                n = 0;
            } else if ("-j".equals(string3)) {
                if (n2 + 2 != stringArray.length - 1) {
                    TranslateXXE.usage(null);
                }
                stringArray2 = stringArray[++n2];
                file2 = new File((String)stringArray2);
                file = new File(stringArray[++n2]);
                if (!stringArray2.endsWith(".jar")) {
                    TranslateXXE.usage("'" + (String)stringArray2 + "' must have a '.jar' suffix");
                }
                if (!file.isFile()) {
                    TranslateXXE.usage("'" + file + "' does not exist or is not a file");
                }
                n = 1;
            } else if ("-?".equals(string3) || string3.startsWith("-h")) {
                TranslateXXE.usage(null);
            } else {
                TranslateXXE.usage("'" + string3 + "', unknow option");
            }
            ++n2;
        }
        if (string == null && file2 != null) {
            string = FileUtil.trimFileExtension(file2.getName());
        }
        if (string != null && !LanguageType.isKnownLanguage(string)) {
            TranslateXXE.usage("two_letter_language_code must one of " + StringUtil.join(LanguageType.LANGUAGE_LIST, ", ") + ".");
        }
        if (string2 == null) {
            string2 = FileUtil.defaultEncoding();
        }
        switch (n) {
            case 0: {
                try {
                    TranslateXXE.extractMessageFile(file, string2, file2, string);
                }
                catch (IOException iOException) {
                    System.err.println("cannot create message file '" + file + "': " + MiscUtil.reason(iOException));
                    System.exit(2);
                }
                break;
            }
            case 1: {
                try {
                    TranslateXXE.createMessageJar(file2, string, file, string2);
                }
                catch (IOException iOException) {
                    System.err.println("cannot create message jar '" + file2 + "': " + MiscUtil.reason(iOException));
                    System.exit(3);
                }
                break;
            }
            default: {
                TranslateXXE.usage(null);
            }
        }
    }

    private static void usage(String string) {
        if (string != null) {
            System.err.println("*** error: " + string);
        }
        System.err.println("usage: translatexxe [-v] [-l two_letter_language_code] [-e message_file_encoding]\n    -m out_message_file [in_jar_file]\nOR\n    -j out_jar_file in_message_file\n\n* Use '-m out_message_file' to create a text file\ncontaining XXE messages to be translated.\n\n* If you have already translated XXE messages,\nsay to Italian, and want to update your translation,\nuse '-m out_message_file my_italian_messages.jar'.\n\n* Use '-j out_jar_file in_message_file' to convert\nyour message file 'in_message_file' to an easy-to-deploy\nmessage jar 'out_jar_file'.\n\n* In all cases, '-e message_file_encoding' may be used to\nspecify the encoding of the input or output message file.\nBy default, it is the native encoding of the platform\n(in the case of your platform '" + FileUtil.defaultEncoding() + "').\n" + "\n" + "* Use '-l two_letter_language_code' to specify the target\n" + "language of your translation of XXE messages.\n" + "By default, this language is inferred from the basename\n" + "of the message jar file. Example: '-j it.jar msg.txt' implies\n" + "that you have translated XXE messages to Italian.");
        System.exit(1);
    }

    private static String[] availableEncodings() {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        String[] stringArray = new String[sortedMap.size()];
        int n = 0;
        Iterator<String> iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        return stringArray;
    }

    private static void extractMessageFile(File file, String string, File file2, String string2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string3 = System.getProperty("java.class.path");
        if (string3 == null) {
            throw new IOException("cannot get CLASSPATH");
        }
        File file3 = null;
        String[] stringArray = StringUtil.split(string3, File.pathSeparatorChar);
        int n = 0;
        while (n < stringArray.length) {
            object4 = stringArray[n].trim();
            if (((String)object4).endsWith("xxe_tool.jar")) {
                file3 = new File((String)object4).getParentFile();
                if (file3 != null) break;
                file3 = new File(".");
                break;
            }
            ++n;
        }
        if (file3 == null) {
            throw new IOException("don't find xxe_tool.jar in CLASSPATH");
        }
        object4 = (file3 = file3.getCanonicalFile()).getParentFile();
        if (object4 == null) {
            throw new IOException("don't find XXE install directory");
        }
        File file4 = new File((File)object4, "addon" + File.separatorChar + "config");
        if (file4 == null) {
            throw new IOException("don't find XXE directory containing configurations");
        }
        Object[] objectArray = new Object[]{null, null, new File(file3, "xxe.jar"), null, null, new File(file3, "xxe_app.jar"), null, "en", new File(file3, "xxe_app.jar"), null, null, new File(file4, "docbook" + File.separatorChar + "docbook.jar"), "docbook.properties", null, new File(file4, "docbook" + File.separatorChar + "docbook_en.properties"), null, null, new File(file4, "xhtml" + File.separatorChar + "xhtml.jar"), "xhtml.properties", null, new File(file4, "xhtml" + File.separatorChar + "xhtml_en.properties")};
        ArrayList<Messages> arrayList = new ArrayList<Messages>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            object3 = (String)objectArray[n2];
            object2 = (String)objectArray[n2 + 1];
            object = (File)objectArray[n2 + 2];
            if (!((File)object).isFile()) {
                throw new FileNotFoundException(((File)object).getPath());
            }
            if (object3 == null) {
                TranslateXXE.extractAllMessages((File)object, true, (String)object2, arrayList);
            } else {
                Messages messages = new Messages((String)object3);
                FileInputStream fileInputStream = new FileInputStream((File)object);
                TranslateXXE.extractMessages(fileInputStream, messages);
                fileInputStream.close();
                arrayList.add(messages);
            }
            n2 += 3;
        }
        Collections.sort(arrayList);
        if (file2 != null) {
            Object object5;
            object3 = new ArrayList();
            TranslateXXE.extractAllMessages(file2, false, string2, (ArrayList)object3);
            object2 = new HashMap();
            object = "_" + string2;
            int n3 = ((String)object).length();
            int n4 = ((ArrayList)object3).size();
            int n5 = 0;
            while (n5 < n4) {
                Messages messages = (Messages)((ArrayList)object3).get(n5);
                object5 = messages.path;
                int n6 = ((String)object5).lastIndexOf((String)object);
                if (n6 > 0) {
                    object5 = ((String)object5).substring(0, n6) + ((String)object5).substring(n6 + n3);
                    ((HashMap)object2).put(object5, messages);
                }
                ++n5;
            }
            n4 = arrayList.size();
            int n7 = 0;
            while (n7 < n4) {
                object5 = (Messages)arrayList.get(n7);
                Messages messages = (Messages)((HashMap)object2).get(((Messages)object5).path);
                if (messages != null) {
                    ArrayList arrayList2 = ((Messages)object5).messages;
                    int n8 = arrayList2.size();
                    int n9 = 0;
                    while (n9 < n8) {
                        Message message = (Message)arrayList2.get(n9);
                        if (message.id != null) {
                            message.text2 = messages.getTextById(message.id);
                        }
                        ++n9;
                    }
                }
                ++n7;
            }
        }
        if (verbose) {
            object3 = TranslateXXE.countMessages(arrayList);
            System.err.println("translatexxe: " + (int)object3[0] + " messages found in " + (int)object3[1] + " files.");
            System.err.println("translatexxe: " + (int)object3[2] + " translated messages found in " + (int)object3[3] + " files.");
        }
        TranslateXXE.saveMessageFile(arrayList, file, string);
    }

    private static int[] countMessages(ArrayList arrayList) {
        int[] nArray = new int[4];
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Messages messages = (Messages)arrayList.get(n2);
            boolean bl = false;
            boolean bl2 = false;
            ArrayList arrayList2 = messages.messages;
            int n3 = arrayList2.size();
            int n4 = 0;
            while (n4 < n3) {
                Message message = (Message)arrayList2.get(n4);
                if (message.id != null) {
                    if (message.text != null) {
                        nArray[0] = nArray[0] + 1;
                        bl = true;
                    }
                    if (message.text2 != null) {
                        nArray[2] = nArray[2] + 1;
                        bl2 = true;
                    }
                }
                ++n4;
            }
            if (bl) {
                nArray[1] = nArray[1] + 1;
            }
            if (bl2) {
                nArray[3] = nArray[3] + 1;
            }
            ++n2;
        }
        return nArray;
    }

    private static void extractAllMessages(File file, boolean bl, String string, ArrayList arrayList) throws IOException {
        String string2 = string == null ? "Messages.properties" : "_" + string + ".properties";
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(string4 = zipEntry.getName()).endsWith(string2)) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            if (bl) {
                if (!string4.startsWith("com/")) {
                    int n = string4.lastIndexOf(47);
                    string3 = n < 0 ? string4 : string4.substring(n + 1);
                    if (string != null) {
                        string3 = string3.substring(0, string3.length() - string2.length());
                        string3 = string3 + ".properties";
                    }
                } else {
                    string3 = string4;
                }
            } else {
                string3 = string4;
            }
            Messages messages = new Messages(string3);
            TranslateXXE.extractMessages(inputStream, messages);
            inputStream.close();
            arrayList.add(messages);
        }
    }

    private static void extractMessages(InputStream inputStream, Messages messages) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        String[] stringArray = new String[2];
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            if (string.indexOf(35) == 0) {
                messages.messages.add(new Message(string));
                continue;
            }
            if (!TranslateXXE.splitKeyValue(string, lineNumberReader, null, stringArray) || stringArray[1].length() <= 0) continue;
            messages.messages.add(new Message(stringArray[0], stringArray[1]));
        }
    }

    private static boolean splitKeyValue(String string, LineNumberReader lineNumberReader, String string2, String[] stringArray) throws IOException {
        String string3;
        int n = string.indexOf(61);
        if (n <= 0) {
            return false;
        }
        if (string.endsWith("\\")) {
            StringBuffer stringBuffer = new StringBuffer();
            while (string.endsWith("\\")) {
                stringBuffer.append(string.substring(0, string.length() - 1));
                string = lineNumberReader.readLine();
                if (string == null || string2 != null && string.startsWith(string2) || (string = string.trim()).length() == 0) break;
            }
            if (string != null && string.length() > 0) {
                if (string2 != null && string.startsWith(string2)) {
                    return false;
                }
                stringBuffer.append(string);
            }
            string3 = stringBuffer.toString();
        } else {
            string3 = string;
        }
        stringArray[0] = string3.substring(0, n);
        stringArray[1] = TranslateXXE.unescapePropertyValue(string3.substring(n + 1));
        return true;
    }

    private static String unescapePropertyValue(String string) {
        if ((string = StringUtil.unescape(string)).indexOf("\\=") >= 0) {
            string = StringUtil.replaceAll(string, "\\=", "=");
        }
        if (string.indexOf("\\:") >= 0) {
            string = StringUtil.replaceAll(string, "\\:", ":");
        }
        if (string.indexOf("\\#") >= 0) {
            string = StringUtil.replaceAll(string, "\\#", "#");
        }
        if (string.indexOf("\\!") >= 0) {
            string = StringUtil.replaceAll(string, "\\!", "!");
        }
        return string;
    }

    private static void saveMessageFile(ArrayList arrayList, File file, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string));
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Messages messages = (Messages)arrayList.get(n2);
            bufferedWriter.write("++++++++++");
            bufferedWriter.write(messages.path);
            bufferedWriter.write(lineSeparator);
            Message message = null;
            ArrayList arrayList2 = messages.messages;
            int n3 = arrayList2.size();
            int n4 = 0;
            while (n4 < n3) {
                Message message2 = (Message)arrayList2.get(n4);
                if (message2.id == null) {
                    if (message == null || message.id != null) {
                        bufferedWriter.write(lineSeparator);
                    }
                    bufferedWriter.write(message2.text);
                    bufferedWriter.write(lineSeparator);
                } else {
                    bufferedWriter.write(lineSeparator);
                    bufferedWriter.write(message2.id);
                    bufferedWriter.write(61);
                    bufferedWriter.write(TranslateXXE.formatMessage(message2.text));
                    bufferedWriter.write(lineSeparator);
                    bufferedWriter.write(message2.id);
                    bufferedWriter.write(61);
                    if (message2.text2 != null) {
                        bufferedWriter.write(TranslateXXE.formatMessage(message2.text2));
                    }
                    bufferedWriter.write(lineSeparator);
                }
                message = message2;
                ++n4;
            }
            bufferedWriter.write(lineSeparator);
            bufferedWriter.write("----------");
            bufferedWriter.write(messages.path);
            bufferedWriter.write(lineSeparator);
            ++n2;
        }
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    private static String formatMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = string.indexOf("{0}") >= 0;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\'': {
                    if (bl && n2 + 1 < n && string.charAt(n2 + 1) == '\'') {
                        ++n2;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n\\");
                    stringBuffer.append(lineSeparator);
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void createMessageJar(File file, String string, File file2, String string2) throws IOException {
        ArrayList arrayList = new ArrayList();
        TranslateXXE.parseMessageFile(file2, string2, arrayList);
        if (verbose) {
            int[] nArray = TranslateXXE.countMessages(arrayList);
            System.err.println("translatexxe: " + nArray[0] + " translated messages found in " + nArray[1] + " files.");
        }
        TranslateXXE.saveMessageJar(arrayList, file, string);
    }

    private static void parseMessageFile(File file, String string, ArrayList arrayList) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
        String[] stringArray = new String[2];
        Messages messages = null;
        String string2 = null;
        String string3 = lineNumberReader.readLine();
        while (string3 != null) {
            String string4;
            if ((string3 = string3.trim()).length() == 0) {
                string3 = lineNumberReader.readLine();
                continue;
            }
            if (string3.startsWith("++++++++++")) {
                if (messages != null) {
                    TranslateXXE.parseError(file, lineNumberReader, "unexpected '" + string3 + "'");
                }
                if ((string4 = string3.substring(10).trim()).length() == 0) {
                    TranslateXXE.parseError(file, lineNumberReader, "expected a path after '++++++++++'");
                }
                messages = new Messages(string4);
                string2 = null;
            } else if (string3.startsWith("----------")) {
                if (messages == null) {
                    TranslateXXE.parseError(file, lineNumberReader, "unexpected '" + string3 + "'");
                }
                if (!messages.path.equals(string4 = string3.substring(10).trim())) {
                    TranslateXXE.parseError(file, lineNumberReader, "expected '----------" + messages.path + "', found '----------" + string4 + "'");
                }
                arrayList.add(messages);
                messages = null;
                string2 = null;
            } else if (messages != null) {
                if (string3.indexOf(35) == 0) {
                    if (string2 != null) {
                        TranslateXXE.parseError(file, lineNumberReader, "expected " + string2 + "=<value>, found '" + string3 + "'");
                    }
                    messages.messages.add(new Message(string3));
                } else {
                    if (!TranslateXXE.splitKeyValue(string3, lineNumberReader, "----------", stringArray)) {
                        TranslateXXE.parseError(file, lineNumberReader, "expected <key>=<value>, found '" + string3 + "'");
                    }
                    if (string2 == null) {
                        string2 = stringArray[0];
                    } else {
                        if (!stringArray[0].equals(string2)) {
                            TranslateXXE.parseError(file, lineNumberReader, "expected " + string2 + "=<value>, found '" + string3 + "'");
                        }
                        if ((string4 = stringArray[1]).length() > 0) {
                            messages.messages.add(new Message(stringArray[0], string4));
                        }
                        string2 = null;
                    }
                }
            }
            string3 = lineNumberReader.readLine();
        }
        lineNumberReader.close();
        if (messages != null || string2 != null) {
            TranslateXXE.parseError(file, lineNumberReader, "unexpected end of file");
        }
    }

    private static void parseError(File file, LineNumberReader lineNumberReader, String string) throws IOException {
        throw new IOException("file " + file + ", line " + lineNumberReader.getLineNumber() + ": syntax error: " + string);
    }

    private static void saveMessageJar(ArrayList arrayList, File file, String string) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        HashSet hashSet = new HashSet();
        Properties properties = new Properties();
        String string2 = "Created";
        String string3 = System.getProperty("user.name");
        if (string3 != null) {
            string2 = string2 + " by " + string3;
        }
        string2 = string2 + " using translatexxe V3.0p1.";
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Messages messages = (Messages)arrayList.get(n2);
            ArrayList arrayList2 = messages.messages;
            int n3 = arrayList2.size();
            if (n3 > 0) {
                int n4;
                String string4;
                properties.clear();
                int n5 = 0;
                while (n5 < n3) {
                    Message message = (Message)arrayList2.get(n5);
                    string4 = message.text;
                    if (message.id != null && string4 != null) {
                        if (string4.indexOf("{0}") >= 0 && string4.indexOf(39) >= 0) {
                            string4 = StringUtil.replaceAll(string4, "'", "''");
                        }
                        properties.setProperty(message.id, string4);
                    }
                    ++n5;
                }
                if (properties.size() > 0 && (n4 = messages.path.lastIndexOf(".properties")) > 0) {
                    string4 = messages.path.substring(0, n4) + '_' + string + messages.path.substring(n4);
                    TranslateXXE.addJarDirs(string4, jarOutputStream, hashSet);
                    ZipEntry zipEntry = new ZipEntry(string4);
                    jarOutputStream.putNextEntry(zipEntry);
                    properties.store(jarOutputStream, string2);
                    jarOutputStream.closeEntry();
                }
            }
            ++n2;
        }
        jarOutputStream.finish();
        jarOutputStream.close();
    }

    private static void addJarDirs(String string, JarOutputStream jarOutputStream, HashSet hashSet) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String[] stringArray = StringUtil.split(string, '/');
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(stringArray[n2]);
            String string2 = stringBuffer.toString() + '/';
            if (!hashSet.contains(string2)) {
                ZipEntry zipEntry = new ZipEntry(string2);
                jarOutputStream.putNextEntry(zipEntry);
                jarOutputStream.closeEntry();
                hashSet.add(string2);
            }
            ++n2;
        }
    }

    private static class Messages
    implements Comparable {
        public String path;
        public ArrayList messages;
        private HashMap idToText;

        public Messages(String string) {
            this.path = string;
            this.messages = new ArrayList();
            this.idToText = null;
        }

        public String getTextById(String string) {
            if (this.idToText == null) {
                this.idToText = new HashMap();
                int n = this.messages.size();
                int n2 = 0;
                while (n2 < n) {
                    Message message = (Message)this.messages.get(n2);
                    if (message.id != null) {
                        this.idToText.put(message.id, message.text);
                    }
                    ++n2;
                }
            }
            return (String)this.idToText.get(string);
        }

        public int compareTo(Object object) {
            return this.path.compareTo(((Messages)object).path);
        }
    }

    private static class Message {
        public String id;
        public String text;
        public String text2;

        public Message(String string) {
            this.text = string;
            this.text2 = null;
            this.id = null;
        }

        public Message(String string, String string2) {
            this.id = string;
            this.text = string2;
            this.text2 = null;
        }
    }
}

