/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.docbook;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.styledview.CustomViewManager;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.xhtml.table.TableObserver;
import java.awt.Color;
import javax.swing.SwingUtilities;

public class StyleSpecsImpl
extends com.xmlmind.xmleditapp.docbook.table.StyleSpecsImpl {
    private HTMLStyleSpecs htmlStyleSpecs = null;

    public StyleSpecsImpl(StyledViewFactory styledViewFactory, Color color, Color color2) {
        super(styledViewFactory, color, color2);
    }

    public int findStyleSpec(final Element element, StyleSpec[] styleSpecArray) {
        String string;
        int n = super.findStyleSpec(element, styleSpecArray);
        if (n == 0 && ((string = element.getLocalName()).equals("td") || string.equals("th") || StyleSpecsImpl.isHTMLTableName(string) && StyleSpecsImpl.hasHTMLTableContent(element))) {
            if (this.htmlStyleSpecs == null) {
                this.addHTMLTableSupport();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Element element2 = element;
                        while (element2 != null) {
                            String string = element2.getLocalName();
                            if ("table".equals(string) || "informaltable".equals(string)) break;
                            element2 = element2.getParentElement();
                        }
                        if (element2 != null) {
                            StyleSpecsImpl.this.viewFactory.getDocumentView().rebuildView((Node)element2);
                        }
                    }
                });
            }
            n = this.htmlStyleSpecs.findStyleSpec(element, styleSpecArray);
        }
        return n;
    }

    private static final boolean isHTMLTableName(String string) {
        return "table".equals(string) || "informaltable".equals(string);
    }

    private static final boolean hasHTMLTableContent(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            String string;
            if (node instanceof Element && ("tr".equals(string = ((Element)node).getLocalName()) || "tbody".equals(string))) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    private void addHTMLTableSupport() {
        this.htmlStyleSpecs = new HTMLStyleSpecs(this.borderColor, this.noBorderColor);
        String[] stringArray = HTMLStyleSpecs.getDependencies();
        int n = 0;
        while (n < stringArray.length) {
            this.viewFactory.addDependency(null, stringArray[n], Namespace.NONE, stringArray[n + 1]);
            if ("table".equals(stringArray[n])) {
                this.viewFactory.addDependency(null, "informaltable", Namespace.NONE, stringArray[n + 1]);
            }
            n += 2;
        }
        this.viewFactory.getCustomViewManager().add((CustomViewManager.BasicElementObserver)new HTMLTableObserver(this.viewFactory), new CustomViewManager.NamePattern[]{new CustomViewManager.NamePattern(null, "table"), new CustomViewManager.NamePattern(null, "informaltable"), new CustomViewManager.NamePattern(null, "colgroup"), new CustomViewManager.NamePattern(null, "col")});
    }

    private static final class HTMLTableObserver
    extends TableObserver {
        public HTMLTableObserver(StyledViewFactory styledViewFactory) {
            super(styledViewFactory);
        }

        protected boolean isTableStyleModifierName(String string) {
            return super.isTableStyleModifierName(string) || string.equals("tr") || string.equals("tbody") || string.equals("tgroup") || string.equals("mediaobject") || string.equals("graphic");
        }

        protected boolean isTableName(String string) {
            return StyleSpecsImpl.isHTMLTableName(string);
        }
    }

    private static final class HTMLStyleSpecs
    extends com.xmlmind.xmleditapp.xhtml.table.StyleSpecsImpl {
        public HTMLStyleSpecs(Color color, Color color2) {
            super(color, color2);
        }

        protected boolean isTableName(String string) {
            return StyleSpecsImpl.isHTMLTableName(string);
        }

        public static String[] getDependencies() {
            return com.xmlmind.xmleditapp.xhtml.table.StyleSpecsImpl.DEPENDENCIES;
        }
    }
}

