/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.docbook.table;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmleditapp.docbook.table.CellInfo;
import com.xmlmind.xmleditapp.docbook.table.ColSpecInfo;
import com.xmlmind.xmleditapp.docbook.table.SpanSpecInfo;
import com.xmlmind.xmleditapp.docbook.table.TableAttributeNames;
import com.xmlmind.xmleditapp.xmlapputil.SpanHelper;
import java.util.ArrayList;

final class RowGroupInfo
implements TableAttributeNames {
    public Element rowGroup = null;
    public Element tableGroup = null;
    public boolean rowGroupHasColSpecs = false;
    public ColSpecInfo[] colSpecList = new ColSpecInfo[0];
    public int colSpecCount = 0;
    public SpanSpecInfo[] spanSpecList = new SpanSpecInfo[0];
    public int spanSpecCount = 0;
    public ArrayList cells = new ArrayList();
    private Element[] element2 = new Element[2];
    private SpanHelper spanHelper = new SpanHelper();
    private CellInfo tmpInfo = new CellInfo();

    RowGroupInfo() {
    }

    public boolean compute(Element element, CellInfo cellInfo) {
        cellInfo.clear();
        cellInfo.element = element;
        this.clear();
        if (!RowGroupInfo.findTableGroup(element, this.element2)) {
            return false;
        }
        this.tableGroup = this.element2[0];
        this.rowGroup = this.element2[1];
        this.compute(cellInfo, null);
        return true;
    }

    public void clear() {
        this.rowGroup = null;
        this.tableGroup = null;
        this.rowGroupHasColSpecs = false;
        int n = 0;
        while (n < this.colSpecCount) {
            this.colSpecList[n].clear();
            ++n;
        }
        this.colSpecCount = 0;
        int n2 = 0;
        while (n2 < this.spanSpecCount) {
            this.spanSpecList[n2].clear();
            ++n2;
        }
        this.spanSpecCount = 0;
        this.cells.clear();
        this.element2[1] = null;
        this.element2[0] = null;
        this.spanHelper.reset();
        this.tmpInfo.clear();
    }

    public static Element[] findTableGroup(Element element) {
        Element[] elementArray = new Element[2];
        if (RowGroupInfo.findTableGroup(element, elementArray)) {
            return elementArray;
        }
        return null;
    }

    public static boolean findTableGroup(Element element, Element[] elementArray) {
        String string;
        elementArray[0] = null;
        elementArray[1] = null;
        Element element2 = null;
        Element element3 = element.getParentElement();
        while (element3 != null) {
            string = element3.getLocalName();
            if (string.equals("tbody") || string.equals("thead") || string.equals("tfoot")) {
                element2 = element3;
                break;
            }
            element3 = element3.getParentElement();
        }
        if (element2 == null) {
            return false;
        }
        string = element2.getParentElement();
        if (string == null) {
            return false;
        }
        String string2 = string.getLocalName();
        if (!"tgroup".equals(string2) && !"entrytbl".equals(string2)) {
            return false;
        }
        elementArray[0] = string;
        elementArray[1] = element2;
        return true;
    }

    public boolean compute(Element element) {
        this.clear();
        if (!RowGroupInfo.findTableGroup(element, this.element2)) {
            return false;
        }
        this.tableGroup = this.element2[0];
        this.rowGroup = this.element2[1];
        this.compute(null, this.cells);
        return true;
    }

    public static RowGroupInfo[] computeAll(Element element) {
        RowGroupInfo[] rowGroupInfoArray = new RowGroupInfo[3];
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                RowGroupInfo rowGroupInfo;
                Element element2 = (Element)node;
                String string = element2.getLocalName();
                if ("thead".equals(string)) {
                    rowGroupInfoArray[0] = rowGroupInfo = new RowGroupInfo();
                    rowGroupInfo.tableGroup = element;
                    rowGroupInfo.rowGroup = element2;
                    rowGroupInfo.compute(null, rowGroupInfo.cells);
                } else if ("tfoot".equals(string)) {
                    rowGroupInfoArray[1] = rowGroupInfo = new RowGroupInfo();
                    rowGroupInfo.tableGroup = element;
                    rowGroupInfo.rowGroup = element2;
                    rowGroupInfo.compute(null, rowGroupInfo.cells);
                } else if ("tbody".equals(string)) {
                    rowGroupInfoArray[2] = rowGroupInfo = new RowGroupInfo();
                    rowGroupInfo.tableGroup = element;
                    rowGroupInfo.rowGroup = element2;
                    rowGroupInfo.compute(null, rowGroupInfo.cells);
                }
            }
            node = node.getNextSibling();
        }
        return rowGroupInfoArray;
    }

    public ColSpecInfo getColSpec(int n) {
        int n2 = 0;
        while (n2 < this.colSpecCount) {
            if (this.colSpecList[n2].number == n) {
                return this.colSpecList[n2];
            }
            ++n2;
        }
        return null;
    }

    public ColSpecInfo getColSpec(String string) {
        int n = 0;
        while (n < this.colSpecCount) {
            if (string.equals(this.colSpecList[n].name)) {
                return this.colSpecList[n];
            }
            ++n;
        }
        return null;
    }

    public SpanSpecInfo getSpanSpec(String string) {
        int n = 0;
        while (n < this.spanSpecCount) {
            if (string.equals(this.spanSpecList[n].name)) {
                return this.spanSpecList[n];
            }
            ++n;
        }
        return null;
    }

    public CellInfo getCell(Element element) {
        return RowGroupInfo.findCell(this.cells, element);
    }

    public static CellInfo findCell(ArrayList arrayList, Element element) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)arrayList.get(n2);
            if (cellInfo.element == element) {
                return cellInfo;
            }
            ++n2;
        }
        return null;
    }

    public int getColumnCount() {
        int n = -1;
        int n2 = this.cells.size();
        int n3 = 0;
        while (n3 < n2) {
            CellInfo cellInfo = (CellInfo)this.cells.get(n3);
            if (cellInfo.column > n) {
                n = cellInfo.column;
            }
            ++n3;
        }
        return n + 1;
    }

    public static int getColumnCount(Element element) {
        int n = 0;
        RowGroupInfo[] rowGroupInfoArray = RowGroupInfo.computeAll(element);
        int n2 = 0;
        while (n2 < 3) {
            int n3;
            RowGroupInfo rowGroupInfo = rowGroupInfoArray[n2];
            if (rowGroupInfo != null && (n3 = rowGroupInfo.getColumnCount()) > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    private void compute(CellInfo cellInfo, ArrayList arrayList) {
        this.collectColSpecs();
        if (!this.rowGroupHasColSpecs) {
            this.collectSpanSpecs();
        }
        Node node = this.rowGroup.getFirstChild();
        block0: while (node != null) {
            Element element;
            if (node instanceof Element && (element = (Element)node).getLocalName().equals("row")) {
                this.spanHelper.addRow();
                Node node2 = element.getFirstChild();
                while (node2 != null) {
                    if (node2 instanceof Element) {
                        Element element2 = (Element)node2;
                        if (cellInfo != null && element2 == cellInfo.element) {
                            this.getCellInfo(element2, this.spanHelper.getNextRow() - 1, this.spanHelper.getNextColumn(), cellInfo);
                            break block0;
                        }
                        String string = element2.getLocalName();
                        if (string.equals("entry") || string.equals("entrytbl")) {
                            this.addCell(element2, this.spanHelper, arrayList);
                        }
                    }
                    node2 = node2.getNextSibling();
                }
            }
            node = node.getNextSibling();
        }
    }

    private void collectColSpecs() {
        String string = this.rowGroup.getLocalName();
        if ("thead".equals(string) || "tfoot".equals(string)) {
            this.doCollectColSpecs(this.rowGroup);
        }
        boolean bl = this.rowGroupHasColSpecs = this.colSpecCount > 0;
        if (this.rowGroupHasColSpecs) {
            return;
        }
        this.doCollectColSpecs(this.tableGroup);
    }

    private void doCollectColSpecs(Element element) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getLocalName().equals("colspec")) {
                ColSpecInfo colSpecInfo = this.addColSpec(element2, n);
                n = colSpecInfo.number + 1;
            }
            node = node.getNextSibling();
        }
    }

    private ColSpecInfo addColSpec(Element element, int n) {
        ColSpecInfo colSpecInfo = this.allocColSpec();
        colSpecInfo.element = element;
        colSpecInfo.number = element.getIntAttribute(TableAttributeNames.COLNUM, 1 + n, Integer.MAX_VALUE, 1 + n);
        --colSpecInfo.number;
        colSpecInfo.name = element.getAttribute(TableAttributeNames.COLNAME);
        if (colSpecInfo.name != null) {
            colSpecInfo.name = colSpecInfo.name.trim();
            if (colSpecInfo.name.length() == 0) {
                colSpecInfo.name = null;
            }
        }
        colSpecInfo.align = element.getAttribute(TableAttributeNames.ALIGN);
        colSpecInfo.width = element.getAttribute(TableAttributeNames.COLWIDTH);
        colSpecInfo.rowSep = element.getAttribute(TableAttributeNames.ROWSEP);
        colSpecInfo.colSep = element.getAttribute(TableAttributeNames.COLSEP);
        ++this.colSpecCount;
        return colSpecInfo;
    }

    private ColSpecInfo allocColSpec() {
        if (this.colSpecCount == this.colSpecList.length) {
            int n = Math.max(10, 2 * this.colSpecList.length);
            ColSpecInfo[] colSpecInfoArray = new ColSpecInfo[n];
            System.arraycopy(this.colSpecList, 0, colSpecInfoArray, 0, this.colSpecList.length);
            int n2 = this.colSpecList.length;
            while (n2 < n) {
                colSpecInfoArray[n2] = new ColSpecInfo();
                ++n2;
            }
            this.colSpecList = colSpecInfoArray;
        }
        return this.colSpecList[this.colSpecCount];
    }

    private void collectSpanSpecs() {
        Node node = this.tableGroup.getFirstChild();
        while (node != null) {
            Element element;
            if (node instanceof Element && (element = (Element)node).getLocalName().equals("spanspec")) {
                this.addSpanSpec(element);
            }
            node = node.getNextSibling();
        }
    }

    private SpanSpecInfo addSpanSpec(Element element) {
        SpanSpecInfo spanSpecInfo = this.allocSpanSpec();
        spanSpecInfo.element = element;
        spanSpecInfo.name = element.getAttribute(TableAttributeNames.SPANNAME);
        if (spanSpecInfo.name == null) {
            return null;
        }
        spanSpecInfo.name = spanSpecInfo.name.trim();
        if (spanSpecInfo.name.length() == 0) {
            return null;
        }
        String string = element.getAttribute(TableAttributeNames.NAMEST);
        if (string == null) {
            return null;
        }
        spanSpecInfo.startColSpec = this.getColSpec(string.trim());
        if (spanSpecInfo.startColSpec == null) {
            return null;
        }
        string = element.getAttribute(TableAttributeNames.NAMEEND);
        if (string == null) {
            return null;
        }
        spanSpecInfo.endColSpec = this.getColSpec(string.trim());
        if (spanSpecInfo.endColSpec == null) {
            return null;
        }
        if (spanSpecInfo.endColSpec.number < spanSpecInfo.startColSpec.number) {
            return null;
        }
        spanSpecInfo.align = element.getAttribute(TableAttributeNames.ALIGN);
        spanSpecInfo.rowSep = element.getAttribute(TableAttributeNames.ROWSEP);
        spanSpecInfo.colSep = element.getAttribute(TableAttributeNames.COLSEP);
        ++this.spanSpecCount;
        return spanSpecInfo;
    }

    private SpanSpecInfo allocSpanSpec() {
        if (this.spanSpecCount == this.spanSpecList.length) {
            int n = Math.max(10, 2 * this.spanSpecList.length);
            SpanSpecInfo[] spanSpecInfoArray = new SpanSpecInfo[n];
            System.arraycopy(this.spanSpecList, 0, spanSpecInfoArray, 0, this.spanSpecList.length);
            int n2 = this.spanSpecList.length;
            while (n2 < n) {
                spanSpecInfoArray[n2] = new SpanSpecInfo();
                ++n2;
            }
            this.spanSpecList = spanSpecInfoArray;
        }
        return this.spanSpecList[this.spanSpecCount];
    }

    private void addCell(Element element, SpanHelper spanHelper, ArrayList arrayList) {
        CellInfo cellInfo = arrayList == null ? this.tmpInfo : new CellInfo();
        this.getCellInfo(element, spanHelper.getNextRow() - 1, spanHelper.getNextColumn(), cellInfo);
        spanHelper.addCell(cellInfo.rowSpan, cellInfo.columnSpan, cellInfo.column);
        if (arrayList != null) {
            arrayList.add(cellInfo);
        }
    }

    private void getCellInfo(Element element, int n, int n2, CellInfo cellInfo) {
        this.doGetCellInfo(element, n, n2, cellInfo);
        cellInfo.rowSpan = "entrytbl".equals(element.getLocalName()) ? 1 : 1 + RowGroupInfo.getMoreRows(element);
        cellInfo.columnSpan = cellInfo.endColSpec != null ? cellInfo.endColSpec.number - cellInfo.column + 1 : 1;
    }

    private void doGetCellInfo(Element element, int n, int n2, CellInfo cellInfo) {
        cellInfo.element = element;
        cellInfo.row = n;
        cellInfo.column = n2;
        cellInfo.expectedColumn = n2;
        cellInfo.startColSpec = null;
        cellInfo.endColSpec = null;
        cellInfo.spanSpec = null;
        String string = element.getAttribute(TableAttributeNames.SPANNAME);
        if (string != null) {
            cellInfo.spanSpec = this.getSpanSpec(string.trim());
            if (cellInfo.spanSpec == null) {
                return;
            }
            if (cellInfo.spanSpec.startColSpec.number < n2) {
                cellInfo.spanSpec = null;
            } else {
                cellInfo.startColSpec = cellInfo.spanSpec.startColSpec;
                cellInfo.endColSpec = cellInfo.spanSpec.endColSpec;
                cellInfo.column = cellInfo.startColSpec.number;
            }
            return;
        }
        string = element.getAttribute(TableAttributeNames.NAMEST);
        if (string != null) {
            cellInfo.startColSpec = this.getColSpec(string.trim());
            if (cellInfo.startColSpec == null) {
                return;
            }
            string = element.getAttribute(TableAttributeNames.NAMEEND);
            if (string != null) {
                cellInfo.endColSpec = this.getColSpec(string.trim());
                if (cellInfo.endColSpec == null) {
                    cellInfo.startColSpec = null;
                    return;
                }
                if (cellInfo.endColSpec.number < cellInfo.startColSpec.number) {
                    cellInfo.endColSpec = null;
                    cellInfo.startColSpec = null;
                    return;
                }
            }
        } else {
            string = element.getAttribute(TableAttributeNames.COLNAME);
            if (string != null) {
                cellInfo.startColSpec = this.getColSpec(string.trim());
                if (cellInfo.startColSpec == null) {
                    return;
                }
            }
        }
        if (cellInfo.startColSpec != null) {
            if (cellInfo.startColSpec.number < n2) {
                cellInfo.endColSpec = null;
                cellInfo.startColSpec = null;
                return;
            }
            cellInfo.column = cellInfo.startColSpec.number;
        } else {
            cellInfo.startColSpec = this.getColSpec(n2);
        }
        if (cellInfo.endColSpec == null) {
            cellInfo.endColSpec = cellInfo.startColSpec;
        }
    }

    private static int getMoreRows(Element element) {
        return element.getIntAttribute(TableAttributeNames.MOREROWS, 0, Integer.MAX_VALUE, 0);
    }
}

