/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.docbook.table;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.docbook.table.CellInfo;
import com.xmlmind.xmleditapp.docbook.table.ColSpecInfo;
import com.xmlmind.xmleditapp.docbook.table.Msg;
import com.xmlmind.xmleditapp.docbook.table.RowGroupInfo;
import com.xmlmind.xmleditapp.docbook.table.SpanSpecInfo;
import com.xmlmind.xmleditapp.docbook.table.TableAttributeNames;
import com.xmlmind.xmleditapp.docbook.table.TableCommand;

public class TableColumn
extends TableCommand
implements TableAttributeNames {
    private static String[] COPIED_ATTRIBUTES = new String[]{"align", "char", "charoff", "colsep", "morerows", "rotate", "rowsep", "valign"};

    public TableColumn() {
        super(false);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Element[] elementArray = RowGroupInfo.findTableGroup(this.selectedCell);
        if (elementArray == null) {
            ShowStatus.showStatus((String)Msg.msg("invalidTable"));
            return null;
        }
        Element element = elementArray[0];
        RowGroupInfo[] rowGroupInfoArray = RowGroupInfo.computeAll(element);
        CellInfo cellInfo = null;
        int n3 = 0;
        while (n3 < 3) {
            if (rowGroupInfoArray[n3] != null && (cellInfo = rowGroupInfoArray[n3].getCell(this.selectedCell)) != null) break;
            ++n3;
        }
        if (this.delete) {
            this.deleteColumn(documentView, cellInfo.column, rowGroupInfoArray, element);
        } else {
            this.insertColumn(this.before, documentView, cellInfo.column, rowGroupInfoArray, element);
        }
        return null;
    }

    private void deleteColumn(DocumentView documentView, int n, RowGroupInfo[] rowGroupInfoArray, Element element) {
        int n2;
        Document document = documentView.getDocument();
        String string = Long.toString(System.currentTimeMillis(), 36) + ".";
        boolean bl = false;
        boolean bl2 = false;
        RowGroupInfo rowGroupInfo = null;
        boolean bl3 = false;
        document.beginBatchEditing();
        int n3 = 0;
        while (n3 < 3) {
            bl2 = false;
            bl = false;
            rowGroupInfo = rowGroupInfoArray[n3];
            if (rowGroupInfo != null) {
                n2 = rowGroupInfo.cells.size();
                int n4 = 0;
                while (n4 < n2) {
                    CellInfo cellInfo = (CellInfo)rowGroupInfo.cells.get(n4);
                    if (n >= cellInfo.column && n < cellInfo.column + cellInfo.columnSpan) {
                        Object object;
                        if (cellInfo.columnSpan > 1) {
                            if (cellInfo.columnSpan == 2) {
                                cellInfo.element.removeAttribute(TableAttributeNames.SPANNAME);
                                cellInfo.element.removeAttribute(TableAttributeNames.NAMEST);
                                cellInfo.element.removeAttribute(TableAttributeNames.NAMEEND);
                                cellInfo.element.removeAttribute(TableAttributeNames.COLNAME);
                                if (cellInfo.column != cellInfo.expectedColumn) {
                                    if (cellInfo.startColSpec.number == n) {
                                        object = rowGroupInfo.getColSpec(n + 1);
                                        if (object == null) {
                                            cellInfo.element.putAttribute(TableAttributeNames.COLNAME, TableColumn.colName(string, n));
                                            bl = true;
                                        } else {
                                            if (object.name == null) {
                                                object.name = TableColumn.colName(string, n);
                                                object.element.putAttribute(TableAttributeNames.COLNAME, object.name);
                                            }
                                            cellInfo.element.putAttribute(TableAttributeNames.COLNAME, object.name);
                                        }
                                    } else if (cellInfo.endColSpec.number == n) {
                                        object = rowGroupInfo.getColSpec(n - 1);
                                        if (object == null) {
                                            cellInfo.element.putAttribute(TableAttributeNames.COLNAME, TableColumn.colName(string, n - 1));
                                            bl2 = true;
                                        } else {
                                            if (object.name == null) {
                                                object.name = TableColumn.colName(string, n - 1);
                                                object.element.putAttribute(TableAttributeNames.COLNAME, object.name);
                                            }
                                            cellInfo.element.putAttribute(TableAttributeNames.COLNAME, object.name);
                                        }
                                    }
                                }
                                bl3 = true;
                            } else if (cellInfo.spanSpec == null) {
                                if (cellInfo.startColSpec.number == n) {
                                    object = rowGroupInfo.getColSpec(n + 1);
                                    if (object == null) {
                                        cellInfo.element.putAttribute(TableAttributeNames.NAMEST, TableColumn.colName(string, n));
                                        bl = true;
                                    } else {
                                        if (object.name == null) {
                                            object.name = TableColumn.colName(string, n);
                                            object.element.putAttribute(TableAttributeNames.COLNAME, object.name);
                                        }
                                        cellInfo.element.putAttribute(TableAttributeNames.NAMEST, object.name);
                                    }
                                    bl3 = true;
                                } else if (cellInfo.endColSpec.number == n) {
                                    object = rowGroupInfo.getColSpec(n - 1);
                                    if (object == null) {
                                        cellInfo.element.putAttribute(TableAttributeNames.NAMEEND, TableColumn.colName(string, n - 1));
                                        bl2 = true;
                                    } else {
                                        if (object.name == null) {
                                            object.name = TableColumn.colName(string, n - 1);
                                            object.element.putAttribute(TableAttributeNames.COLNAME, object.name);
                                        }
                                        cellInfo.element.putAttribute(TableAttributeNames.NAMEEND, object.name);
                                    }
                                    bl3 = true;
                                }
                            }
                        } else {
                            object = cellInfo.element.getParentElement();
                            if (object.getLocalName().equals("row") && TableColumn.getCellCount(object) > 1) {
                                object.removeChild((Node)cellInfo.element);
                                bl3 = true;
                            }
                        }
                    }
                    ++n4;
                }
                if (rowGroupInfo.rowGroupHasColSpecs) {
                    if (TableColumn.deleteColSpec(n, rowGroupInfo.rowGroup)) {
                        bl3 = true;
                    }
                    if (bl) {
                        TableColumn.addColSpec(n, rowGroupInfo.rowGroup, string);
                        bl3 = true;
                    }
                    if (bl2) {
                        TableColumn.addColSpec(n - 1, rowGroupInfo.rowGroup, string);
                        bl3 = true;
                    }
                }
            }
            ++n3;
        }
        if (rowGroupInfo != null) {
            n2 = 0;
            while (n2 < rowGroupInfo.spanSpecCount) {
                SpanSpecInfo spanSpecInfo = rowGroupInfo.spanSpecList[n2];
                int n5 = spanSpecInfo.startColSpec.number;
                int n6 = spanSpecInfo.endColSpec.number;
                if (n >= n5 && n <= n6) {
                    ColSpecInfo colSpecInfo;
                    if (n6 == n5 + 1) {
                        element.removeChild((Node)spanSpecInfo.element);
                        bl3 = true;
                    } else if (n == n5) {
                        colSpecInfo = rowGroupInfo.getColSpec(n + 1);
                        if (colSpecInfo == null) {
                            spanSpecInfo.element.putAttribute(TableAttributeNames.NAMEST, TableColumn.colName(string, n));
                            bl = true;
                        } else {
                            if (colSpecInfo.name == null) {
                                colSpecInfo.name = TableColumn.colName(string, n);
                                colSpecInfo.element.putAttribute(TableAttributeNames.COLNAME, colSpecInfo.name);
                            }
                            spanSpecInfo.element.putAttribute(TableAttributeNames.NAMEST, colSpecInfo.name);
                        }
                        bl3 = true;
                    } else if (n == n6) {
                        colSpecInfo = rowGroupInfo.getColSpec(n - 1);
                        if (colSpecInfo == null) {
                            spanSpecInfo.element.putAttribute(TableAttributeNames.NAMEEND, TableColumn.colName(string, n - 1));
                            bl2 = true;
                        } else {
                            if (colSpecInfo.name == null) {
                                colSpecInfo.name = TableColumn.colName(string, n - 1);
                                colSpecInfo.element.putAttribute(TableAttributeNames.COLNAME, colSpecInfo.name);
                            }
                            spanSpecInfo.element.putAttribute(TableAttributeNames.NAMEEND, colSpecInfo.name);
                        }
                        bl3 = true;
                    }
                }
                ++n2;
            }
            if (TableColumn.deleteColSpec(n, element)) {
                bl3 = true;
            }
            if (bl) {
                TableColumn.addColSpec(n, element, string);
                bl3 = true;
            }
            if (bl2) {
                TableColumn.addColSpec(n - 1, element, string);
                bl3 = true;
            }
        }
        if (bl3 && (n2 = RowGroupInfo.getColumnCount(element)) > 0) {
            element.putAttribute(TableAttributeNames.COLS, Integer.toString(n2));
        }
        document.endBatchEditing();
        if (bl3) {
            documentView.describeUndo(Msg.msg("deleteColumn"));
            documentView.selectNode((Node)element);
            documentView.moveDotInto((Node)element);
        }
    }

    private static final int getCellCount(Element element) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string;
            if (node instanceof Element && ((string = (element2 = (Element)node).getLocalName()).equals("entry") || string.equals("entrytbl"))) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    private static final String colName(String string, int n) {
        return string + (1 + n);
    }

    private static final String colNum(int n) {
        return Integer.toString(1 + n);
    }

    private static final boolean deleteColSpec(int n, Element element) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            Node node2 = node.getNextSibling();
            if (node instanceof Element && (element2 = (Element)node).getLocalName().equals("colspec")) {
                int n3 = element2.getIntAttribute(TableAttributeNames.COLNUM, 1 + n2, Integer.MAX_VALUE, 1 + n2);
                if (--n3 == n) {
                    element.removeChild((Node)element2);
                    bl = true;
                    bl2 = n != n2;
                } else if (n3 > n && (element2.hasAttribute(TableAttributeNames.COLNUM) || bl2)) {
                    bl2 = false;
                    element2.putAttribute(TableAttributeNames.COLNUM, TableColumn.colNum(n3 - 1));
                    bl = true;
                }
                n2 = n3 + 1;
            }
            node = node2;
        }
        return bl;
    }

    private static final void addColSpec(int n, Element element, String string) {
        Element element2;
        Node node;
        int n2 = 0;
        boolean bl = false;
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            element2 = null;
            if (node2 instanceof Element && (element2 = (Element)node2).getLocalName().equals("colspec")) {
                int n3 = element2.getIntAttribute(TableAttributeNames.COLNUM, 1 + n2, Integer.MAX_VALUE, 1 + n2);
                if (--n3 >= n && !bl) {
                    Element element3 = new Element(Name.get((Namespace)element2.getNamespace(), (String)"colspec"));
                    element3.putAttribute(TableAttributeNames.COLNAME, TableColumn.colName(string, n));
                    if (n != n2) {
                        element3.putAttribute(TableAttributeNames.COLNUM, TableColumn.colNum(n));
                    }
                    element.insertChild((Node)element2, (Node)element3);
                    bl = true;
                    break;
                }
                n2 = n3 + 1;
            }
            node2 = node;
        }
        if (!bl) {
            node = new Element(Name.get((Namespace)element.getNamespace(), (String)"colspec"));
            node.putAttribute(TableAttributeNames.COLNAME, TableColumn.colName(string, n));
            if (n != n2) {
                node.putAttribute(TableAttributeNames.COLNUM, TableColumn.colNum(n));
            }
            if ((element2 = TableColumn.findLastColSpec(element)) == null) {
                element.insertChild(element.getFirstChild(), node);
            } else {
                element.insertChild(element2.getNextSibling(), node);
            }
        }
    }

    private static Element findLastColSpec(Element element) {
        Element element2 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("colspec")) {
                element2 = (Element)node;
            }
            node = node.getNextSibling();
        }
        return element2;
    }

    private void insertColumn(boolean bl, DocumentView documentView, int n, RowGroupInfo[] rowGroupInfoArray, Element element) {
        int n2;
        Document document = documentView.getDocument();
        String string = Long.toString(System.currentTimeMillis(), 36) + ".";
        boolean bl2 = false;
        RowGroupInfo rowGroupInfo = null;
        Object object = null;
        document.beginBatchEditing();
        int n3 = 0;
        while (n3 < 3) {
            bl2 = false;
            rowGroupInfo = rowGroupInfoArray[n3];
            if (rowGroupInfo != null) {
                n2 = rowGroupInfo.cells.size();
                int n4 = 0;
                while (n4 < n2) {
                    CellInfo cellInfo = (CellInfo)rowGroupInfo.cells.get(n4);
                    if (n >= cellInfo.column && n < cellInfo.column + cellInfo.columnSpan) {
                        String string2;
                        if (bl && n == cellInfo.column) {
                            string2 = null;
                            if (cellInfo.column != cellInfo.expectedColumn) {
                                string2 = TableColumn.colName(string, n);
                                bl2 = true;
                            }
                            Element element2 = TableColumn.newEntry(cellInfo.element, string2);
                            cellInfo.element.getParent().insertChild((Node)cellInfo.element, (Node)element2);
                            if (object == null) {
                                object = element2;
                            }
                        } else if (!bl && n == cellInfo.column + cellInfo.columnSpan - 1) {
                            string2 = TableColumn.newEntry(cellInfo.element, null);
                            cellInfo.element.getParent().insertChild(cellInfo.element.getNextSibling(), (Node)string2);
                            if (object == null) {
                                object = string2;
                            }
                        }
                    }
                    ++n4;
                }
                if (rowGroupInfo.rowGroupHasColSpecs) {
                    TableColumn.insertColSpec(bl ? n : n + 1, rowGroupInfo.rowGroup, string);
                }
            }
            ++n3;
        }
        if (rowGroupInfo != null) {
            if (!bl2 && rowGroupInfo.colSpecCount > 0) {
                bl2 = true;
            }
            if (bl2) {
                TableColumn.insertColSpec(bl ? n : n + 1, element, string);
            }
        }
        if ((n2 = RowGroupInfo.getColumnCount(element)) > 0) {
            element.putAttribute(TableAttributeNames.COLS, Integer.toString(n2));
        }
        document.endBatchEditing();
        documentView.describeUndo(bl ? Msg.msg("insertColumnBefore") : Msg.msg("insertColumnAfter"));
        documentView.selectNode(object);
        documentView.moveDotInto(object);
    }

    private static final Element newEntry(Element element, String string) {
        Element element2 = new Element(Name.get((Namespace)element.getNamespace(), (String)"entry"));
        int n = 0;
        while (n < COPIED_ATTRIBUTES.length) {
            Name name = Name.get((String)COPIED_ATTRIBUTES[n]);
            String string2 = element.getAttribute(name);
            if (string2 != null) {
                element2.putAttribute(name, string2);
            }
            ++n;
        }
        if (string != null) {
            element2.putAttribute(TableAttributeNames.COLNAME, string);
        }
        element2.appendChild((Node)new Text());
        return element2;
    }

    private static final void insertColSpec(int n, Element element, String string) {
        Element element2;
        Node node;
        int n2 = 0;
        boolean bl = false;
        Node node2 = element.getFirstChild();
        while (node2 != null) {
            node = node2.getNextSibling();
            element2 = null;
            if (node2 instanceof Element && (element2 = (Element)node2).getLocalName().equals("colspec")) {
                int n3 = element2.getIntAttribute(TableAttributeNames.COLNUM, 1 + n2, Integer.MAX_VALUE, 1 + n2);
                if (--n3 >= n) {
                    if (!bl) {
                        Element element3 = new Element(Name.get((Namespace)element2.getNamespace(), (String)"colspec"));
                        element3.putAttribute(TableAttributeNames.COLNAME, TableColumn.colName(string, n));
                        if (n != n2) {
                            element3.putAttribute(TableAttributeNames.COLNUM, TableColumn.colNum(n));
                        }
                        element.insertChild((Node)element2, (Node)element3);
                        bl = true;
                    }
                    if (element2.hasAttribute(TableAttributeNames.COLNUM)) {
                        element2.putAttribute(TableAttributeNames.COLNUM, TableColumn.colNum(n3 + 1));
                    }
                }
                n2 = n3 + 1;
            }
            node2 = node;
        }
        if (!bl) {
            node = new Element(Name.get((Namespace)element.getNamespace(), (String)"colspec"));
            node.putAttribute(TableAttributeNames.COLNAME, TableColumn.colName(string, n));
            if (n != n2) {
                node.putAttribute(TableAttributeNames.COLNUM, TableColumn.colNum(n));
            }
            if ((element2 = TableColumn.findLastColSpec(element)) == null) {
                element.insertChild(element.getFirstChild(), node);
            } else {
                element.insertChild(element2.getNextSibling(), node);
            }
        }
    }
}

