/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.docbook.table;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.stylesheet.StyleSpecsBase;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.docbook.table.CellInfo;
import com.xmlmind.xmleditapp.docbook.table.RowGroupInfo;
import com.xmlmind.xmleditapp.docbook.table.TableAttributeNames;
import java.awt.Color;

public class StyleSpecsImpl
extends StyleSpecsBase
implements TableAttributeNames {
    private static final int FRAME_NONE = 0;
    private static final int FRAME_ALL = 1;
    private static final int FRAME_SIDES = 2;
    private static final int FRAME_TOP = 3;
    private static final int FRAME_BOTTOM = 4;
    private static final int FRAME_TOPBOT = 5;
    private static final String[] DEPENDENCIES = new String[]{"table", "frame", "table", "rowsep", "table", "colsep", "informaltable", "frame", "informaltable", "rowsep", "informaltable", "colsep", "tgroup", "rowsep", "tgroup", "colsep", "tgroup", "align", "tgroup", "cols", "thead", "valign", "tfoot", "valign", "tbody", "valign", "row", "valign", "row", "rowsep", "entry", "rowsep", "entry", "colsep", "entry", "valign", "entry", "align", "entry", "spanname", "entry", "namest", "entry", "nameend", "entry", "colname", "entry", "morerows", "entrytbl", "rowsep", "entrytbl", "colsep", "entrytbl", "align", "entrytbl", "spanname", "entrytbl", "namest", "entrytbl", "nameend", "entrytbl", "colname", "entrytbl", "cols"};
    protected Color borderColor;
    protected Color noBorderColor;
    protected StyledViewFactory viewFactory;
    private RowGroupInfo rowGroupInfo = new RowGroupInfo();
    private CellInfo cellInfo = new CellInfo();
    private StyleValue borderTopColorValue = new StyleValue(27);
    private StyleValue borderBottomColorValue = new StyleValue(27);
    private StyleValue borderLeftColorValue = new StyleValue(27);
    private StyleValue borderRightColorValue = new StyleValue(27);
    private StyleValue textAlignValue = new StyleValue();
    private StyleValue verticalAlignValue = new StyleValue();
    private StyleValue rowSpanValue = new StyleValue(0);
    private StyleValue columnSpanValue = new StyleValue(0);
    private StyleValue startColumnValue = new StyleValue(0);
    private StyleValue widthValue = new StyleValue();

    public StyleSpecsImpl(StyledViewFactory styledViewFactory, Color color, Color color2) {
        this.borderColor = color;
        this.noBorderColor = color2;
        int n = 0;
        while (n < DEPENDENCIES.length) {
            styledViewFactory.addDependency(null, DEPENDENCIES[n], Namespace.NONE, DEPENDENCIES[n + 1]);
            n += 2;
        }
        this.viewFactory = styledViewFactory;
    }

    public int findStyleSpec(Element element, StyleSpec[] styleSpecArray) {
        String string = element.getLocalName();
        if (string.equals("entry") ? this.addCellStyle(element, false, styleSpecArray[0]) : (string.equals("entrytbl") ? this.addCellStyle(element, true, styleSpecArray[0]) : string.equals("tgroup") && this.addTableGroupStyle(element, styleSpecArray[0]))) {
            return 1;
        }
        return 0;
    }

    private boolean addTableGroupStyle(Element element, StyleSpec styleSpec) {
        if (this.borderColor == null) {
            return false;
        }
        Element element2 = element.getParentElement();
        if (element2 == null) {
            return false;
        }
        String string = element2.getLocalName();
        if (!string.equals("table") && !string.equals("informaltable")) {
            return false;
        }
        int n = 1;
        String string2 = element2.getAttribute(TableAttributeNames.FRAME);
        if (string2 != null) {
            n = string2.equals("all") ? 1 : (string2.equals("none") ? 0 : (string2.equals("topbot") ? 5 : (string2.equals("sides") ? 2 : (string2.equals("top") ? 3 : (string2.equals("bottom") ? 4 : 0)))));
        }
        switch (n) {
            case 5: {
                this.setBorderTopColor(styleSpec, StyleSpecsImpl.isFirstTableGroup(element) ? this.borderColor : this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, StyleSpecsImpl.isLastTableGroup(element) ? this.borderColor : this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 3: {
                this.setBorderTopColor(styleSpec, StyleSpecsImpl.isFirstTableGroup(element) ? this.borderColor : this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 4: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, StyleSpecsImpl.isLastTableGroup(element) ? this.borderColor : this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
                break;
            }
            case 1: {
                this.setBorderTopColor(styleSpec, StyleSpecsImpl.isFirstTableGroup(element) ? this.borderColor : this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.borderColor);
                this.setBorderBottomColor(styleSpec, StyleSpecsImpl.isLastTableGroup(element) ? this.borderColor : this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.borderColor);
                break;
            }
            case 2: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.borderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.borderColor);
                break;
            }
            default: {
                this.setBorderTopColor(styleSpec, this.noBorderColor);
                this.setBorderRightColor(styleSpec, this.noBorderColor);
                this.setBorderBottomColor(styleSpec, this.noBorderColor);
                this.setBorderLeftColor(styleSpec, this.noBorderColor);
            }
        }
        return true;
    }

    private void setBorderTopColor(StyleSpec styleSpec, Color color) {
        this.borderTopColorValue.color = color;
        styleSpec.borderTopColor = this.borderTopColorValue;
    }

    private void setBorderBottomColor(StyleSpec styleSpec, Color color) {
        this.borderBottomColorValue.color = color;
        styleSpec.borderBottomColor = this.borderBottomColorValue;
    }

    private void setBorderLeftColor(StyleSpec styleSpec, Color color) {
        this.borderLeftColorValue.color = color;
        styleSpec.borderLeftColor = this.borderLeftColorValue;
    }

    private void setBorderRightColor(StyleSpec styleSpec, Color color) {
        this.borderRightColorValue.color = color;
        styleSpec.borderRightColor = this.borderRightColorValue;
    }

    private static boolean isFirstTableGroup(Element element) {
        Node node = element.getPreviousSibling();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("tgroup")) {
                return false;
            }
            node = node.getPreviousSibling();
        }
        return true;
    }

    private static boolean isLastTableGroup(Element element) {
        Node node = element.getNextSibling();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("tgroup")) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    private boolean addCellStyle(Element element, boolean bl, StyleSpec styleSpec) {
        Object object;
        if (!this.rowGroupInfo.compute(element, this.cellInfo)) {
            return false;
        }
        String string = element.getAttribute(TableAttributeNames.ALIGN);
        if (string == null) {
            if (this.cellInfo.spanSpec != null) {
                string = this.cellInfo.spanSpec.align;
            }
            if (string == null && this.cellInfo.startColSpec != null) {
                string = this.cellInfo.startColSpec.align;
            }
            if (string == null && this.rowGroupInfo.tableGroup != null) {
                string = this.rowGroupInfo.tableGroup.getAttribute(TableAttributeNames.ALIGN);
            }
        }
        if (string != null) {
            if ("left".equals(string = string.trim()) || "justify".equals(string) || "char".equals(string)) {
                this.setTextAlign(styleSpec, 62);
            } else if ("center".equals(string)) {
                this.setTextAlign(styleSpec, 64);
            } else if ("right".equals(string)) {
                this.setTextAlign(styleSpec, 63);
            }
        }
        if (!bl) {
            string = element.getAttribute(TableAttributeNames.VALIGN);
            if (string == null) {
                object = element.getParentElement();
                while (object != null) {
                    String string2 = object.getLocalName();
                    if (!string2.equals("row") && !string2.equals("tbody") && !string2.equals("thead") && !string2.equals("tfoot") || (string = object.getAttribute(TableAttributeNames.VALIGN)) != null) break;
                    object = object.getParentElement();
                }
            }
            if (string != null) {
                if ("middle".equals(string = string.trim())) {
                    this.setVerticalAlign(styleSpec, 67);
                } else if ("top".equals(string)) {
                    this.setVerticalAlign(styleSpec, 66);
                } else if ("bottom".equals(string)) {
                    this.setVerticalAlign(styleSpec, 68);
                }
            }
        }
        this.setRowSpan(styleSpec, this.cellInfo.rowSpan);
        this.setColumnSpan(styleSpec, this.cellInfo.columnSpan);
        this.setStartColumn(styleSpec, this.cellInfo.column);
        if (this.cellInfo.startColSpec != null && this.cellInfo.startColSpec.width != null && this.cellInfo.columnSpan == 1 && StyleSpecsImpl.parseColWidth(this.cellInfo.startColSpec.width, this.widthValue)) {
            styleSpec.width = this.widthValue;
        }
        if (this.borderColor != null) {
            this.setBorderTopColor(styleSpec, this.noBorderColor);
            this.setBorderLeftColor(styleSpec, this.noBorderColor);
            object = !StyleSpecsImpl.spansLastColumn(this.cellInfo, this.rowGroupInfo.tableGroup) ? (StyleSpecsImpl.hasColSep(this.cellInfo, this.rowGroupInfo.tableGroup) ? this.borderColor : this.noBorderColor) : this.noBorderColor;
            this.setBorderRightColor(styleSpec, (Color)object);
            object = !StyleSpecsImpl.spansLastRow(this.cellInfo, this.rowGroupInfo.tableGroup, this.rowGroupInfo.rowGroup) ? (StyleSpecsImpl.hasRowSep(this.cellInfo, this.rowGroupInfo.tableGroup) ? this.borderColor : this.noBorderColor) : this.noBorderColor;
            this.setBorderBottomColor(styleSpec, (Color)object);
        }
        return true;
    }

    private void setTextAlign(StyleSpec styleSpec, int n) {
        this.textAlignValue.type = n;
        styleSpec.textAlign = this.textAlignValue;
    }

    private void setVerticalAlign(StyleSpec styleSpec, int n) {
        this.verticalAlignValue.type = n;
        styleSpec.verticalAlign = this.verticalAlignValue;
    }

    private void setRowSpan(StyleSpec styleSpec, int n) {
        this.rowSpanValue.number = n;
        styleSpec.rowSpan = this.rowSpanValue;
    }

    private void setColumnSpan(StyleSpec styleSpec, int n) {
        this.columnSpanValue.number = n;
        styleSpec.columnSpan = this.columnSpanValue;
    }

    private void setStartColumn(StyleSpec styleSpec, int n) {
        this.startColumnValue.number = n;
        styleSpec.startColumn = this.startColumnValue;
    }

    private static boolean parseColWidth(String string, StyleValue styleValue) {
        String string2;
        String string3;
        int n = (string = string.trim()).indexOf(43);
        if (n < 0) {
            if (string.endsWith("*")) {
                string3 = null;
                string2 = string;
            } else {
                string3 = string;
                string2 = null;
            }
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
            if (string3.endsWith("*")) {
                return false;
            }
        }
        int n2 = -1;
        double d = 0.0;
        Object var8_7 = null;
        if (string3 != null) {
            if (string3.endsWith("pt")) {
                n2 = 9;
                string3 = string3.substring(0, string3.length() - 2);
            } else if (string3.endsWith("in")) {
                n2 = 6;
                string3 = string3.substring(0, string3.length() - 2);
            } else if (string3.endsWith("cm")) {
                n2 = 7;
                string3 = string3.substring(0, string3.length() - 2);
            } else if (string3.endsWith("mm")) {
                n2 = 8;
                string3 = string3.substring(0, string3.length() - 2);
            } else if (string3.endsWith("pi")) {
                n2 = 10;
                string3 = string3.substring(0, string3.length() - 2);
            } else {
                n2 = 9;
            }
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                d = -1.0;
            }
            if (d <= 0.0) {
                return false;
            }
        }
        int n3 = -1;
        double d2 = 0.0;
        String string4 = "*";
        if (string2 != null) {
            n3 = 21;
            if (!string2.endsWith("*")) {
                return false;
            }
            if ("*".equals(string2)) {
                d2 = 1.0;
            } else {
                string2 = string2.substring(0, string2.length() - 1);
                try {
                    d2 = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = -1.0;
                }
                if (d2 <= 0.0) {
                    return false;
                }
            }
        }
        if (n2 != -1) {
            if (n3 != -1) {
                StyleValue styleValue2 = new StyleValue();
                styleValue2.type = n2;
                styleValue2.number = d;
                styleValue2.string = var8_7;
                StyleValue styleValue3 = new StyleValue();
                styleValue3.type = n3;
                styleValue3.number = d2;
                styleValue3.string = string4;
                styleValue.type = 4;
                styleValue.list = new StyleValue[]{styleValue2, styleValue3};
            } else {
                styleValue.type = n2;
                styleValue.number = d;
                styleValue.string = var8_7;
            }
        } else if (n3 != -1) {
            styleValue.type = n3;
            styleValue.number = d2;
            styleValue.string = string4;
        } else {
            return false;
        }
        return true;
    }

    private static boolean spansLastColumn(CellInfo cellInfo, Element element) {
        if (!StyleSpecsImpl.isLastCell(cellInfo.element)) {
            return false;
        }
        int n = element.getIntAttribute(TableAttributeNames.COLS, 1, Integer.MAX_VALUE, -1);
        if (n <= 0) {
            return false;
        }
        return cellInfo.column + cellInfo.columnSpan == n;
    }

    private static boolean isLastCell(Element element) {
        Node node = element.getNextSibling();
        while (node != null) {
            String string;
            if (node instanceof Element && ((string = ((Element)node).getLocalName()).equals("entry") || string.equals("entrytbl"))) {
                return false;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    private static boolean spansLastRow(CellInfo cellInfo, Element element, Element element2) {
        if (element == null || !StyleSpecsImpl.isLastTableGroup(element)) {
            return false;
        }
        if (element2 == null || !element2.getLocalName().equals("tbody")) {
            return false;
        }
        Element element3 = cellInfo.element.getParentElement();
        if (element3 == null || !element3.getLocalName().equals("row")) {
            return false;
        }
        return StyleSpecsImpl.isLastRow(element3, cellInfo.rowSpan - 1);
    }

    private static boolean isLastRow(Element element, int n) {
        Node node = element.getNextSibling();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("row")) {
                if (n == 0) {
                    return false;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return true;
    }

    private static boolean hasColSep(CellInfo cellInfo, Element element) {
        Element element2;
        String string = cellInfo.element.getAttribute(TableAttributeNames.COLSEP);
        if (string != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        if (cellInfo.spanSpec != null && (string = cellInfo.spanSpec.colSep) != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        if (cellInfo.startColSpec != null && (string = cellInfo.startColSpec.colSep) != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        if (element != null) {
            string = element.getAttribute(TableAttributeNames.COLSEP);
            if (string != null) {
                return StyleSpecsImpl.parseSep(string);
            }
            if (element.getLocalName().equals("entrytbl")) {
                return true;
            }
        }
        if ((element2 = element.getParentElement()) == null) {
            return false;
        }
        String string2 = element2.getLocalName();
        if (!string2.equals("table") && !string2.equals("informaltable")) {
            return false;
        }
        string = element2.getAttribute(TableAttributeNames.COLSEP);
        if (string != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        return true;
    }

    private static boolean hasRowSep(CellInfo cellInfo, Element element) {
        Element element2;
        String string = cellInfo.element.getAttribute(TableAttributeNames.ROWSEP);
        if (string != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        Element element3 = cellInfo.element.getParentElement();
        if (element3 == null || !element3.getLocalName().equals("row")) {
            return false;
        }
        string = element3.getAttribute(TableAttributeNames.ROWSEP);
        if (string != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        if (cellInfo.spanSpec != null && (string = cellInfo.spanSpec.rowSep) != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        if (cellInfo.startColSpec != null && (string = cellInfo.startColSpec.rowSep) != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        if (element != null) {
            string = element.getAttribute(TableAttributeNames.ROWSEP);
            if (string != null) {
                return StyleSpecsImpl.parseSep(string);
            }
            if (element.getLocalName().equals("entrytbl")) {
                return true;
            }
        }
        if ((element2 = element.getParentElement()) == null) {
            return false;
        }
        String string2 = element2.getLocalName();
        if (!string2.equals("table") && !string2.equals("informaltable")) {
            return false;
        }
        string = element2.getAttribute(TableAttributeNames.ROWSEP);
        if (string != null) {
            return StyleSpecsImpl.parseSep(string);
        }
        return true;
    }

    private static boolean parseSep(String string) {
        return "1".equals(string.trim());
    }
}

