/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.docbook.table;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.docbook.table.CellInfo;
import com.xmlmind.xmleditapp.docbook.table.Msg;
import com.xmlmind.xmleditapp.docbook.table.RowGroupInfo;
import com.xmlmind.xmleditapp.docbook.table.TableAttributeNames;
import com.xmlmind.xmleditapp.docbook.table.TableCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TableRow
extends TableCommand
implements TableAttributeNames {
    private static String[] COPIED_ATTRIBUTES = new String[]{"align", "char", "charoff", "colname", "colsep", "nameend", "namest", "rotate", "rowsep", "spanname", "valign"};
    private static CellInfoCompare cellInfoCompare = new CellInfoCompare();

    public TableRow() {
        super(true);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        String string2;
        Document document = documentView.getDocument();
        RowGroupInfo rowGroupInfo = new RowGroupInfo();
        if (!rowGroupInfo.compute(this.selectedCell)) {
            ShowStatus.showStatus((String)Msg.msg("invalidTable"));
            return null;
        }
        CellInfo cellInfo = rowGroupInfo.getCell(this.selectedCell);
        if (cellInfo == null) {
            ShowStatus.showStatus((String)Msg.msg("invalidTable"));
            return null;
        }
        int n3 = cellInfo.row;
        Element element = this.selectedCell.getParentElement();
        Element element2 = element.getParentElement();
        Element element3 = null;
        if (this.delete) {
            if (TableRow.getRowCount(element2) <= 1) {
                ShowStatus.showStatus((String)Msg.msg("cannotDeleteLastRow"));
                return null;
            }
            document.beginBatchEditing();
            string2 = Msg.msg("deleteRow");
            int n4 = rowGroupInfo.cells.size();
            int n5 = 0;
            while (n5 < n4) {
                cellInfo = (CellInfo)rowGroupInfo.cells.get(n5);
                if (n3 >= cellInfo.row && n3 < cellInfo.row + cellInfo.rowSpan && cellInfo.rowSpan > 1) {
                    if (n3 == cellInfo.row) {
                        TableRow.insertShorterClone(cellInfo, element, rowGroupInfo.cells);
                    } else {
                        int n6 = cellInfo.rowSpan - 2;
                        if (n6 > 0) {
                            cellInfo.element.putAttribute(TableAttributeNames.MOREROWS, Integer.toString(n6));
                        } else {
                            cellInfo.element.removeAttribute(TableAttributeNames.MOREROWS);
                        }
                    }
                }
                ++n5;
            }
            element2.removeChild((Node)element);
            element3 = element2;
        } else {
            document.beginBatchEditing();
            Element element4 = this.newRow(element);
            ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
            if (this.before) {
                string2 = Msg.msg("insertRowBefore");
                int n7 = rowGroupInfo.cells.size();
                int n8 = 0;
                while (n8 < n7) {
                    cellInfo = (CellInfo)rowGroupInfo.cells.get(n8);
                    if (n3 >= cellInfo.row && n3 < cellInfo.row + cellInfo.rowSpan) {
                        if (n3 == cellInfo.row) {
                            CellInfo cellInfo2 = new CellInfo();
                            cellInfo2.element = this.newCell(cellInfo.element);
                            cellInfo2.column = cellInfo.column;
                            arrayList.add(cellInfo2);
                        } else {
                            cellInfo.element.putAttribute(TableAttributeNames.MOREROWS, Integer.toString(cellInfo.rowSpan));
                        }
                    }
                    ++n8;
                }
                TableRow.addCellsSortedByCol(arrayList, element4);
                element2.insertChild((Node)element, (Node)element4);
            } else {
                string2 = Msg.msg("insertRowAfter");
                int n9 = rowGroupInfo.cells.size();
                int n10 = 0;
                while (n10 < n9) {
                    cellInfo = (CellInfo)rowGroupInfo.cells.get(n10);
                    if (n3 >= cellInfo.row && n3 < cellInfo.row + cellInfo.rowSpan) {
                        if (n3 == cellInfo.row + cellInfo.rowSpan - 1) {
                            CellInfo cellInfo3 = new CellInfo();
                            cellInfo3.element = this.newCell(cellInfo.element);
                            cellInfo3.column = cellInfo.column;
                            arrayList.add(cellInfo3);
                        } else {
                            cellInfo.element.putAttribute(TableAttributeNames.MOREROWS, Integer.toString(cellInfo.rowSpan));
                        }
                    }
                    ++n10;
                }
                TableRow.addCellsSortedByCol(arrayList, element4);
                element2.insertChild(element.getNextSibling(), (Node)element4);
            }
            element3 = element4;
        }
        document.endBatchEditing();
        documentView.describeUndo(string2);
        if (element3 != null) {
            documentView.selectNode((Node)element3);
            documentView.moveDotInto((Node)element3);
        }
        return null;
    }

    private static final int getRowCount(Element element) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("row")) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    private static final void insertShorterClone(CellInfo cellInfo, Element element, ArrayList arrayList) {
        Element element2 = null;
        Node node = element.getNextSibling();
        while (node != null) {
            if (node instanceof Element && ((Element)node).getLocalName().equals("row")) {
                element2 = (Element)node;
                break;
            }
            node = node.getNextSibling();
        }
        if (element2 == null) {
            return;
        }
        Element element3 = (Element)cellInfo.element.copy();
        int n = cellInfo.rowSpan - 2;
        if (n > 0) {
            element3.putAttribute(TableAttributeNames.MOREROWS, Integer.toString(n));
        } else {
            element3.removeAttribute(TableAttributeNames.MOREROWS);
        }
        CellInfo cellInfo2 = new CellInfo();
        cellInfo2.element = element3;
        cellInfo2.row = cellInfo.row + 1;
        cellInfo2.column = cellInfo.column;
        cellInfo2.rowSpan = cellInfo.rowSpan - 1;
        cellInfo2.columnSpan = cellInfo.columnSpan;
        cellInfo2.startColSpec = cellInfo.startColSpec;
        cellInfo2.endColSpec = cellInfo.endColSpec;
        cellInfo2.spanSpec = cellInfo.spanSpec;
        CellInfo cellInfo3 = null;
        node = element2.getFirstChild();
        while (node != null) {
            CellInfo cellInfo4;
            Element element4;
            String string;
            if (node instanceof Element && ((string = (element4 = (Element)node).getLocalName()).equals("entry") || string.equals("entrytbl")) && (cellInfo4 = RowGroupInfo.findCell(arrayList, element4)) != null && cellInfo4.column > cellInfo.column) {
                cellInfo3 = cellInfo4;
                break;
            }
            node = node.getNextSibling();
        }
        if (cellInfo3 == null) {
            element2.appendChild((Node)element3);
            arrayList.add(cellInfo2);
        } else {
            element2.insertChild((Node)cellInfo3.element, (Node)element3);
            arrayList.add(arrayList.indexOf(cellInfo3), cellInfo2);
        }
    }

    private Element newRow(Element element) {
        Element element2 = new Element(Name.get((Namespace)element.getNamespace(), (String)"row"));
        String string = element.getAttribute(TableAttributeNames.VALIGN);
        if (string != null) {
            element2.putAttribute(TableAttributeNames.VALIGN, string);
        }
        if ((string = element.getAttribute(TableAttributeNames.ROWSEP)) != null) {
            element2.putAttribute(TableAttributeNames.ROWSEP, string);
        }
        return element2;
    }

    private Element newCell(Element element) {
        Element element2 = new Element(Name.get((Namespace)element.getNamespace(), (String)"entry"));
        int n = 0;
        while (n < COPIED_ATTRIBUTES.length) {
            Name name = Name.get((String)COPIED_ATTRIBUTES[n]);
            String string = element.getAttribute(name);
            if (string != null) {
                element2.putAttribute(name, string);
            }
            ++n;
        }
        element2.appendChild((Node)new Text());
        return element2;
    }

    private static final void addCellsSortedByCol(ArrayList arrayList, Element element) {
        Collections.sort(arrayList, cellInfoCompare);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)arrayList.get(n2);
            element.appendChild((Node)cellInfo.element);
            ++n2;
        }
    }

    private static final class CellInfoCompare
    implements Comparator {
        private CellInfoCompare() {
        }

        public int compare(Object object, Object object2) {
            return ((CellInfo)object).column - ((CellInfo)object2).column;
        }
    }
}

