/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.spellcheck.engine;

import com.xmlmind.spellcheck.engine.CompiledTLex;
import com.xmlmind.spellcheck.engine.CompositeTLex;
import com.xmlmind.spellcheck.engine.DictionaryManagerItem;
import com.xmlmind.spellcheck.engine.EditableTLex;
import com.xmlmind.spellcheck.engine.SpellException;
import com.xmlmind.spellcheck.engine.TLex;
import com.xmlmind.spellcheck.util.CoreReader;
import com.xmlmind.spellcheck.util.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DictionaryManager {
    private String int;
    private Hashtable for = new Hashtable();
    private Hashtable if = new Hashtable();
    private Hashtable a = new Hashtable();
    private Hashtable try = new Hashtable();
    private Logger do;
    private static final String new = "/default";
    static final byte[] byte = new byte[]{64, 109, 117, 108, 116, 105, 108, 105, 110, 107, 58};

    public DictionaryManager() throws IOException {
        this(null);
    }

    public DictionaryManager(String string) throws IOException {
        if (string == null || (string = string.trim()).length() == 0) {
            string = this.a();
        }
        if (string != null) {
            this.setAccessPath(string);
        } else {
            this.defaultDictionaries();
        }
    }

    public void defineDictionary(String string, URL object) throws IOException {
        Object object2;
        this.a("defineDictionary " + string + " as " + object);
        if (string.indexOf(47) < 0) {
            string = string + new;
        }
        if (object == null) {
            object2 = this.getClass().getResource("/" + string);
            if (object2 == null) {
                throw new IOException("dictionary name '" + string + "' not locatable as a resource");
            }
            object = object2;
        }
        object2 = DictionaryManager.if(string);
        DictionaryManagerItem dictionaryManagerItem = new DictionaryManagerItem((String)object2);
        dictionaryManagerItem.location = object;
        this.for.put(string, dictionaryManagerItem);
        DictionaryManagerItem dictionaryManagerItem2 = (DictionaryManagerItem)this.a.get(object2);
        if (dictionaryManagerItem2 != null) {
            dictionaryManagerItem.english = dictionaryManagerItem2.english;
            dictionaryManagerItem.local = dictionaryManagerItem2.local;
            dictionaryManagerItem.encoding = dictionaryManagerItem2.encoding;
        }
    }

    public synchronized void setAccessPath(String string) throws IOException {
        this.a("setAccessPath " + string);
        if (string == null) {
            throw new IllegalArgumentException("dictPath argument must not be null");
        }
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                this.unloadDictionaries();
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    this.a(fileArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            this.a("setAccessPath: Security!");
        }
        this.defaultDictionaries();
    }

    public void defaultDictionaries() {
        this.a("en", "English", "English", "ISO8859_1");
        this.a("en-CA", "English (CA)", "English (CA)", "ISO8859_1");
        this.a("en-GB", "English (GB)", "English (GB)", "ISO8859_1");
        this.a("en-US", "English (US)", "English (US)", "ISO8859_1");
        this.a("fr", "French", "Fran\u00e7ais", "ISO8859_1");
        this.a("fr-BE", "French (BE)", "Fran\u00e7ais (BE)", "ISO8859_1");
        this.a("fr-CA", "French (CA)", "Fran\u00e7ais (CA)", "ISO8859_1");
        this.a("fr-CH", "French (CH)", "Fran\u00e7ais (CH)", "ISO8859_1");
        this.a("de", "German", "Deutsch", "ISO8859_1");
        this.a("es", "Spanish", "Espa\u00f1ol", "ISO8859_1");
        this.a("it", "Italian", "Italiano", "ISO8859_1");
        this.a("pt-PT", "Portuguese (PT)", "Portugu\u00eas (PT)", "ISO8859_1");
        this.a("pt-BR", "Portuguese (BR)", "Portugu\u00eas (BR)", "ISO8859_1");
        this.a("nl", "Dutch", "Nederlands", "ISO8859_1");
        this.a("nl-NL", "Dutch", "Nederlands", "ISO8859_1");
        this.a("nl-BE", "Dutch", "Vlaams", "ISO8859_1");
    }

    private String a() {
        try {
            this.int = System.getProperty("java.class.path");
            int n = 0;
            while (n < this.int.length()) {
                int n2 = this.int.indexOf(File.pathSeparatorChar, n);
                if (n2 < 0) {
                    n2 = this.int.length();
                }
                if (n2 != n) {
                    File file;
                    File file2 = new File(this.int.substring(n, n2 - n));
                    if (!file2.isDirectory()) {
                        file2 = file2.getParentFile();
                    }
                    if ((file = new File(file2, "dicts")).isDirectory()) {
                        return file.getCanonicalPath();
                    }
                }
                n = n2 + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void a(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            URL uRL = new URL("jar:file:" + file.getCanonicalPath() + "!/");
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (string.endsWith("/language") || string.endsWith("/") || string.endsWith(".cdi") || string.startsWith("META")) continue;
                this.if.put(string, new URL(uRL, string));
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void a(String string, String string2, String string3, String string4) {
        DictionaryManagerItem dictionaryManagerItem = new DictionaryManagerItem(string);
        dictionaryManagerItem.english = string2;
        dictionaryManagerItem.local = string3;
        dictionaryManagerItem.encoding = string4;
        this.a.put(string, dictionaryManagerItem);
        String string5 = string + new;
        URL uRL = this.getClass().getResource("/" + string5);
        if (uRL == null) {
            dictionaryManagerItem.location = this.if.get(string5);
            if (dictionaryManagerItem.location == null) {
                if (this.do != null) {
                    this.a(string5 + " not located! ");
                }
                return;
            }
            if (this.do != null) {
                this.a(string5 + " auto: " + dictionaryManagerItem.location);
            }
        } else {
            dictionaryManagerItem.location = uRL;
            if (this.do != null) {
                this.a(string5 + " as resource: " + uRL);
            }
        }
        this.for.put(string5, dictionaryManagerItem);
    }

    public synchronized void addAccessPaths(String string) throws IOException {
        int n = string.indexOf(File.pathSeparatorChar);
        if (n > 1) {
            throw new IllegalArgumentException("deprecated method");
        }
        this.setAccessPath(string);
    }

    public String getAccessPath() {
        return this.int;
    }

    public synchronized DictionaryManagerItem[] listLanguages() throws IOException {
        DictionaryManagerItem[] dictionaryManagerItemArray = new DictionaryManagerItem[this.for.size()];
        Enumeration enumeration = this.for.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            dictionaryManagerItemArray[n++] = (DictionaryManagerItem)enumeration.nextElement();
        }
        Arrays.sort(dictionaryManagerItemArray, new Comparator(){

            public int compare(Object object, Object object2) {
                DictionaryManagerItem dictionaryManagerItem = (DictionaryManagerItem)object;
                DictionaryManagerItem dictionaryManagerItem2 = (DictionaryManagerItem)object2;
                return dictionaryManagerItem.local.compareTo(dictionaryManagerItem2.local);
            }
        });
        return dictionaryManagerItemArray;
    }

    public DictionaryManagerItem getLanguageInfo(String string) {
        return (DictionaryManagerItem)this.a.get(string);
    }

    public synchronized void unloadDictionaries() {
        this.try = new Hashtable();
    }

    public synchronized void clear() {
        this.unloadDictionaries();
        this.for = new Hashtable();
        this.int = null;
    }

    public synchronized TLex load(String string, TLex tLex) throws IOException, SpellException {
        DictionaryManagerItem dictionaryManagerItem;
        if (string.indexOf(47) < 0) {
            string = string + new;
        }
        if ((dictionaryManagerItem = (DictionaryManagerItem)this.for.get(string)) == null) {
            throw new SpellException("undefined dictionary name: " + string);
        }
        TLex tLex2 = this.load((URL)dictionaryManagerItem.location, tLex);
        return tLex2;
    }

    public synchronized TLex load(URL uRL, TLex tLex) throws IOException, SpellException {
        byte[] byArray = this.a(uRL);
        if (byArray != null) {
            CompiledTLex compiledTLex = new CompiledTLex(uRL);
            compiledTLex.setReader(new CoreReader(byArray));
            return compiledTLex;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream == null) {
            throw new IOException("empty or unreachable dictionary: " + uRL);
        }
        byArray = this.a(0, inputStream);
        inputStream.close();
        if (byArray.length > 2 && byArray[0] == CompiledTLex.U[0] && byArray[1] == CompiledTLex.U[1]) {
            CompiledTLex compiledTLex = new CompiledTLex(uRL);
            compiledTLex.setReader(new CoreReader(byArray));
            a a2 = new a();
            a2.if = new SoftReference<byte[]>(byArray);
            ++a2.a;
            a2.do = byArray;
            this.try.put(uRL, a2);
            return compiledTLex;
        }
        if (byArray[0] == byte[0] && byArray[1] == byte[1]) {
            CompositeTLex compositeTLex = new CompositeTLex(uRL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
            if (uRL == null) {
                throw new IllegalArgumentException("base URL needed for loading composite dictionaries");
            }
            String string = bufferedReader.readLine();
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') {
                    if (!string.startsWith("##Copyright: ")) continue;
                    compositeTLex.setCopyright(string.substring(13));
                    continue;
                }
                boolean bl = false;
                if (string.charAt(0) == '?') {
                    bl = true;
                    string = string.substring(1);
                }
                TLex tLex2 = null;
                if (!bl) {
                    tLex2 = this.load(new URL(uRL, string), tLex);
                } else {
                    try {
                        tLex2 = this.load(new URL(uRL, string), tLex);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (tLex2 == null) continue;
                compositeTLex.a(tLex2);
                if (tLex != null) continue;
                tLex = tLex2;
            }
            return compositeTLex;
        }
        if (tLex == null) {
            throw new SpellException("cannot load text dictionary without hints");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        EditableTLex editableTLex = new EditableTLex(uRL == null ? "?" : uRL.toString(), tLex);
        editableTLex.a(bufferedReader, true);
        return editableTLex;
    }

    protected synchronized void a(CompiledTLex compiledTLex) throws IOException, SpellException {
        compiledTLex.setReader(new CoreReader(this.a((URL)compiledTLex.getLocation())));
    }

    byte[] a(URL uRL) throws IOException {
        a a2 = (a)this.try.get(uRL);
        if (a2 == null) {
            return null;
        }
        ++a2.a;
        byte[] byArray = a2.do;
        if (byArray == null) {
            byte[] byArray2 = byArray = a2.if == null ? null : (byte[])a2.if.get();
        }
        if (byArray != null) {
            return byArray;
        }
        InputStream inputStream = uRL.openStream();
        byArray = this.a(0, inputStream);
        inputStream.close();
        a2.if = new SoftReference<byte[]>(byArray);
        a2.do = byArray;
        return byArray;
    }

    synchronized boolean a(Object object) {
        a a2 = (a)this.try.get(object);
        if (a2 == null || a2.a == 0) {
            return false;
        }
        if (--a2.a == 0) {
            a2.do = null;
        }
        return true;
    }

    byte[] a(int n, InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray;
        Vector<byte[]> vector = new Vector<byte[]>();
        if (n > 0) {
            vector.add(new byte[n]);
        }
        int n3 = n;
        int n4 = 0;
        while (true) {
            byArray = new byte[65536];
            n2 = 0;
            int n5 = inputStream.read(byArray, n2, byArray.length);
            while (n5 > 0) {
                if ((n2 += n5) >= byArray.length) break;
                n5 = inputStream.read(byArray, n2, byArray.length - n2);
            }
            if (n2 <= 0) break;
            n3 += n2;
            vector.add(byArray);
        }
        byArray = new byte[n3];
        n2 = 0;
        while (n2 < vector.size()) {
            byte[] byArray2 = (byte[])vector.get(n2);
            System.arraycopy(byArray2, 0, byArray, n4, Math.min(n3, byArray2.length));
            n3 -= byArray2.length;
            n4 += byArray2.length;
            ++n2;
        }
        return byArray;
    }

    protected boolean a(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static String if(String string) {
        int n = string.indexOf(47);
        return n < 0 ? string : string.substring(0, n);
    }

    private void a(String string) {
        if (this.do != null) {
            this.do.log(string);
        }
    }

    public void setLogger(Logger logger) {
        this.do = logger;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class a {
        int a;
        byte[] do;
        SoftReference if;

        private a() {
        }
    }
}

