/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.fop;

import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmleditapp.process.FOProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.messaging.MessageHandler;
import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class FOP
implements FOProcessor {
    public String getName() {
        return "FOP";
    }

    public String getDescription() {
        return "FOP 0.20.5, converts XSL-FO to PDF, PostScript[tm], etc.\nSee http://xmlgraphics.apache.org/fop/.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processFO(File file, File file2, String[] stringArray, final Console console) throws Exception {
        Object object;
        Object object2;
        Driver driver = new Driver();
        driver.setXMLReader(FOP.newXMLReader());
        Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
        hierarchy.setDefaultLogTarget(new LogTarget(){

            public void processEvent(LogEvent logEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(logEvent.getCategory());
                stringBuffer.append(": ");
                stringBuffer.append(logEvent.getPriority().getName());
                stringBuffer.append(": ");
                stringBuffer.append(logEvent.getMessage());
                console.showMessage(stringBuffer.toString(), 0);
            }
        });
        Logger logger = hierarchy.getLoggerFor("FOP");
        logger.setPriority(Priority.INFO);
        LogKitLogger logKitLogger = new LogKitLogger(logger);
        MessageHandler.setScreenLogger(logKitLogger);
        driver.setLogger(logKitLogger);
        URL uRL = FileUtil.fileToURL((File)file);
        Configuration.put("baseDir", URLUtil.getDirectory((URL)uRL).toExternalForm());
        int n = -1;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                object2 = stringArray[n2];
                object = stringArray[n2 + 1];
                if (((String)object2).equalsIgnoreCase("renderer")) {
                    if (((String)object).equalsIgnoreCase("pdf")) {
                        n = 1;
                    } else if (((String)object).equalsIgnoreCase("ps")) {
                        n = 7;
                    } else if (((String)object).equalsIgnoreCase("pcl")) {
                        n = 6;
                    } else if (((String)object).equalsIgnoreCase("svg")) {
                        n = 9;
                    } else if (((String)object).equalsIgnoreCase("xml")) {
                        n = 4;
                    } else if (((String)object).equalsIgnoreCase("mif")) {
                        n = 3;
                    } else {
                        if (!((String)object).equalsIgnoreCase("txt")) throw new IllegalArgumentException("'" + (String)object + "' unknown renderer type");
                        n = 8;
                    }
                } else if (((String)object2).equalsIgnoreCase("configuration")) {
                    URL uRL2 = null;
                    if (((String)(object = ((String)object).trim())).length() > 0) {
                        File file3;
                        try {
                            uRL2 = new URL((String)object);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (uRL2 == null && (file3 = new File((String)object)).isFile()) {
                            uRL2 = FileUtil.fileToURL((File)file3);
                        }
                    }
                    if (uRL2 != null) {
                        new Options(new InputSource(uRL2.toExternalForm()));
                    }
                } else {
                    Configuration.put((String)object2, object);
                }
                n2 += 2;
            }
        }
        if (n < 0) {
            String string = FileUtil.fileExtension((String)file2.getPath());
            if (string.equalsIgnoreCase("pdf")) {
                n = 1;
            } else if (string.equalsIgnoreCase("ps")) {
                n = 7;
            } else if (string.equalsIgnoreCase("pcl")) {
                n = 6;
            } else if (string.equalsIgnoreCase("svg")) {
                n = 9;
            } else if (string.equalsIgnoreCase("xml")) {
                n = 4;
            } else if (string.equalsIgnoreCase("mif")) {
                n = 3;
            } else {
                if (!string.equalsIgnoreCase("txt")) throw new IllegalArgumentException("cannot guess renderer type from extension '" + string + "'");
                n = 8;
            }
        }
        driver.setRenderer(n);
        FileInputStream fileInputStream = null;
        object2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            object = new InputSource(fileInputStream);
            ((InputSource)object).setSystemId(uRL.toExternalForm());
            driver.setInputSource((InputSource)object);
            object2 = new BufferedOutputStream(new FileOutputStream(file2));
            driver.setOutputStream((OutputStream)object2);
            driver.run();
            ((OutputStream)object2).flush();
            return;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (object2 != null) {
                ((OutputStream)object2).close();
            }
            FopImageFactory.resetCache();
        }
    }

    private static final XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        XMLReader xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        xMLReader.setEntityResolver(XMLCatalogs.getEntityResolver());
        return xMLReader;
    }
}

