/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.CharEntities;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class CharRange
implements Comparable {
    char first;
    char last;

    public CharRange(char c) {
        this(c, c);
    }

    public CharRange(char c, char c2) {
        if (c2 < c) {
            throw new IllegalArgumentException("invalid range 0x" + Integer.toHexString(c) + ":0x" + Integer.toHexString(c2));
        }
        this.first = c;
        this.last = c2;
    }

    public char getFirst() {
        return this.first;
    }

    public char getLast() {
        return this.last;
    }

    public int compareTo(Object object) {
        CharRange charRange = (CharRange)object;
        return this.first - charRange.first;
    }

    public static CharRange[] parseRanges(String string) {
        CharRange[] charRangeArray;
        ArrayList<CharRange> arrayList = new ArrayList<CharRange>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            charRangeArray = stringTokenizer.nextToken();
            CharRange charRange = CharRange.fromString((String)charRangeArray);
            if (charRange == null) {
                return null;
            }
            arrayList.add(charRange);
        }
        charRangeArray = new CharRange[arrayList.size()];
        arrayList.toArray(charRangeArray);
        return charRangeArray;
    }

    public static CharRange fromString(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(58);
        if (n3 < 0) {
            n = n2 = CharRange.parseChar(string);
        } else {
            n = CharRange.parseChar(string.substring(0, n3));
            n2 = CharRange.parseChar(string.substring(n3 + 1));
        }
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (n > n2) {
            return null;
        }
        return new CharRange((char)n, (char)n2);
    }

    public static int parseChar(String string) {
        int n = string.length();
        if (n == 0) {
            return -1;
        }
        int n2 = -1;
        char c = string.charAt(0);
        if (c == '0') {
            if (n > 1) {
                if (n > 2 && (string.charAt(1) == 'x' || string.charAt(1) == 'X')) {
                    try {
                        n2 = Integer.parseInt(string.substring(2), 16);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    try {
                        n2 = Integer.parseInt(string.substring(1), 8);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                n2 = 0;
            }
        } else if (Character.isDigit(c)) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            n2 = CharEntities.getDocBookInstance().getChar(string);
        }
        if (n2 < 0 || n2 > 65535) {
            return -1;
        }
        return n2;
    }

    public static boolean contains(CharRange[] charRangeArray, char c) {
        int n = 0;
        int n2 = charRangeArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            CharRange charRange = charRangeArray[n3];
            if (c > charRange.last) {
                n = n3 + 1;
                continue;
            }
            if (c < charRange.first) {
                n2 = n3 - 1;
                continue;
            }
            return true;
        }
        return false;
    }
}

