/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.BatchEditingEvent;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.DocumentListener;
import com.xmlmind.xmledit.doc.DocumentTypeDeclaration;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementAttributeEvent;
import com.xmlmind.xmledit.doc.ElementStructureEvent;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.ProcessingInstructionEvent;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextEvent;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.util.Enumeration;

public final class Document
extends Tree
implements NamespacePrefixMap {
    private boolean topChildrenUnset;
    private DocumentTypeDeclaration documentTypeDeclaration;
    private Element rootElement;
    private Object cachedNamespacePrefixMap;
    private Object cachedDocumentType;
    private Object cachedPreserveSpaceMatcher;
    private int batchEditingNesting = 0;
    private DocumentListener[] listenersNoData = new DocumentListener[0];
    private DocumentListener[] listeners = new DocumentListener[0];
    private TextEvent textEvent = new TextEvent();
    private ElementStructureEvent elementStructureEvent = new ElementStructureEvent();
    private ElementAttributeEvent elementAttributeEvent = new ElementAttributeEvent();
    private ProcessingInstructionEvent processingInstructionEvent = new ProcessingInstructionEvent();
    private BatchEditingEvent batchEditingEvent = new BatchEditingEvent();

    public Node copy() {
        Document document = new Document();
        if (this.properties != null) {
            document.properties = (LinearHashtable)this.properties.clone();
            document.cachedNamespacePrefixMap = this.cachedNamespacePrefixMap;
            document.cachedDocumentType = this.cachedDocumentType;
            document.cachedPreserveSpaceMatcher = this.cachedPreserveSpaceMatcher;
        }
        document.readOnly = this.readOnly;
        Node node = this.getFirstChild();
        while (node != null) {
            document.appendChild(node.copy());
            node = node.getNextSibling();
        }
        return document;
    }

    public int getNodeType() {
        return 5;
    }

    public Document getDocument() {
        return this;
    }

    public DocumentTypeDeclaration getDocumentTypeDeclaration() {
        if (this.topChildrenUnset) {
            this.setTopChildren();
        }
        return this.documentTypeDeclaration;
    }

    public Element getRootElement() {
        if (this.topChildrenUnset) {
            this.setTopChildren();
        }
        return this.rootElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setTopChildren() {
        this.topChildrenUnset = false;
        this.documentTypeDeclaration = null;
        this.rootElement = null;
        Node node = this.first;
        while (node != null) {
            if (node instanceof DocumentTypeDeclaration) {
                if (this.documentTypeDeclaration != null) throw new RuntimeException("document contains several document type declarations");
                this.documentTypeDeclaration = (DocumentTypeDeclaration)node;
            } else if (node instanceof Element) {
                if (this.rootElement != null) throw new RuntimeException("document contains several root elements");
                this.rootElement = (Element)node;
            }
            node = node.getNextSibling();
        }
    }

    public void insertChild(Node node, Node node2) {
        super.insertChild(node, node2);
        if (!this.topChildrenUnset) {
            this.unsetTopChildren();
        }
    }

    public void replaceChild(Node node, Node node2) {
        super.replaceChild(node, node2);
        if (!this.topChildrenUnset) {
            this.unsetTopChildren();
        }
    }

    private void unsetTopChildren() {
        this.topChildrenUnset = true;
        this.documentTypeDeclaration = null;
        this.rootElement = null;
    }

    public void beginBatchEditing() {
        if (this.batchEditingNesting == 0) {
            this.batchEditingNotification(this, 40);
        }
        ++this.batchEditingNesting;
    }

    public void endBatchEditing() {
        if (this.batchEditingNesting > 0) {
            --this.batchEditingNesting;
            if (this.batchEditingNesting == 0) {
                this.batchEditingNotification(this, 41);
            }
        }
    }

    public void addDocumentListener(DocumentListener documentListener, boolean bl) {
        this.addDocumentListener(documentListener, bl, false);
    }

    public void addDocumentListener(DocumentListener documentListener, boolean bl, final boolean bl2) {
        if (this.documentListenerIndex(documentListener) >= 0 || this.findListenerNoData(documentListener) >= 0) {
            return;
        }
        if (bl) {
            DocumentListener[] documentListenerArray = new DocumentListener[this.listeners.length + 1];
            if (bl2) {
                documentListenerArray[0] = documentListener;
                if (this.listeners.length > 0) {
                    System.arraycopy(this.listeners, 0, documentListenerArray, 1, this.listeners.length);
                }
            } else {
                if (this.listeners.length > 0) {
                    System.arraycopy(this.listeners, 0, documentListenerArray, 0, this.listeners.length);
                }
                documentListenerArray[this.listeners.length] = documentListener;
            }
            this.listeners = documentListenerArray;
            Element element = this.getRootElement();
            if (element != null) {
                Traversal.HandlerBase handlerBase = new Traversal.HandlerBase(){

                    public Object processText(Text text) {
                        text.listenerAdded(bl2);
                        return null;
                    }

                    public Object processPI(ProcessingInstruction processingInstruction) {
                        processingInstruction.listenerAdded(bl2);
                        return null;
                    }

                    public Object processComment(Comment comment) {
                        comment.listenerAdded(bl2);
                        return null;
                    }

                    public Object enterElement(Element element) {
                        element.listenerAdded(bl2);
                        return null;
                    }
                };
                Traversal.traverse(element, handlerBase);
            }
        } else {
            DocumentListener[] documentListenerArray = new DocumentListener[this.listenersNoData.length + 1];
            if (bl2) {
                documentListenerArray[0] = documentListener;
                if (this.listenersNoData.length > 0) {
                    System.arraycopy(this.listenersNoData, 0, documentListenerArray, 1, this.listenersNoData.length);
                }
            } else {
                if (this.listenersNoData.length > 0) {
                    System.arraycopy(this.listenersNoData, 0, documentListenerArray, 0, this.listenersNoData.length);
                }
                documentListenerArray[this.listenersNoData.length] = documentListener;
            }
            this.listenersNoData = documentListenerArray;
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        final int n = this.documentListenerIndex(documentListener);
        if (n >= 0) {
            int n2;
            int n3;
            DocumentListener[] documentListenerArray = new DocumentListener[this.listeners.length - 1];
            if (n > 0) {
                System.arraycopy(this.listeners, 0, documentListenerArray, 0, n);
            }
            if ((n3 = this.listeners.length - (n2 = n + 1)) > 0) {
                System.arraycopy(this.listeners, n2, documentListenerArray, n, n3);
            }
            this.listeners = documentListenerArray;
            Element element = this.getRootElement();
            if (element != null) {
                Traversal.HandlerBase handlerBase = new Traversal.HandlerBase(){

                    public Object processText(Text text) {
                        text.listenerRemoved(n);
                        return null;
                    }

                    public Object processPI(ProcessingInstruction processingInstruction) {
                        processingInstruction.listenerRemoved(n);
                        return null;
                    }

                    public Object processComment(Comment comment) {
                        comment.listenerRemoved(n);
                        return null;
                    }

                    public Object enterElement(Element element) {
                        element.listenerRemoved(n);
                        return null;
                    }
                };
                Traversal.traverse(element, handlerBase);
            }
        } else {
            int n4 = this.findListenerNoData(documentListener);
            if (n4 >= 0) {
                int n5;
                int n6;
                DocumentListener[] documentListenerArray = new DocumentListener[this.listenersNoData.length - 1];
                if (n4 > 0) {
                    System.arraycopy(this.listenersNoData, 0, documentListenerArray, 0, n4);
                }
                if ((n6 = this.listenersNoData.length - (n5 = n4 + 1)) > 0) {
                    System.arraycopy(this.listenersNoData, n5, documentListenerArray, n4, n6);
                }
                this.listenersNoData = documentListenerArray;
            }
        }
    }

    public int documentListenerIndex(DocumentListener documentListener) {
        int n = 0;
        while (n < this.listeners.length) {
            if (this.listeners[n] == documentListener) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getDocumentListenerCount(boolean bl) {
        return bl ? this.listeners.length : this.listenersNoData.length;
    }

    public DocumentListener getDocumentListener(int n, boolean bl) {
        return bl ? this.listeners[n] : this.listenersNoData[n];
    }

    private int findListenerNoData(DocumentListener documentListener) {
        int n = 0;
        while (n < this.listenersNoData.length) {
            if (this.listenersNoData[n] == documentListener) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void notifyDocumentListeners(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.listeners;
        DocumentListener[] documentListenerArray2 = this.listenersNoData;
        int n = documentEvent.getId();
        if (n <= 9) {
            int n2 = 0;
            while (n2 < documentListenerArray.length) {
                documentListenerArray[n2].textChanged((TextEvent)documentEvent, n2);
                ++n2;
            }
            n2 = 0;
            while (n2 < documentListenerArray2.length) {
                documentListenerArray2[n2].textChanged((TextEvent)documentEvent, -1);
                ++n2;
            }
        } else if (n <= 19) {
            int n3 = 0;
            while (n3 < documentListenerArray.length) {
                documentListenerArray[n3].elementStructureChanged((ElementStructureEvent)documentEvent, n3);
                ++n3;
            }
            n3 = 0;
            while (n3 < documentListenerArray2.length) {
                documentListenerArray2[n3].elementStructureChanged((ElementStructureEvent)documentEvent, -1);
                ++n3;
            }
        } else if (n <= 29) {
            int n4 = 0;
            while (n4 < documentListenerArray.length) {
                documentListenerArray[n4].elementAttributeChanged((ElementAttributeEvent)documentEvent, n4);
                ++n4;
            }
            n4 = 0;
            while (n4 < documentListenerArray2.length) {
                documentListenerArray2[n4].elementAttributeChanged((ElementAttributeEvent)documentEvent, -1);
                ++n4;
            }
        } else if (n <= 39) {
            int n5 = 0;
            while (n5 < documentListenerArray.length) {
                documentListenerArray[n5].processingInstructionChanged((ProcessingInstructionEvent)documentEvent, n5);
                ++n5;
            }
            n5 = 0;
            while (n5 < documentListenerArray2.length) {
                documentListenerArray2[n5].processingInstructionChanged((ProcessingInstructionEvent)documentEvent, -1);
                ++n5;
            }
        } else {
            switch (n) {
                case 40: {
                    int n6 = 0;
                    while (n6 < documentListenerArray.length) {
                        documentListenerArray[n6].batchEditingStarted((BatchEditingEvent)documentEvent, n6);
                        ++n6;
                    }
                    n6 = 0;
                    while (n6 < documentListenerArray2.length) {
                        documentListenerArray2[n6].batchEditingStarted((BatchEditingEvent)documentEvent, -1);
                        ++n6;
                    }
                    break;
                }
                case 41: {
                    int n7 = 0;
                    while (n7 < documentListenerArray.length) {
                        documentListenerArray[n7].batchEditingCompleted((BatchEditingEvent)documentEvent, n7);
                        ++n7;
                    }
                    n7 = 0;
                    while (n7 < documentListenerArray2.length) {
                        documentListenerArray2[n7].batchEditingCompleted((BatchEditingEvent)documentEvent, -1);
                        ++n7;
                    }
                    break;
                }
                default: {
                    int n8 = 0;
                    while (n8 < documentListenerArray.length) {
                        documentListenerArray[n8].customEventHappened(documentEvent, n8);
                        ++n8;
                    }
                    n8 = 0;
                    while (n8 < documentListenerArray2.length) {
                        documentListenerArray2[n8].customEventHappened(documentEvent, -1);
                        ++n8;
                    }
                    break;
                }
            }
        }
    }

    void textNotification(Object object, int n, int n2, String string, String string2) {
        this.textEvent.initialize(object, n, n2, string, string2);
        this.notifyDocumentListeners(this.textEvent);
    }

    void elementStructureNotification(Object object, int n, Node node, Node node2, Node node3) {
        this.elementStructureEvent.initialize(object, n, node, node2, node3);
        this.notifyDocumentListeners(this.elementStructureEvent);
    }

    void elementAttributeNotification(Object object, int n, Name name, String string, String string2) {
        this.elementAttributeEvent.initialize(object, n, name, string, string2);
        this.notifyDocumentListeners(this.elementAttributeEvent);
    }

    void processingInstructionNotification(Object object, int n, String string) {
        this.processingInstructionEvent.initialize(object, n, string);
        this.notifyDocumentListeners(this.processingInstructionEvent);
    }

    void batchEditingNotification(Object object, int n) {
        this.batchEditingEvent.initialize(object, n);
        this.notifyDocumentListeners(this.batchEditingEvent);
    }

    public Object putProperty(Object object, Object object2) {
        Object object3 = super.putProperty(object, object2);
        if (object == "NAMESPACE_PREFIX_MAP") {
            this.cachedNamespacePrefixMap = object2;
        } else if (object == "DOCUMENT_TYPE") {
            this.cachedDocumentType = object2;
        } else if (object == "PRESERVE_SPACE_ELEMENTS") {
            this.cachedPreserveSpaceMatcher = object2;
        }
        return object3;
    }

    public Object removeProperty(Object object) {
        Object object2 = super.removeProperty(object);
        if (object == "NAMESPACE_PREFIX_MAP") {
            this.cachedNamespacePrefixMap = null;
        } else if (object == "DOCUMENT_TYPE") {
            this.cachedDocumentType = null;
        } else if (object == "PRESERVE_SPACE_ELEMENTS") {
            this.cachedPreserveSpaceMatcher = null;
        }
        return object2;
    }

    public void removeAllProperties() {
        super.removeAllProperties();
        this.cachedNamespacePrefixMap = null;
        this.cachedDocumentType = null;
        this.cachedPreserveSpaceMatcher = null;
    }

    public Object getProperty(Object object) {
        if (object == "NAMESPACE_PREFIX_MAP") {
            return this.cachedNamespacePrefixMap;
        }
        if (object == "DOCUMENT_TYPE") {
            return this.cachedDocumentType;
        }
        if (object == "PRESERVE_SPACE_ELEMENTS") {
            return this.cachedPreserveSpaceMatcher;
        }
        return super.getProperty(object);
    }

    public void addNamespacePrefixMapProperty(boolean bl, boolean bl2) {
        this.putProperty("NAMESPACE_PREFIX_MAP", new PreferredPrefix());
        this.addPreferredPrefixes(this.getRootElement(), bl, bl2);
    }

    public void addPreferredPrefixes(Element element, boolean bl, boolean bl2) {
        Object object = this.getProperty("NAMESPACE_PREFIX_MAP");
        if (object == null || !(object instanceof PreferredPrefix)) {
            return;
        }
        Document.loadPreferredPrefixes(element, bl, bl2, (PreferredPrefix)object);
    }

    public static final void loadPreferredPrefixes(Element element, boolean bl, final boolean bl2, final PreferredPrefix preferredPrefix) {
        final LinearHashtable linearHashtable = new LinearHashtable();
        final Namespace[] namespaceArray = new Namespace[1];
        Traversal.traverse(element, new Traversal.HandlerBase(){

            public Object enterElement(Element element) {
                PrefixEntry[] prefixEntryArray = (PrefixEntry[])element.getProperty("DECLARED_PREFIXES");
                if (prefixEntryArray != null) {
                    int n = 0;
                    while (n < prefixEntryArray.length) {
                        PrefixEntry prefixEntry = prefixEntryArray[n];
                        Namespace namespace = prefixEntry.namespace;
                        String string = prefixEntry.prefix;
                        if (preferredPrefix.add(namespace, string) == null) {
                            linearHashtable.put(namespace, namespace);
                        }
                        if (namespaceArray[0] == null && string.length() == 0 && namespace != Namespace.NONE && namespace != Namespace.XML) {
                            namespaceArray[0] = namespace;
                        }
                        ++n;
                    }
                    if (bl2) {
                        element.removeProperty("DECLARED_PREFIXES");
                    }
                }
                return null;
            }
        });
        if (linearHashtable.size() > 0) {
            Enumeration enumeration = linearHashtable.elements();
            while (enumeration.hasMoreElements()) {
                Namespace namespace = (Namespace)enumeration.nextElement();
                preferredPrefix.add(namespace, "ns");
            }
        }
        if (bl && namespaceArray[0] != null) {
            preferredPrefix.setDefaultNamespace(namespaceArray[0]);
        }
    }

    public PrefixEntry[] getPreferredPrefixes(boolean bl) {
        Namespace namespace;
        Object object = this.getProperty("NAMESPACE_PREFIX_MAP");
        if (!(object instanceof PreferredPrefix)) {
            return null;
        }
        PreferredPrefix preferredPrefix = (PreferredPrefix)object;
        PrefixEntry[] prefixEntryArray = preferredPrefix.getAll();
        if (prefixEntryArray.length == 0) {
            return null;
        }
        if (bl && (namespace = preferredPrefix.getDefaultNamespace()) != null) {
            PrefixEntry[] prefixEntryArray2 = new PrefixEntry[prefixEntryArray.length + 1];
            System.arraycopy(prefixEntryArray, 0, prefixEntryArray2, 0, prefixEntryArray.length);
            prefixEntryArray2[prefixEntryArray.length] = new PrefixEntry("", namespace);
            prefixEntryArray = prefixEntryArray2;
        }
        return prefixEntryArray;
    }

    public void removeProperties(int n) {
        if ((n & 1) != 0) {
            this.removeProperty("LOCATION_INFO");
        }
        if ((n & 0x10) != 0) {
            this.removeProperty("NAMESPACE_PREFIX_MAP");
        }
        if ((n & 0x20) != 0) {
            this.removeProperty("DTD");
        }
        if ((n & 0x40) != 0) {
            this.removeProperty("DOCUMENT_TYPE");
        }
        if ((n & 0x80) != 0) {
            this.removeProperty("MARK_MANAGER");
        }
        if ((n & 0x100) != 0) {
            this.removeProperty("UNDO_MANAGER");
        }
        if ((n & 0x200) != 0) {
            this.removeProperty("STYLE_SHEET_INFO");
        }
        if ((n & 0x400) != 0) {
            this.removeProperty("ELEMENT_TEMPLATES");
        }
        if ((n & 0x800) != 0) {
            this.removeProperty("COMMAND_HISTORY");
        }
        if ((n & 0x1000) != 0) {
            this.removeProperty("DOCUMENT_RESOURCES");
        }
        if ((n & 8) != 0) {
            this.removeProperty("INCLUSION_INFO");
        }
        if ((n & 0x4000) != 0) {
            this.removeProperty("CHAR_ENTITIES");
        }
        if ((n & 0x8000) != 0) {
            this.removeProperty("XXE_PROCESSING_INSTRUCTIONS");
        }
        if ((n & 0x10000) != 0) {
            this.removeProperty("PRESERVE_SPACE_ELEMENTS");
        }
        if ((n & 0x20000) != 0) {
            this.removeProperty("DOCUMENT_HOOKS");
        }
        if ((n & 0xFFFF2007 | 0x10000 | 0x20000) != 0) {
            this.getRootElement().removeProperties(n);
        }
    }

    public Namespace prefixToNamespace(String string) {
        NamespacePrefixMap namespacePrefixMap = (NamespacePrefixMap)this.getProperty("NAMESPACE_PREFIX_MAP");
        if (namespacePrefixMap == null) {
            namespacePrefixMap = PreferredPrefix.INSTANCE;
        }
        return namespacePrefixMap.prefixToNamespace(string);
    }

    public String[] namespaceToPrefixes(Namespace namespace) {
        NamespacePrefixMap namespacePrefixMap = (NamespacePrefixMap)this.getProperty("NAMESPACE_PREFIX_MAP");
        if (namespacePrefixMap == null) {
            namespacePrefixMap = PreferredPrefix.INSTANCE;
        }
        return namespacePrefixMap.namespaceToPrefixes(namespace);
    }

    public NamespacePrefixMap getNamespacePrefixMap() {
        return this;
    }
}

