/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.CharEntities;
import com.xmlmind.xmledit.doc.CharRange;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentTypeDeclaration;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ElementMatcher;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.Msg;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class DocumentWriter {
    public static final String[] KNOWN_ENCODINGS = new String[]{"ISO-8859-1", "ISO-8859-13", "ISO-8859-15", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-7", "ISO-8859-9", "KOI8-R", "MacRoman", "US-ASCII", "UTF-16", "UTF-8", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1257"};
    private static final byte SINGLE_BYTE = 1;
    private static final byte ASCII_SUPERSET = 2;
    private static final byte[] ENCODING_FLAGS = new byte[]{3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 3, 3, 3, 3, 3};
    public static final int PRESERVE_ENTITY_REFERENCES = 1;
    public static final int PRESERVE_XINCLUDES = 2;
    public static final int PRESERVE_INCLUSIONS = 3;
    protected String xmlEncoding = "UTF-8";
    protected CharSet charSet = new UnicodeCharSet();
    protected boolean saveCharsAsEntityRefs = false;
    protected CharRange[] charsSavedAsEntityRefs = null;
    protected PrefixEntry[] preferredPrefixes = null;
    protected boolean preserveXIncludes = false;
    protected boolean preserveEntityRefs = false;
    protected ElementMatcher cdataSections = null;
    private HashMap ignoredPIs = null;
    private Namespace defaultNS = Namespace.NONE;
    private HashMap namespacePrefixes = new HashMap();
    private HashMap prefixesInUse = new HashMap();
    private Namespace[] emptyPrefixNSStack = new Namespace[10];
    private int emptyPrefixNSStackSize = 0;
    private NamespaceEntry[] inScopeStack = new NamespaceEntry[10];
    private int inScopeStackSize = 0;
    private HashMap inScopeSet = new HashMap();
    private NamespaceEntry probe = new NamespaceEntry(null, null);
    private CharEntities charEnts = null;
    private boolean hasCharEnts = false;
    private HashMap entityNames = null;
    protected Writer out = null;
    private static final AttributeComparator attributeComparator = new AttributeComparator();

    public static final boolean isKnownEncoding(String string) {
        int n = 0;
        while (n < KNOWN_ENCODINGS.length) {
            if (KNOWN_ENCODINGS[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setEncoding(String string) {
        try {
            this.xmlEncoding = Charset.forName(string).name();
        }
        catch (Exception exception) {
            this.xmlEncoding = string;
        }
        this.charSet = null;
        if (this.xmlEncoding.toLowerCase().startsWith("utf")) {
            this.charSet = new UnicodeCharSet();
        } else if ("iso-8859-1".equalsIgnoreCase(this.xmlEncoding)) {
            this.charSet = new Latin1CharSet();
        } else if ("us-ascii".equalsIgnoreCase(this.xmlEncoding)) {
            this.charSet = new ASCIICharSet();
        } else {
            int n = -1;
            int n2 = 0;
            while (n2 < KNOWN_ENCODINGS.length) {
                if (KNOWN_ENCODINGS[n2].equalsIgnoreCase(this.xmlEncoding)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            try {
                if (n < 0) {
                    this.charSet = new CharSetImpl(this.xmlEncoding);
                } else if ((ENCODING_FLAGS[n] & 1) != 0) {
                    this.charSet = (ENCODING_FLAGS[n] & 2) != 0 ? new ASCIISuperset(this.xmlEncoding) : new SingleByteCharSet(this.xmlEncoding);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.charSet == null) {
            this.charSet = new UnicodeCharSet();
        }
    }

    public String getEncoding() {
        return this.xmlEncoding;
    }

    public void setPreferredPrefixes(PrefixEntry[] prefixEntryArray) {
        this.defaultNS = null;
        if (prefixEntryArray != null) {
            LinearHashtable linearHashtable = new LinearHashtable();
            int n = 0;
            while (n < prefixEntryArray.length) {
                int n2;
                PrefixEntry prefixEntry = prefixEntryArray[n];
                if (prefixEntry.namespace != Namespace.NONE && prefixEntry.namespace != Namespace.XML && ((n2 = prefixEntry.prefix.length()) <= 0 || XMLUtil.isNCName(prefixEntry.prefix) && !prefixEntry.prefix.regionMatches(true, 0, "xml", 0, 3))) {
                    if (n2 == 0) {
                        this.defaultNS = prefixEntry.namespace;
                    } else {
                        linearHashtable.put(prefixEntry, prefixEntry);
                    }
                }
                ++n;
            }
            prefixEntryArray = new PrefixEntry[linearHashtable.size()];
            linearHashtable.copyElementsInto(prefixEntryArray);
            if (prefixEntryArray.length > 1) {
                Arrays.sort(prefixEntryArray);
            }
        }
        if (this.defaultNS == null) {
            this.defaultNS = Namespace.NONE;
        }
        this.preferredPrefixes = prefixEntryArray;
    }

    public PrefixEntry[] getPreferredPrefixes() {
        return this.preferredPrefixes;
    }

    public void setPreserveInclusions(int n) {
        this.preserveEntityRefs = (n & 1) != 0;
        this.preserveXIncludes = (n & 2) != 0;
    }

    public int getPreserveInclusions() {
        int n = 0;
        if (this.preserveEntityRefs) {
            n |= 1;
        }
        if (this.preserveXIncludes) {
            n |= 2;
        }
        return n;
    }

    public void setCdataSectionElements(XPath[] xPathArray) {
        this.cdataSections = xPathArray != null && xPathArray.length > 0 ? new ElementMatcher(xPathArray) : null;
    }

    public XPath[] getCdataSectionElements() {
        return this.cdataSections == null ? null : this.cdataSections.getXPaths();
    }

    public void setSaveCharsAsEntityRefs(boolean bl) {
        this.saveCharsAsEntityRefs = bl;
    }

    public boolean getSaveCharsAsEntityRefs() {
        return this.saveCharsAsEntityRefs;
    }

    public void setCharsSavedAsEntityRefs(CharRange[] charRangeArray) {
        if (charRangeArray != null) {
            if (charRangeArray.length == 0) {
                charRangeArray = null;
            } else if (charRangeArray.length > 1) {
                Arrays.sort(charRangeArray);
            }
        }
        this.charsSavedAsEntityRefs = charRangeArray;
    }

    public CharRange[] getCharsSavedAsEntityRefs() {
        return this.charsSavedAsEntityRefs;
    }

    public void setIgnoredProcessingInstructions(String[] stringArray) {
        if (stringArray != null && stringArray.length == 0) {
            stringArray = null;
        }
        if (stringArray == null) {
            this.ignoredPIs = null;
        } else {
            this.ignoredPIs = new HashMap();
            int n = 0;
            while (n < stringArray.length) {
                this.ignoredPIs.put(stringArray[n], stringArray[n]);
                ++n;
            }
        }
    }

    public String[] getIgnoredProcessingInstructions() {
        if (this.ignoredPIs == null) {
            return null;
        }
        String[] stringArray = new String[this.ignoredPIs.size()];
        this.ignoredPIs.values().toArray(stringArray);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document document, File file) throws IOException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.writeDocument(document, fileOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public void writeDocument(Document document, OutputStream outputStream) throws IOException, UnsupportedEncodingException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.xmlEncoding));
        this.writeXMLDeclaration(this.xmlEncoding, null, bufferedWriter);
        bufferedWriter.write(10);
        this.writeDocument(document, bufferedWriter);
        bufferedWriter.flush();
    }

    public void writeXMLDeclaration(String string, String string2, Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\"");
        if (string != null) {
            writer.write(" encoding=\"");
            writer.write(string);
            writer.write(34);
        }
        if (string2 != null) {
            writer.write(" standalone=\"");
            writer.write(string2);
            writer.write(34);
        }
        writer.write("?>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocument(Document document, Writer writer) throws IOException {
        this.init(document, writer);
        try {
            this.writeDocumentChildren(document);
            Object var4_3 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    private void init(Document document, Writer writer) {
        if (this.preserveEntityRefs) {
            this.entityNames = new HashMap();
        }
        if (this.saveCharsAsEntityRefs) {
            this.charEnts = (CharEntities)document.getProperty("CHAR_ENTITIES");
            this.hasCharEnts = this.charEnts != null;
        } else {
            this.hasCharEnts = false;
        }
        NamespaceEntry namespaceEntry = new NamespaceEntry(Namespace.XML, "xml");
        this.inScopeSet.put(namespaceEntry, namespaceEntry);
        this.out = writer;
    }

    private void cleanUp() {
        this.out = null;
        this.namespacePrefixes.clear();
        this.prefixesInUse.clear();
        this.emptyPrefixNSStackSize = 0;
        if (this.emptyPrefixNSStack.length > 10) {
            this.emptyPrefixNSStack = new Namespace[10];
        }
        this.inScopeStackSize = 0;
        if (this.inScopeStack.length > 10) {
            this.inScopeStack = new NamespaceEntry[10];
        }
        this.inScopeSet.clear();
        this.charEnts = null;
        this.hasCharEnts = false;
        this.entityNames = null;
    }

    private boolean addEntityName(InclusionInfo inclusionInfo) {
        if (inclusionInfo.isDTDModule()) {
            return false;
        }
        String string = DocumentWriter.entityKey(inclusionInfo);
        String string2 = (String)this.entityNames.get(string);
        if (string2 != null) {
            return false;
        }
        this.entityNames.put(string, inclusionInfo.getEntityName());
        return true;
    }

    private static final String entityKey(InclusionInfo inclusionInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = inclusionInfo.getEntityPublicId();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append('\n');
        string = inclusionInfo.getEntitySystemId();
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected String getEntityName(InclusionInfo inclusionInfo) {
        if (inclusionInfo.isDTDModule()) {
            return inclusionInfo.getEntityName();
        }
        return (String)this.entityNames.get(DocumentWriter.entityKey(inclusionInfo));
    }

    public void writeDocumentElement(Document document, Writer writer) throws IOException {
        this.writeDocumentElement(document.getRootElement(), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDocumentElement(Element element, Writer writer) throws IOException {
        this.init(element.getDocument(), writer);
        try {
            this.writeElement(element);
            Object var4_3 = null;
            this.cleanUp();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    protected void writeDocumentChildren(Document document) throws IOException {
        Object object;
        Comparable comparable;
        DocumentTypeDeclaration documentTypeDeclaration = document.getDocumentTypeDeclaration();
        String string = document.getRootElement().getName().getLocalPart();
        if (this.preserveEntityRefs) {
            comparable = new StringBuffer();
            Traversal.traverse(document.getRootElement(), new Traversal.HandlerBase((StringBuffer)comparable){
                private final /* synthetic */ StringBuffer val$internalSubset2;
                {
                    this.val$internalSubset2 = stringBuffer;
                }

                public Object enterElement(Element element) {
                    InclusionInfo inclusionInfo = (InclusionInfo)element.getProperty("INCLUSION_INFO");
                    if (inclusionInfo != null) {
                        if (inclusionInfo.getEntityName() != null && DocumentWriter.this.addEntityName(inclusionInfo)) {
                            inclusionInfo.toEntityDeclaration(this.val$internalSubset2);
                            this.val$internalSubset2.append('\n');
                        }
                        return Traversal.LEAVE_ELEMENT;
                    }
                    return null;
                }
            });
            if (((StringBuffer)comparable).length() > 0) {
                if (documentTypeDeclaration == null) {
                    documentTypeDeclaration = new DocumentTypeDeclaration(null, null, ((StringBuffer)comparable).toString());
                } else {
                    object = documentTypeDeclaration.getInternalSubset();
                    if (object != null) {
                        ((StringBuffer)comparable).insert(0, '\n');
                        ((StringBuffer)comparable).insert(0, (String)object);
                    }
                    documentTypeDeclaration = new DocumentTypeDeclaration(documentTypeDeclaration.getPublicId(), documentTypeDeclaration.getSystemId(), ((StringBuffer)comparable).toString());
                }
            }
        }
        comparable = document.getFirstChild();
        object = comparable;
        while (object != null) {
            if (object != comparable) {
                this.out.write(10);
            }
            switch (((Node)object).getNodeType()) {
                case 3: {
                    this.writeDocumentTypeDeclaration(documentTypeDeclaration, string);
                    documentTypeDeclaration = null;
                    break;
                }
                case 1: {
                    this.writeComment((Comment)object);
                    break;
                }
                case 2: {
                    this.writeProcessingInstruction((ProcessingInstruction)object);
                    break;
                }
                case 4: {
                    if (documentTypeDeclaration != null) {
                        this.writeDocumentTypeDeclaration(documentTypeDeclaration, string);
                        this.out.write(10);
                        documentTypeDeclaration = null;
                    }
                    this.writeElement((Element)object);
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unexpected node type: " + ((Node)object).getNodeType());
                }
            }
            object = ((Node)object).getNextSibling();
        }
    }

    protected void writeDocumentTypeDeclaration(DocumentTypeDeclaration documentTypeDeclaration, String string) throws IOException {
        String string2 = documentTypeDeclaration.getSystemId();
        String string3 = documentTypeDeclaration.getInternalSubset();
        if (string3 != null && (string3 = string3.trim()).length() == 0) {
            string3 = null;
        }
        if (string2 == null && string3 == null) {
            return;
        }
        this.out.write("<!DOCTYPE ");
        this.out.write(string);
        if (string2 != null) {
            String string4 = documentTypeDeclaration.getPublicId();
            if (string4 == null) {
                this.out.write(" SYSTEM ");
            } else {
                this.out.write(" PUBLIC \"");
                this.out.write(string4);
                this.out.write("\"\n");
            }
            int n = string2.indexOf(34) < 0 ? 34 : 39;
            this.out.write(n);
            this.out.write(string2);
            this.out.write(n);
        }
        if (string3 != null) {
            this.out.write(" [\n");
            this.out.write(string3);
            this.out.write("\n]");
        }
        this.out.write(">");
    }

    protected void writeComment(Comment comment) throws IOException {
        DocumentWriter.checkComment(comment);
        this.out.write("<!--");
        this.out.write(comment.getText());
        this.out.write("-->");
    }

    protected static final void checkComment(Comment comment) throws IOException {
        String string = comment.getText();
        if (string.indexOf("--") >= 0 || string.endsWith("-")) {
            throw new IOException(Msg.msg("badCommentChars", DocumentWriter.shorten(string)));
        }
    }

    private static final String shorten(String string) {
        int n = string.length();
        String string2 = n <= 70 ? string : string.substring(0, 33) + " ... " + string.substring(n - 32);
        if (string2.indexOf(13) >= 0) {
            string2 = string2.replace('\r', ' ');
        }
        if (string2.indexOf(10) >= 0) {
            string2 = string2.replace('\n', ' ');
        }
        return string2;
    }

    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        if (this.ignoreProcessingInstruction(processingInstruction)) {
            return;
        }
        DocumentWriter.checkProcessingInstruction(processingInstruction);
        this.out.write("<?");
        this.out.write(processingInstruction.getTarget());
        this.out.write(32);
        this.out.write(processingInstruction.getText());
        this.out.write("?>");
    }

    protected final boolean ignoreProcessingInstruction(ProcessingInstruction processingInstruction) {
        return this.ignoredPIs != null && this.ignoredPIs.containsKey(processingInstruction.getTarget());
    }

    protected static final void checkProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        String string = processingInstruction.getTarget();
        if (!XMLUtil.isName(string)) {
            throw new IOException(Msg.msg("badPITarget", string));
        }
        String string2 = processingInstruction.getText();
        if (string2.indexOf("?>") >= 0) {
            throw new IOException(Msg.msg("badPIChars", DocumentWriter.shorten(string2)));
        }
    }

    protected void writeElement(Element element) throws IOException {
        InclusionInfo inclusionInfo;
        if ((this.preserveEntityRefs || this.preserveXIncludes) && (inclusionInfo = (InclusionInfo)element.getProperty("INCLUSION_INFO")) != null) {
            if (inclusionInfo.getEntityName() != null) {
                if (this.preserveEntityRefs) {
                    this.out.write(38);
                    this.out.write(this.getEntityName(inclusionInfo));
                    this.out.write(59);
                    return;
                }
            } else if (this.preserveXIncludes) {
                element = inclusionInfo.getXIncludeElement();
            }
        }
        this.doWriteElement(element);
    }

    protected void doWriteElement(Element element) throws IOException {
        XNode xNode;
        this.pushFrame();
        if (this.inScopeStackSize == 1 && this.preferredPrefixes != null) {
            this.pushPreferredPrefixes();
            this.setEmptyPrefixNS(this.defaultNS);
        }
        Name name = element.getName();
        String string = this.toQName(name, false);
        this.writeElementStartTag(element, string);
        switch (element.getAttributeCount()) {
            case 0: {
                break;
            }
            case 1: {
                Object object = (Attribute)element.getAttributes().nextElement();
                this.writeElementAttribute(element, this.toQName(object.name, true), object.name, object.value);
                break;
            }
            default: {
                Object object = element.getAllAttributes();
                Arrays.sort(object, attributeComparator);
                int n = 0;
                while (n < ((Attribute[])object).length) {
                    xNode = object[n];
                    this.writeElementAttribute(element, this.toQName(xNode.name, true), xNode.name, xNode.value);
                    ++n;
                }
                break block0;
            }
        }
        this.writeTopFrame(element);
        boolean bl = true;
        if (this.cdataSections != null && this.cdataSections.match(element)) {
            String string2 = null;
            if (element.getChildCount() == 1 && (xNode = element.getFirstChild()) instanceof Text) {
                string2 = ((Text)xNode).getText();
            }
            if (string2 != null && string2.length() > 0 && string2.indexOf("]]>") < 0) {
                bl = false;
                this.writeCdataSection(string2);
            }
        }
        if (bl) {
            this.writeElementChildren(element);
        }
        this.writeElementEndTag(element, string);
        this.popFrame();
    }

    protected void writeElementStartTag(Element element, String string) throws IOException {
        this.out.write(60);
        this.out.write(string);
    }

    protected void writeElementAttribute(Element element, String string, Name name, String string2) throws IOException {
        this.out.write(10);
        this.out.write(string);
        this.out.write("=\"");
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        this.escapeXML(true, cArray, 0, cArray.length, stringBuffer);
        this.out.write(stringBuffer.toString());
        this.out.write(34);
    }

    protected void writeElementChildren(Element element) throws IOException {
        this.out.write("\n>");
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    this.writeComment((Comment)node);
                    break;
                }
                case 2: {
                    this.writeProcessingInstruction((ProcessingInstruction)node);
                    break;
                }
                case 0: {
                    this.writeText((Text)node);
                    break;
                }
                case 4: {
                    this.writeElement((Element)node);
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unexpected node type: " + node.getNodeType());
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void writeCdataSection(String string) throws IOException {
        this.out.write("\n><![CDATA[");
        this.out.write(string);
        this.out.write("]]>");
    }

    protected void writeElementEndTag(Element element, String string) throws IOException {
        this.out.write("</");
        this.out.write(string);
        this.out.write("\n>");
    }

    protected void writeText(Text text) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.escapeXML(false, text.getTextChars(), 0, text.getTextLength(), stringBuffer);
        this.out.write(stringBuffer.toString());
    }

    private void pushFrame() {
        this.dupEmptyPrefixNS();
        this.pushNamespace(null);
    }

    private void dupEmptyPrefixNS() {
        Object object;
        if (this.emptyPrefixNSStackSize >= this.emptyPrefixNSStack.length) {
            object = new Namespace[Math.max(10, 2 * this.emptyPrefixNSStack.length)];
            System.arraycopy(this.emptyPrefixNSStack, 0, object, 0, this.emptyPrefixNSStack.length);
            this.emptyPrefixNSStack = object;
        }
        object = this.emptyPrefixNSStackSize > 0 ? this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1] : Namespace.NONE;
        this.emptyPrefixNSStack[this.emptyPrefixNSStackSize++] = object;
    }

    private void pushNamespace(NamespaceEntry namespaceEntry) {
        if (this.inScopeStackSize >= this.inScopeStack.length) {
            NamespaceEntry[] namespaceEntryArray = new NamespaceEntry[Math.max(10, 2 * this.inScopeStack.length)];
            System.arraycopy(this.inScopeStack, 0, namespaceEntryArray, 0, this.inScopeStack.length);
            this.inScopeStack = namespaceEntryArray;
        }
        this.inScopeStack[this.inScopeStackSize++] = namespaceEntry;
        if (namespaceEntry != null) {
            this.inScopeSet.put(namespaceEntry, namespaceEntry);
        }
    }

    private void pushPreferredPrefixes() {
        int n = 0;
        while (n < this.preferredPrefixes.length) {
            PrefixEntry prefixEntry = this.preferredPrefixes[n];
            this.prefixesInUse.put(prefixEntry.prefix, prefixEntry.namespace);
            NamespaceEntry namespaceEntry = new NamespaceEntry(prefixEntry.namespace, prefixEntry.prefix);
            this.namespacePrefixes.put(namespaceEntry, namespaceEntry);
            this.pushNamespace(namespaceEntry);
            ++n;
        }
    }

    private String toQName(Name name, boolean bl) throws IOException {
        Namespace namespace = name.getNamespace();
        String string = name.getLocalPart();
        if (bl) {
            if (namespace == Namespace.NONE) {
                return string;
            }
            this.probe.namespace = namespace;
            NamespaceEntry namespaceEntry = (NamespaceEntry)this.inScopeSet.get(this.probe);
            if (namespaceEntry == null) {
                namespaceEntry = this.declarePrefix(namespace);
                this.pushNamespace(namespaceEntry);
            }
            return DocumentWriter.qName(namespaceEntry.prefix, string);
        }
        if (namespace == Namespace.NONE) {
            this.setEmptyPrefixNS(Namespace.NONE);
            return string;
        }
        if (namespace == this.defaultNS) {
            this.setEmptyPrefixNS(this.defaultNS);
            return string;
        }
        this.probe.namespace = namespace;
        NamespaceEntry namespaceEntry = (NamespaceEntry)this.inScopeSet.get(this.probe);
        if (namespaceEntry == null) {
            namespaceEntry = this.declarePrefix(namespace);
            this.pushNamespace(namespaceEntry);
        }
        return DocumentWriter.qName(namespaceEntry.prefix, string);
    }

    private NamespaceEntry declarePrefix(Namespace namespace) {
        this.probe.namespace = namespace;
        NamespaceEntry namespaceEntry = (NamespaceEntry)this.namespacePrefixes.get(this.probe);
        if (namespaceEntry == null) {
            String string = "ns";
            int n = 2;
            if (this.prefixesInUse.containsKey(string)) {
                while (this.prefixesInUse.containsKey(string = "ns" + n++)) {
                }
            }
            this.prefixesInUse.put(string, namespace);
            namespaceEntry = new NamespaceEntry(namespace, string);
            this.namespacePrefixes.put(namespaceEntry, namespaceEntry);
        }
        return namespaceEntry;
    }

    private static final String qName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private void setEmptyPrefixNS(Namespace namespace) {
        this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1] = namespace;
    }

    private Namespace getEmptyPrefixNS() {
        return this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1];
    }

    private void writeTopFrame(Element element) throws IOException {
        NamespaceEntry namespaceEntry;
        Namespace namespace = this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 1];
        Namespace namespace2 = this.emptyPrefixNSStackSize >= 2 ? this.emptyPrefixNSStack[this.emptyPrefixNSStackSize - 2] : Namespace.NONE;
        if (namespace != namespace2) {
            this.writeElementAttribute(element, "xmlns", null, namespace.getURI());
        }
        int n = this.inScopeStackSize - 1;
        while ((namespaceEntry = this.inScopeStack[n]) != null) {
            this.writeElementAttribute(element, "xmlns:" + namespaceEntry.prefix, null, namespaceEntry.namespace.getURI());
            --n;
        }
    }

    private void popFrame() {
        NamespaceEntry namespaceEntry;
        --this.emptyPrefixNSStackSize;
        int n = this.inScopeStackSize - 1;
        while ((namespaceEntry = this.inScopeStack[n]) != null) {
            this.inScopeSet.remove(namespaceEntry);
            --n;
        }
        this.inScopeStackSize = n;
    }

    protected final void escapeXML(boolean bl, char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            switch (c) {
                case '\"': {
                    if (bl) {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\u00a0': {
                    String string;
                    if (this.hasCharEnts && (string = this.charEnts.getName(c)) != null) {
                        stringBuffer.append('&');
                        stringBuffer.append(string);
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append("&#160;");
                    break;
                }
                default: {
                    String string;
                    if (this.charSet.contains(c)) {
                        if (this.hasCharEnts && this.charsSavedAsEntityRefs != null && CharRange.contains(this.charsSavedAsEntityRefs, c) && (string = this.charEnts.getName(c)) != null) {
                            stringBuffer.append('&');
                            stringBuffer.append(string);
                            stringBuffer.append(';');
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    if (this.hasCharEnts && (string = this.charEnts.getName(c)) != null) {
                        stringBuffer.append('&');
                        stringBuffer.append(string);
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                }
            }
            ++n4;
        }
    }

    private static final class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Attribute)object).name.compareTo(((Attribute)object2).name);
        }
    }

    private static final class NamespaceEntry {
        public Namespace namespace;
        public String prefix;

        public NamespaceEntry(Namespace namespace, String string) {
            this.namespace = namespace;
            this.prefix = string;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof NamespaceEntry)) {
                return false;
            }
            return this.namespace == ((NamespaceEntry)object).namespace;
        }

        public int hashCode() {
            return System.identityHashCode(this.namespace);
        }
    }

    protected static final class CharSetImpl
    implements CharSet {
        private CharsetEncoder encoder;

        public CharSetImpl(String string) throws IllegalCharsetNameException, UnsupportedCharsetException, UnsupportedOperationException {
            Charset charset = Charset.forName(string);
            this.encoder = charset.newEncoder();
        }

        public boolean contains(char c) {
            return this.encoder.canEncode(c);
        }
    }

    protected static final class ASCIISuperset
    extends SingleByteCharSet {
        public ASCIISuperset(String string) throws UnsupportedEncodingException {
            super(string);
        }

        public boolean contains(char c) {
            return c <= '\u007f' || Arrays.binarySearch(this.chars, c) >= 0;
        }
    }

    protected static class SingleByteCharSet
    implements CharSet {
        protected char[] chars;

        public SingleByteCharSet(String string) throws UnsupportedEncodingException {
            byte[] byArray = new byte[256];
            int n = 0;
            while (n < 256) {
                byArray[n] = (byte)n;
                ++n;
            }
            String string2 = new String(byArray, string);
            this.chars = string2.toCharArray();
            Arrays.sort(this.chars);
        }

        public boolean contains(char c) {
            return Arrays.binarySearch(this.chars, c) >= 0;
        }
    }

    protected static final class Latin1CharSet
    implements CharSet {
        protected Latin1CharSet() {
        }

        public boolean contains(char c) {
            return c <= '\u00ff';
        }
    }

    protected static final class ASCIICharSet
    implements CharSet {
        protected ASCIICharSet() {
        }

        public boolean contains(char c) {
            return c <= '\u007f';
        }
    }

    protected static final class UnicodeCharSet
    implements CharSet {
        protected UnicodeCharSet() {
        }

        public boolean contains(char c) {
            return true;
        }
    }

    protected static interface CharSet {
        public boolean contains(char var1);
    }
}

