/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Path;
import com.xmlmind.xmledit.doc.Step;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.IdentityHashMap;

public final class ElementMatcher {
    private XPath[] xpaths;
    private IdentityHashMap entries;

    public ElementMatcher(XPath[] xPathArray) {
        this.xpaths = xPathArray;
        this.entries = new IdentityHashMap();
        int n = 0;
        while (n < xPathArray.length) {
            Path[] pathArray = xPathArray[n].getPaths();
            int n2 = 0;
            while (n2 < pathArray.length) {
                Path path = pathArray[n2];
                Step[] stepArray = path.getSteps();
                Step step = stepArray[stepArray.length - 1];
                if (step.getAxis() == 2 && step.getTest() == 2) {
                    Name name = step.getTestedName();
                    Entry entry = (Entry)this.entries.get(name);
                    if (entry == null) {
                        entry = new Entry(name);
                        this.entries.put(name, entry);
                    }
                    entry.addPath(path, stepArray.length == 1);
                }
                ++n2;
            }
            ++n;
        }
    }

    public XPath[] getXPaths() {
        return this.xpaths;
    }

    public boolean match(Element element) {
        boolean bl = false;
        Entry entry = (Entry)this.entries.get(element.getName());
        if (entry != null) {
            if (entry.basicTest) {
                bl = true;
            } else {
                int n = 0;
                while (n < entry.paths.length) {
                    if (entry.paths[n].match(element)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private static final class Entry {
        public Name elementName;
        public Path[] paths;
        public boolean basicTest;

        public Entry(Name name) {
            this.elementName = name;
            this.paths = new Path[0];
            this.basicTest = false;
        }

        public void addPath(Path path, boolean bl) {
            Path[] pathArray = new Path[this.paths.length + 1];
            System.arraycopy(this.paths, 0, pathArray, 0, this.paths.length);
            pathArray[this.paths.length] = path;
            this.paths = pathArray;
            if (!this.basicTest && bl) {
                this.basicTest = true;
            }
        }
    }
}

