/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import java.net.URL;
import java.util.Enumeration;

public abstract class Node
implements XNode {
    public static final int TEXT = 0;
    public static final int COMMENT = 1;
    public static final int PROCESSING_INSTRUCTION = 2;
    public static final int DOCUMENT_TYPE_DECLARATION = 3;
    public static final int ELEMENT = 4;
    public static final int DOCUMENT = 5;
    private static final String[] nodeTypeNames = new String[]{"text", "comment", "processing-instruction", "document-type-declaration", "element", "document"};
    protected Tree parent;
    protected Node previous;
    protected Node next;
    protected Object[] listenerData;

    public static String getNodeTypeName(int n) {
        return n >= 0 && n <= 5 ? nodeTypeNames[n] : null;
    }

    protected Node() {
    }

    public abstract Node copy();

    public abstract int getNodeType();

    public boolean isEditable() {
        return this.parent == null ? true : this.parent.isEditable();
    }

    public Document getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public final Tree getParent() {
        return this.parent;
    }

    public final Node getPreviousSibling() {
        return this.previous;
    }

    public final Node getNextSibling() {
        return this.next;
    }

    public final void setDocumentListenerData(int n, Object object) {
        this.listenerData[n] = object;
    }

    public final Object getDocumentListenerData(int n) {
        return this.listenerData[n];
    }

    public final int documentListenerIndex(Object object) {
        int n = 0;
        while (n < this.listenerData.length) {
            if (this.listenerData[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void setPrevious(Node node) {
        this.previous = node;
    }

    void setNext(Node node) {
        this.next = node;
    }

    void setAttached(Tree tree, Node node, Node node2) {
        this.parent = tree;
        this.previous = node;
        this.next = node2;
        Document document = tree.getDocument();
        if (document != null) {
            this.setDocument(document, document.getDocumentListenerCount(true));
        }
    }

    void setDetached() {
        this.parent = null;
        this.previous = null;
        this.next = null;
        if (this.getDocument() != null) {
            this.setDocument(null, -1);
        }
    }

    void setDocument(Document document, int n) {
        if (document != null) {
            this.listenerData = n > 0 ? new Object[n] : null;
        }
    }

    boolean isDetached() {
        return this.parent == null && this.next == null && this.previous == null;
    }

    void listenerAdded(boolean bl) {
        if (this.listenerData == null) {
            this.listenerData = new Object[1];
        } else {
            Object[] objectArray = new Object[this.listenerData.length + 1];
            if (bl) {
                System.arraycopy(this.listenerData, 0, objectArray, 1, this.listenerData.length);
            } else {
                System.arraycopy(this.listenerData, 0, objectArray, 0, this.listenerData.length);
            }
            this.listenerData = objectArray;
        }
    }

    void listenerRemoved(int n) {
        if (this.listenerData.length == 1) {
            this.listenerData = null;
        } else {
            int n2;
            int n3;
            Object[] objectArray = new Object[this.listenerData.length - 1];
            if (n > 0) {
                System.arraycopy(this.listenerData, 0, objectArray, 0, n);
            }
            if ((n3 = this.listenerData.length - (n2 = n + 1)) > 0) {
                System.arraycopy(this.listenerData, n2, objectArray, n, n3);
            }
            this.listenerData = objectArray;
        }
    }

    public final Element getParentElement() {
        return this.parent instanceof Element ? (Element)this.parent : null;
    }

    public final Element getPreviousElement() {
        Node node = this.previous;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.previous;
        }
        return null;
    }

    public final Element getNextElement() {
        Node node = this.next;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public final boolean isAncestorOf(Node node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.parent;
        }
        return false;
    }

    public final boolean isDescendantOf(Node node) {
        Node node2 = this;
        while (node2 != null) {
            if (node2 == node) {
                return true;
            }
            node2 = node2.parent;
        }
        return false;
    }

    public final Node findCommonAncestor(Node node) {
        if (this.isAncestorOf(node)) {
            return this;
        }
        Node node2 = node;
        while (node2 != null) {
            if (node2.isAncestorOf(this)) {
                return node2;
            }
            node2 = node2.parent;
        }
        return null;
    }

    public final Node getFirstSibling() {
        Node node = this.previous;
        if (node != null) {
            while (node.previous != null) {
                node = node.previous;
            }
        }
        return node;
    }

    public final Node getLastSibling() {
        Node node = this.next;
        if (node != null) {
            while (node.next != null) {
                node = node.next;
            }
        }
        return node;
    }

    public boolean isSiblingOf(Node node) {
        return this.parent != null && this.parent == node.parent;
    }

    public String toString() {
        Tree tree;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getNodeType();
        switch (n) {
            case 5: {
                return "/";
            }
            case 4: {
                bl = false;
                tree = (Tree)this;
                break;
            }
            default: {
                stringBuffer.append('#');
                stringBuffer.append(Node.getNodeTypeName(n));
                bl = true;
                tree = this.parent;
                break;
            }
        }
        while (tree != null) {
            if (bl) {
                stringBuffer.insert(0, '/');
            } else {
                bl = true;
            }
            if (tree instanceof Element) {
                Element element = (Element)tree;
                stringBuffer.insert(0, element.getName().format(false, element));
            }
            tree = tree.parent;
        }
        return stringBuffer.toString();
    }

    public String toLabel() {
        int n = this.getNodeType();
        switch (n) {
            case 5: {
                return "/";
            }
            case 4: {
                Element element = (Element)this;
                return element.getName().format(false, element);
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('#');
        stringBuffer.append(Node.getNodeTypeName(n));
        if (this.parent != null) {
            if (this.parent instanceof Element) {
                Element element = (Element)this.parent;
                stringBuffer.insert(0, element.getName().format(false, element));
            } else {
                stringBuffer.insert(0, '/');
            }
        }
        return stringBuffer.toString();
    }

    public String toXPath() {
        int n;
        Object object;
        Tree tree;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getNodeType();
        switch (n2) {
            case 5: {
                return "/";
            }
            case 4: {
                bl = false;
                tree = (Tree)this;
                break;
            }
            default: {
                stringBuffer.append(Node.getNodeTypeName(n2));
                if (n2 == 2) {
                    object = ((ProcessingInstruction)this).getTarget();
                    char c = ((String)object).indexOf(34) < 0 ? (char)'\"' : '\'';
                    stringBuffer.append('(');
                    stringBuffer.append(c);
                    stringBuffer.append((String)object);
                    stringBuffer.append(c);
                    stringBuffer.append(')');
                } else {
                    stringBuffer.append("()");
                }
                n = this.getPositionInParent();
                if (n > 0) {
                    stringBuffer.append('[');
                    stringBuffer.append(n);
                    stringBuffer.append(']');
                }
                bl = true;
                tree = this.parent;
                break;
            }
        }
        while (tree != null) {
            if (bl) {
                stringBuffer.insert(0, '/');
            } else {
                bl = true;
            }
            if (tree instanceof Element) {
                n = tree.getPositionInParent();
                if (n > 0) {
                    stringBuffer.insert(0, ']');
                    stringBuffer.insert(0, n);
                    stringBuffer.insert(0, '[');
                }
                object = (Element)tree;
                stringBuffer.insert(0, ((Element)object).getName().format(true, (NamespaceToPrefixes)object));
            }
            tree = tree.parent;
        }
        return stringBuffer.toString();
    }

    public int getPositionInParent() {
        if (this.parent == null) {
            return 0;
        }
        int n = 1;
        int n2 = this.getNodeType();
        Name name = n2 == 4 ? ((Element)this).getName() : null;
        String string = n2 == 2 ? ((ProcessingInstruction)this).getTarget() : null;
        Node node = this.getPreviousSibling();
        while (node != null) {
            if (!(node.getNodeType() != n2 || name != null && ((Element)node).getName() != name || string != null && !((ProcessingInstruction)node).getTarget().equals(string))) {
                ++n;
            }
            node = node.getPreviousSibling();
        }
        return n;
    }

    public int type() {
        return this.getNodeType();
    }

    public XNode document() {
        return this.getDocument();
    }

    public XNode parent() {
        return this.parent;
    }

    public XNode following() {
        return this.next;
    }

    public XNode preceding() {
        return this.previous;
    }

    public Name name() {
        return null;
    }

    public String data() {
        return null;
    }

    public NamespacePrefixMap namespacePrefixMap() {
        return this.parent == null ? null : this.parent.namespacePrefixMap();
    }

    public XNode firstChild() {
        return null;
    }

    public XNode lastChild() {
        return null;
    }

    public String attributeValue(Name name) {
        return null;
    }

    public Enumeration attributes() {
        return null;
    }

    public URL location() {
        return this.parent == null ? null : this.parent.getLocation();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Node)) {
            return false;
        }
        return this == object;
    }

    public int compareTo(Object object) {
        return Node.compare(this, (XNode)object);
    }

    static final int compare(XNode xNode, XNode xNode2) {
        XNode xNode3;
        switch (xNode.type()) {
            case 5: {
                if (xNode2.type() == 5) {
                    return xNode == xNode2 ? 0 : Node.compareDocuments((Document)xNode, (Document)xNode2);
                }
                Document document = (Document)xNode2.document();
                return xNode == document ? -1 : Node.compareDocuments((Document)xNode, document);
            }
            case 6: {
                switch (xNode2.type()) {
                    case 5: {
                        Document document = (Document)xNode.document();
                        return document == xNode2 ? 1 : Node.compareDocuments(document, (Document)xNode2);
                    }
                    case 6: {
                        XNode xNode4 = xNode.parent();
                        XNode xNode5 = xNode2.parent();
                        if (xNode4 == xNode5) {
                            return xNode.name().compareTo(xNode2.name());
                        }
                        return Node.compare(xNode4, xNode5);
                    }
                }
                XNode xNode6 = xNode.parent();
                if (xNode6 == xNode2) {
                    return 1;
                }
                return Node.compare(xNode6, xNode2);
            }
        }
        switch (xNode2.type()) {
            case 5: {
                Document document = (Document)xNode.document();
                return document == xNode2 ? 1 : Node.compareDocuments(document, (Document)xNode2);
            }
            case 6: {
                XNode xNode7 = xNode2.parent();
                if (xNode == xNode7) {
                    return -1;
                }
                return Node.compare(xNode, xNode7);
            }
        }
        if (xNode == xNode2) {
            return 0;
        }
        XNode xNode8 = xNode2.parent();
        while (xNode8 != null) {
            if (xNode8 == xNode) {
                return -1;
            }
            xNode8 = xNode8.parent();
        }
        XNode xNode9 = null;
        xNode8 = xNode2;
        while (xNode8 != null) {
            boolean bl = false;
            xNode3 = xNode;
            XNode xNode10 = xNode.parent();
            while (xNode10 != null) {
                if (xNode10 == xNode8) {
                    bl = true;
                    break;
                }
                xNode3 = xNode10;
                xNode10 = xNode10.parent();
            }
            if (bl) {
                if (xNode9 == null) {
                    return 1;
                }
                XNode xNode11 = xNode9.following();
                while (xNode11 != null) {
                    if (xNode11 == xNode3) {
                        return 1;
                    }
                    xNode11 = xNode11.following();
                }
                return -1;
            }
            xNode9 = xNode8;
            xNode8 = xNode8.parent();
        }
        Document document = (Document)xNode.document();
        xNode3 = (Document)xNode2.document();
        if (document == null && xNode3 == null) {
            return System.identityHashCode(xNode) - System.identityHashCode(xNode2);
        }
        return Node.compareDocuments(document, (Document)xNode3);
    }

    private static final int compareDocuments(Document document, Document document2) {
        URL uRL;
        if (document == document2) {
            return 0;
        }
        URL uRL2 = document == null ? null : document.getLocation();
        URL uRL3 = uRL = document2 == null ? null : document2.getLocation();
        if (uRL2 == null && uRL == null) {
            return System.identityHashCode(document) - System.identityHashCode(document2);
        }
        String string = uRL2 == null ? "" : uRL2.toExternalForm();
        String string2 = uRL == null ? "" : uRL.toExternalForm();
        return string.compareTo(string2);
    }

    public XNode deepCopy() {
        return this.copy();
    }
}

