/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.xmlutil.Name;
import java.util.ArrayList;

public final class ProcessingInstruction
extends TextNode {
    private String target;
    private boolean readOnly;

    public ProcessingInstruction(String string) {
        this(string, "");
    }

    public ProcessingInstruction(String string, String string2) {
        super(string2);
        this.target = string;
    }

    public ProcessingInstruction(String string, char[] cArray, int n, int n2) {
        super(cArray, n, n2);
        this.target = string;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isEditable() {
        if (this.readOnly) {
            return false;
        }
        return super.isEditable();
    }

    public Node copy() {
        ProcessingInstruction processingInstruction = new ProcessingInstruction(this.target, this.chars, 0, this.chars.length);
        processingInstruction.readOnly = this.readOnly;
        return processingInstruction;
    }

    public int getNodeType() {
        return 2;
    }

    public void setTarget(String string) {
        if (string.equals(this.target)) {
            return;
        }
        String string2 = this.target;
        this.target = string;
        Document document = this.getDocument();
        if (document != null) {
            document.processingInstructionNotification(this, 30, string2);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String[] getPseudoAttributes() {
        return ProcessingInstruction.parsePseudoAttributes(this.getText());
    }

    public static String[] parsePseudoAttributes(String string) {
        String[] stringArray = ProcessingInstruction.splitPseudoAttributes(string);
        if (stringArray.length % 3 != 0) {
            return null;
        }
        String[] stringArray2 = new String[2 * (stringArray.length / 3)];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            String string3 = stringArray[n2 + 1];
            String string4 = stringArray[n2 + 2];
            if (!string3.equals("=")) {
                return null;
            }
            if (string4.length() < 2) {
                return null;
            }
            char c = string4.charAt(0);
            if (c != '\'' && c != '\"') {
                return null;
            }
            int n3 = string4.length() - 1;
            char c2 = string4.charAt(n3);
            if (c2 != c) {
                return null;
            }
            string4 = string4.substring(1, n3);
            stringArray2[n++] = string2;
            stringArray2[n++] = string4;
            n2 += 3;
        }
        return stringArray2;
    }

    private static String[] splitPseudoAttributes(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (c != '\u0000') {
                        stringBuffer.append(c2);
                        break;
                    }
                    if (stringBuffer.length() <= 0) break;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    break;
                }
                case '=': {
                    if (c != '\u0000') {
                        stringBuffer.append(c2);
                        break;
                    }
                    if (stringBuffer.length() > 0) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                    }
                    arrayList.add("=");
                    break;
                }
                case '\"': 
                case '\'': {
                    if (c == '\u0000') {
                        stringBuffer.append(c2);
                        c = c2;
                        break;
                    }
                    if (c == c2) {
                        stringBuffer.append(c2);
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        c = '\u0000';
                        break;
                    }
                    stringBuffer.append(c2);
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void setPseudoAttributes(String[] stringArray) {
        this.setText(ProcessingInstruction.formatPseudoAttributes(stringArray));
    }

    public static String formatPseudoAttributes(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            stringBuffer.append('=');
            char c = stringArray[n + 1].indexOf(34) < 0 ? (char)'\"' : '\'';
            stringBuffer.append(c);
            stringBuffer.append(stringArray[n + 1]);
            stringBuffer.append(c);
            n += 2;
        }
        return stringBuffer.toString();
    }

    public Name name() {
        return Name.get(this.target);
    }
}

