/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.Serializable;

public final class Step
implements Serializable {
    public static final int SELF = 0;
    public static final int DESCENDANT_OR_SELF = 1;
    public static final int CHILD = 2;
    public static final int ATTRIBUTE = 3;
    public static final int NODE = 0;
    public static final int ALL = 1;
    public static final int NAME = 2;
    public static final int NAMESPACE = 3;
    int axis;
    int test;
    Name name;
    Namespace namespace;

    Step() {
    }

    public static Step fromString(String string, PrefixToNamespace prefixToNamespace) {
        return Step.fromString(string, prefixToNamespace, false);
    }

    public static Step fromString(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        Step step = new Step();
        int n = string.length();
        int n2 = string.indexOf("::");
        if (n2 > 0 && n2 + 2 < n) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 2);
            if ("child".equals(string2)) {
                step.axis = 2;
            } else if ("attribute".equals(string2)) {
                step.axis = 3;
            } else if ("descendant-or-self".equals(string2)) {
                step.axis = 1;
            } else if ("self".equals(string2)) {
                step.axis = 0;
            } else {
                return null;
            }
            if ("*".equals(string3)) {
                step.test = 1;
            } else if ("node()".equals(string3)) {
                step.test = 0;
            } else if (!Step.parseName(string3, prefixToNamespace, bl, step)) {
                return null;
            }
        } else if (".".equals(string)) {
            step.axis = 0;
            step.test = 0;
        } else if ("*".equals(string)) {
            step.axis = 2;
            step.test = 1;
        } else if (string.indexOf(64) == 0 && n > 1) {
            step.axis = 3;
            if (!Step.parseName(string.substring(1), prefixToNamespace, bl, step)) {
                return null;
            }
        } else {
            step.axis = 2;
            if (!Step.parseName(string, prefixToNamespace, bl, step)) {
                return null;
            }
        }
        return step;
    }

    private static boolean parseName(String string, PrefixToNamespace prefixToNamespace, boolean bl, Step step) {
        if (string.endsWith(":*")) {
            String string2 = string.substring(0, string.length() - 2) + ":x";
            Name name = Name.parse(string2, true, prefixToNamespace);
            if (name == null) {
                return false;
            }
            step.test = 3;
            step.namespace = name.getNamespace();
        } else {
            step.test = 2;
            step.name = Name.parse(string, true, prefixToNamespace);
            if (step.name == null) {
                if (bl && XMLUtil.isName(string)) {
                    step.name = Name.get(string);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public int getAxis() {
        return this.axis;
    }

    public int getTest() {
        return this.test;
    }

    public Name getTestedName() {
        return this.name;
    }

    public Namespace getTestedNamespace() {
        return this.namespace;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Step)) {
            return false;
        }
        Step step = (Step)object;
        return this.axis == step.axis && this.test == step.test && this.name == step.name && this.namespace == step.namespace;
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, namespaceToPrefixes);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer, NamespaceToPrefixes namespaceToPrefixes) {
        switch (this.axis) {
            case 0: {
                stringBuffer.append("self");
                break;
            }
            case 1: {
                stringBuffer.append("descendant-or-self");
                break;
            }
            case 2: {
                stringBuffer.append("child");
                break;
            }
            case 3: {
                stringBuffer.append("attribute");
                break;
            }
            default: {
                stringBuffer.append("(unknown axis " + this.axis + ")");
            }
        }
        stringBuffer.append("::");
        switch (this.test) {
            case 0: {
                stringBuffer.append("node()");
                break;
            }
            case 1: {
                stringBuffer.append('*');
                break;
            }
            case 2: {
                stringBuffer.append(this.name.format(true, namespaceToPrefixes));
                break;
            }
            case 3: {
                String string;
                if (this.namespace == Namespace.XML) {
                    string = "xml";
                } else {
                    String[] stringArray = namespaceToPrefixes == null ? null : namespaceToPrefixes.namespaceToPrefixes(this.namespace);
                    string = null;
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            String string2 = stringArray[n];
                            if (string2.length() > 0) {
                                string = string2;
                                break;
                            }
                            ++n;
                        }
                    }
                    if (string == null) {
                        string = "{" + this.namespace + "}";
                    }
                }
                stringBuffer.append(string);
                stringBuffer.append(":*");
                break;
            }
            default: {
                stringBuffer.append("(unknown test " + this.test + ")");
            }
        }
    }
}

