/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextEdit;

public abstract class TextNode
extends Node
implements TextEdit {
    protected char[] chars;

    protected TextNode(String string) {
        this.chars = string.toCharArray();
    }

    protected TextNode(char[] cArray, int n, int n2) {
        this.chars = new char[n2];
        System.arraycopy(cArray, n, this.chars, 0, n2);
    }

    public final void setText(String string) {
        String string2 = new String(this.chars);
        this.chars = string.toCharArray();
        Document document = this.getDocument();
        if (document != null) {
            document.textNotification(this, 1, 0, string2, string);
        }
    }

    public final void insertText(int n, String string) {
        int n2 = this.chars.length;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("invalid offset");
        }
        int n3 = string.length();
        if (n3 == 0) {
            return;
        }
        char[] cArray = new char[n2 + n3];
        if (n > 0) {
            System.arraycopy(this.chars, 0, cArray, 0, n);
        }
        string.getChars(0, n3, cArray, n);
        if (n < n2) {
            System.arraycopy(this.chars, n, cArray, n + n3, n2 - n);
        }
        this.chars = cArray;
        Document document = this.getDocument();
        if (document != null) {
            document.textNotification(this, 0, n, null, string);
        }
    }

    public final void appendText(String string) {
        this.insertText(this.chars.length, string);
    }

    public final void replaceText(int n, int n2, String string) {
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException("negative offset");
        }
        int n4 = this.chars.length;
        if (n2 < 0 || n + n2 > n4) {
            throw new IllegalArgumentException("invalid count");
        }
        if (n2 == 0) {
            return;
        }
        String string2 = new String(this.chars, n, n2);
        int n5 = string.length();
        char[] cArray = new char[n4 - n2 + n5];
        if (n > 0) {
            System.arraycopy(this.chars, 0, cArray, 0, n);
        }
        if (n5 > 0) {
            string.getChars(0, n5, cArray, n);
        }
        if ((n3 = n + n2) < n4) {
            System.arraycopy(this.chars, n3, cArray, n + n5, n4 - n3);
        }
        this.chars = cArray;
        Document document = this.getDocument();
        if (document != null) {
            if (n5 > 0) {
                document.textNotification(this, 1, n, string2, string);
            } else {
                document.textNotification(this, 2, n, string2, null);
            }
        }
    }

    public final void deleteText(int n, int n2) {
        this.replaceText(n, n2, "");
    }

    public final String getText() {
        return new String(this.chars);
    }

    public final char[] getTextChars() {
        return this.chars;
    }

    public final char getTextChar(int n) {
        return this.chars[n];
    }

    public final int getTextLength() {
        return this.chars.length;
    }

    public final boolean isXMLSpace() {
        int n = 0;
        while (n < this.chars.length) {
            switch (this.chars[n]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public String data() {
        return this.getText();
    }
}

