/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.xmlutil.Name;

public class Traversal {
    public static final Object LEAVE_ELEMENT = new Object();
    public static final TextFinder textFinder = new TextFinder();
    public static final TextNodeFinder textNodeFinder = new TextNodeFinder();
    public static final NodeFinder nodeFinder = new NodeFinder();

    public static final Object traverse(Node node, Handler handler) {
        switch (node.getNodeType()) {
            case 0: {
                return handler.processText((Text)node);
            }
            case 2: {
                return handler.processPI((ProcessingInstruction)node);
            }
            case 1: {
                return handler.processComment((Comment)node);
            }
            case 4: {
                Element element = (Element)node;
                Object object = handler.enterElement(element);
                if (object != null) {
                    return object == LEAVE_ELEMENT ? null : object;
                }
                Node node2 = element.getFirstChild();
                while (node2 != null) {
                    object = Traversal.traverse(node2, handler);
                    if (object != null) {
                        return object;
                    }
                    node2 = node2.getNextSibling();
                }
                object = handler.leaveElement(element);
                if (object != null) {
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    public static final Object traverseBackwards(Node node, Handler handler) {
        switch (node.getNodeType()) {
            case 0: {
                return handler.processText((Text)node);
            }
            case 2: {
                return handler.processPI((ProcessingInstruction)node);
            }
            case 1: {
                return handler.processComment((Comment)node);
            }
            case 4: {
                Element element = (Element)node;
                Object object = handler.enterElement(element);
                if (object != null) {
                    return object == LEAVE_ELEMENT ? null : object;
                }
                Node node2 = element.getLastChild();
                while (node2 != null) {
                    object = Traversal.traverseBackwards(node2, handler);
                    if (object != null) {
                        return object;
                    }
                    node2 = node2.getPreviousSibling();
                }
                object = handler.leaveElement(element);
                if (object != null) {
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    public static final Object traverseFrom(Node node, Handler handler) {
        Object object = Traversal.traverse(node, handler);
        if (object != null) {
            return object;
        }
        return Traversal.traverseAfter(node, handler);
    }

    public static final Object traverseAfter(Node node, Handler handler) {
        Object object;
        Object object2 = node.getParentElement();
        if (object2 == null) {
            return null;
        }
        Node node2 = node.getNextSibling();
        while (node2 != null) {
            object = Traversal.traverse(node2, handler);
            if (object != null) {
                return object;
            }
            node2 = node2.getNextSibling();
        }
        while ((object = ((Node)object2).getParentElement()) != null) {
            Node node3 = ((Node)object2).getNextSibling();
            if (node3 != null) {
                return Traversal.traverseFrom(node3, handler);
            }
            object2 = object;
        }
        return null;
    }

    public static final Object traverseBackwardsFrom(Node node, Handler handler) {
        Object object = Traversal.traverseBackwards(node, handler);
        if (object != null) {
            return object;
        }
        return Traversal.traverseBefore(node, handler);
    }

    public static final Object traverseBefore(Node node, Handler handler) {
        Object object;
        Object object2 = node.getParentElement();
        if (object2 == null) {
            return null;
        }
        Node node2 = node.getPreviousSibling();
        while (node2 != null) {
            object = Traversal.traverseBackwards(node2, handler);
            if (object != null) {
                return object;
            }
            node2 = node2.getPreviousSibling();
        }
        while ((object = ((Node)object2).getParentElement()) != null) {
            Node node3 = ((Node)object2).getPreviousSibling();
            if (node3 != null) {
                return Traversal.traverseBackwardsFrom(node3, handler);
            }
            object2 = object;
        }
        return null;
    }

    public static class ElementFinder
    extends HandlerBase {
        public Name searchedName;

        public Object enterElement(Element element) {
            if (element.getName() == this.searchedName) {
                return element;
            }
            return null;
        }
    }

    public static class TextNodeGrabber
    extends TextGrabber {
        public Object processPI(ProcessingInstruction processingInstruction) {
            this.grabbed.append(processingInstruction.getText());
            return null;
        }

        public Object processComment(Comment comment) {
            this.grabbed.append(comment.getText());
            return null;
        }
    }

    public static class TextGrabber
    extends HandlerBase {
        public StringBuffer grabbed = new StringBuffer();

        public Object processText(Text text) {
            this.grabbed.append(text.getText());
            return null;
        }
    }

    public static class NodeMatcher
    extends TextNodeMatcher {
        public Object enterElement(Element element) {
            if (element == this.searchedNode) {
                return element;
            }
            return null;
        }
    }

    public static class TextNodeMatcher
    extends TextMatcher {
        public Object processPI(ProcessingInstruction processingInstruction) {
            if (processingInstruction == this.searchedNode) {
                return processingInstruction;
            }
            return null;
        }

        public Object processComment(Comment comment) {
            if (comment == this.searchedNode) {
                return comment;
            }
            return null;
        }
    }

    public static class TextMatcher
    extends HandlerBase {
        public Node searchedNode;

        public Object processText(Text text) {
            if (text == this.searchedNode) {
                return text;
            }
            return null;
        }
    }

    public static class NodeFinder
    extends TextNodeFinder {
        public Object enterElement(Element element) {
            return element;
        }
    }

    public static class TextNodeFinder
    extends TextFinder {
        public Object processPI(ProcessingInstruction processingInstruction) {
            return processingInstruction;
        }

        public Object processComment(Comment comment) {
            return comment;
        }
    }

    public static class TextFinder
    extends HandlerBase {
        public Object processText(Text text) {
            return text;
        }
    }

    public static class HandlerBase
    implements Handler {
        public Object processText(Text text) {
            return null;
        }

        public Object processPI(ProcessingInstruction processingInstruction) {
            return null;
        }

        public Object processComment(Comment comment) {
            return null;
        }

        public Object enterElement(Element element) {
            return null;
        }

        public Object leaveElement(Element element) {
            return null;
        }
    }

    public static interface Handler {
        public Object processText(Text var1);

        public Object processPI(ProcessingInstruction var1);

        public Object processComment(Comment var1);

        public Object enterElement(Element var1);

        public Object leaveElement(Element var1);
    }
}

