/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.doc;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.LocationInfo;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public abstract class Tree
extends Node {
    private static final Enumeration NO_PROPERTY_ENUMERATION = new PropertyEnumeration(new LinearHashtable());
    protected LinearHashtable properties;
    protected boolean readOnly;
    protected Node first;

    public final boolean isEditable() {
        Tree tree = this;
        while (tree != null) {
            if (tree.readOnly) {
                return false;
            }
            tree = tree.parent;
        }
        return true;
    }

    public final void unsetReadOnly() {
        this.readOnly = false;
        Node node = this.first;
        while (node != null) {
            if (node instanceof Tree) {
                ((Tree)node).unsetReadOnly();
            }
            node = node.getNextSibling();
        }
    }

    public final Tree findReadOnlyDescendant() {
        if (this.readOnly) {
            return this;
        }
        Node node = this.first;
        while (node != null) {
            Tree tree;
            if (node instanceof Tree && (tree = ((Tree)node).findReadOnlyDescendant()) != null) {
                return tree;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public final void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void appendChild(Node node) {
        this.insertChild(null, node);
    }

    public void insertChild(Node node, Node node2) {
        Node node3;
        if (!node2.isDetached()) {
            throw new IllegalArgumentException("added already attached");
        }
        if (node == null) {
            node3 = this.getLastChild();
        } else {
            if (node.getParent() != this) {
                throw new IllegalArgumentException("before not a child");
            }
            node3 = node.getPreviousSibling();
        }
        if (node3 != null) {
            node3.setNext(node2);
        }
        if (node != null) {
            node.setPrevious(node2);
        }
        node2.setAttached(this, node3, node);
        if (this.first == node) {
            this.first = node2;
        }
    }

    public final void removeChild(Node node) {
        this.replaceChild(node, null);
    }

    public void replaceChild(Node node, Node node2) {
        if (node.getParent() != this) {
            throw new IllegalArgumentException("removed not a child");
        }
        Node node3 = node.getPreviousSibling();
        Node node4 = node.getNextSibling();
        if (node2 == null) {
            node.setDetached();
            if (node3 != null) {
                node3.setNext(node4);
            }
            if (node4 != null) {
                node4.setPrevious(node3);
            }
            if (node == this.first) {
                this.first = node4;
            }
        } else {
            if (!node2.isDetached()) {
                throw new IllegalArgumentException("added already attached");
            }
            node.setDetached();
            if (node3 != null) {
                node3.setNext(node2);
            }
            if (node4 != null) {
                node4.setPrevious(node2);
            }
            node2.setAttached(this, node3, node4);
            if (node == this.first) {
                this.first = node2;
            }
        }
    }

    public final Node getFirstChild() {
        return this.first;
    }

    public final Node getLastChild() {
        Node node = null;
        Node node2 = this.first;
        while (node2 != null) {
            node = node2;
            node2 = node2.getNextSibling();
        }
        return node;
    }

    public final int getChildCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            ++n;
            node = node.getNextSibling();
        }
        return n;
    }

    public final boolean hasNoChildren() {
        return this.first == null;
    }

    public final Node getChild(int n) {
        int n2 = 0;
        Node node = this.first;
        while (node != null) {
            if (n2 == n) {
                return node;
            }
            ++n2;
            node = node.getNextSibling();
        }
        return null;
    }

    public final int indexOfChild(Node node) {
        int n = 0;
        Node node2 = this.first;
        while (node2 != null) {
            if (node2 == node) {
                return n;
            }
            ++n;
            node2 = node2.getNextSibling();
        }
        return -1;
    }

    public final Node[] getChildren() {
        Node[] nodeArray = new Node[this.getChildCount()];
        int n = 0;
        Node node = this.first;
        while (node != null) {
            nodeArray[n++] = node;
            node = node.getNextSibling();
        }
        return nodeArray;
    }

    public final void removeAllChildren() {
        Node node = this.first;
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
    }

    void setDocument(Document document, int n) {
        super.setDocument(document, n);
        Node node = this.first;
        while (node != null) {
            node.setDocument(document, n);
            node = node.getNextSibling();
        }
    }

    public Object putProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new LinearHashtable();
        }
        return this.properties.put(object, object2);
    }

    public Object removeProperty(Object object) {
        if (this.properties == null) {
            return null;
        }
        Object object2 = this.properties.remove(object);
        if (this.properties.size() == 0) {
            this.properties = null;
        }
        return object2;
    }

    public void removeAllProperties() {
        this.properties = null;
    }

    public boolean hasProperty(Object object) {
        return this.properties == null ? false : this.properties.get(object) != null;
    }

    public Object getProperty(Object object) {
        return this.properties == null ? null : this.properties.get(object);
    }

    public int getPropertyCount() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public Enumeration getProperties() {
        if (this.properties == null) {
            return NO_PROPERTY_ENUMERATION;
        }
        return new PropertyEnumeration(this.properties);
    }

    public Object lookupProperty(Object object) {
        Tree tree = this;
        while (tree != null) {
            Object object2;
            if (tree.properties != null && (object2 = tree.properties.get(object)) != null) {
                return object2;
            }
            tree = tree.parent;
        }
        return null;
    }

    public void putLocationInfo(String string, boolean bl) {
        this.putProperty("LOCATION_INFO", new LocationInfo(string, bl));
    }

    public URL getLocation() {
        Tree tree = this;
        while (tree != null) {
            Tree tree2 = tree.getParent();
            LocationInfo locationInfo = (LocationInfo)tree.getProperty("LOCATION_INFO");
            if (locationInfo != null) {
                URL uRL = null;
                try {
                    uRL = new URL(locationInfo.location);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL == null && tree2 != null) {
                    URL uRL2;
                    URL uRL3 = uRL2 = locationInfo.xmlBaseAware ? tree2.getBase() : tree2.getLocation();
                    if (uRL2 != null) {
                        try {
                            uRL = new URL(uRL2, locationInfo.location);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                }
                return uRL;
            }
            tree = tree2;
        }
        return null;
    }

    public URL getBase() {
        Tree tree = this;
        while (tree != null) {
            Element element;
            String string;
            Tree tree2 = tree.getParent();
            if (tree instanceof Element && (string = (element = (Element)tree).getAttribute(Name.XML_BASE)) != null) {
                URL uRL;
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL2 == null && tree2 != null && (uRL = tree2.getBase()) != null) {
                    try {
                        uRL2 = new URL(uRL, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return uRL2;
            }
            if (tree.hasProperty("LOCATION_INFO")) {
                return tree.getLocation();
            }
            tree = tree2;
        }
        return null;
    }

    public XNode firstChild() {
        return this.first;
    }

    public XNode lastChild() {
        return this.getLastChild();
    }

    public URL location() {
        return this.getLocation();
    }

    private static class PropertyEnumeration
    implements Enumeration {
        private LinearHashtable properties;
        private Enumeration keys;
        private Object[] keyValuePair = new Object[2];

        public PropertyEnumeration(LinearHashtable linearHashtable) {
            this.properties = linearHashtable;
            this.keys = linearHashtable.keys();
        }

        public boolean hasMoreElements() {
            return this.keys.hasMoreElements();
        }

        public Object nextElement() {
            String string = (String)this.keys.nextElement();
            this.keyValuePair[0] = string;
            this.keyValuePair[1] = this.properties.get(string);
            return this.keyValuePair;
        }
    }
}

