/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.zip.GZIPInputStream;

public final class FileUtil {
    private static String platformDefaultEncoding = null;

    public static String urlToFileName(URL uRL) {
        File file = FileUtil.urlToFile(uRL);
        return file == null ? null : file.getPath();
    }

    public static File urlToFile(URL uRL) {
        Object object;
        Object object2;
        String string;
        String string2;
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        String string3 = uRL.getPath();
        if (string3 == null) {
            string3 = "/";
        }
        String string4 = null;
        if (PlatformUtil.IS_WINDOWS && (string2 = uRL.getHost()) != null && string2.length() > 0 && !"localhost".equals(string2) && string3.startsWith("/")) {
            string4 = string2;
            string3 = "/C:" + string3;
        }
        if (string3.startsWith("/")) {
            string = string3;
        } else {
            object2 = new File("any").toURI().getRawPath();
            string = ((String)object2).substring(0, ((String)object2).length() - 3) + string3;
        }
        object2 = null;
        try {
            object2 = new URI("file://" + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (object2 == null) {
            if (string3.startsWith("/")) {
                string = string3;
            } else {
                object = new File("any").toURI().getPath();
                string = ((String)object).substring(0, ((String)object).length() - 3) + string3;
            }
            try {
                object2 = new URI("file", null, null, -1, string, null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        object = new File(((URI)object2).normalize());
        if (string4 != null) {
            object = new File("\\\\" + string4 + ((File)object).getPath().substring(2));
        }
        return object;
    }

    public static URL fileToURL(String string) {
        return FileUtil.fileToURL(new File(string));
    }

    public static URL fileToURL(File file) {
        int n;
        String string;
        String string2 = null;
        boolean bl = false;
        if (PlatformUtil.IS_WINDOWS && (string = file.getPath()).startsWith("\\\\") && (n = string.indexOf(92, 2)) > 2) {
            string2 = string.substring(2, n);
            bl = file.isDirectory();
            file = new File("C:" + string.substring(n));
        }
        String string3 = file.toURI().normalize().getRawPath();
        if (string2 != null) {
            string3 = string3.substring(3);
            if (bl && !string3.endsWith("/")) {
                string3 = string3 + "/";
            }
        } else {
            string2 = "";
        }
        URL uRL = null;
        try {
            uRL = new URL("file", string2, -1, string3);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    public static String fileDirName(String string) {
        String string2;
        char c = File.separatorChar;
        int n = string.lastIndexOf(c);
        if (n < 0 && c == '\\') {
            c = '/';
            n = string.lastIndexOf(c);
        }
        if (n < 0) {
            string2 = ".";
        } else if (n == 0) {
            string2 = File.separator;
        } else {
            string2 = string.substring(0, n);
            if (c != File.separatorChar) {
                string2 = string2.replace(c, File.separatorChar);
            }
        }
        return string2;
    }

    public static String fileBaseName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        if (n < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String fileExtension(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= n || n2 == string.length() - 1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String trimFileExtension(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static String getRelativePath(File file, File file2) {
        URL uRL = FileUtil.fileToURL(file);
        URL uRL2 = FileUtil.fileToURL(file2);
        String string = URLUtil.getRelativeRawPath(uRL, uRL2, false);
        return URIUtil.unescape(string);
    }

    public static boolean removeFile(String string) {
        return FileUtil.removeFile(string, false);
    }

    public static boolean removeFile(String string, boolean bl) {
        return FileUtil.removeFile(new File(string), bl);
    }

    public static boolean removeFile(File file, boolean bl) {
        if (file.isDirectory() && bl && !FileUtil.emptyDirectory(file)) {
            return false;
        }
        return file.delete();
    }

    public static boolean emptyDirectory(String string) {
        return FileUtil.emptyDirectory(new File(string));
    }

    public static boolean emptyDirectory(File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isDirectory() ? !FileUtil.removeFile(file2, true) : !file2.delete()) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public static void copyFile(String string, String string2) throws IOException {
        FileUtil.copyFile(new File(string), new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.doCopyFile(fileInputStream, file2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(URL uRL, File file) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            FileUtil.doCopyFile(inputStream, file);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[8192];
        try {
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                outputStream.flush();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public static String loadString(String string) throws IOException {
        return FileUtil.loadString(new File(string), null);
    }

    public static String loadString(File file) throws IOException {
        return FileUtil.loadString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string2 = null;
        try {
            string2 = FileUtil.loadString(fileInputStream, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return string2;
    }

    public static String loadString(URL uRL) throws IOException {
        return FileUtil.loadString(uRL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(URL uRL, String string) throws IOException {
        Object object;
        int n;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode()) != 200) {
            StringBuffer stringBuffer = new StringBuffer("cannot access '");
            stringBuffer.append(uRL);
            stringBuffer.append("': error ");
            stringBuffer.append(n);
            String string2 = ((HttpURLConnection)object).getResponseMessage();
            if (string2 != null) {
                stringBuffer.append(": ");
                stringBuffer.append(string2);
            }
            throw new IOException(stringBuffer.toString());
        }
        if (string == null && (object = uRLConnection.getContentType()) != null) {
            string = FileUtil.contentTypeToCharsetName((String)object);
        }
        object = uRLConnection.getInputStream();
        String string3 = null;
        try {
            string3 = FileUtil.loadString((InputStream)object, string);
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((InputStream)object).close();
            throw throwable;
        }
        ((InputStream)object).close();
        return string3;
    }

    public static String contentTypeToMediaType(String string) {
        string = string.toLowerCase();
        String string2 = null;
        int n = string.lastIndexOf(59);
        if (n < 0) {
            string2 = string.trim();
        } else if (n > 0) {
            string2 = string.substring(0, n).trim();
        }
        return string2;
    }

    public static String contentTypeToCharsetName(String string) {
        int n;
        string = string.toLowerCase();
        String string2 = null;
        int n2 = string.indexOf("charset=");
        if (n2 >= 0 && n2 + 8 < string.length() - 1 && (n = (string2 = string.substring(n2 + 8).trim()).length()) >= 2 && string2.charAt(0) == '\"') {
            string2 = string2.substring(1, n - 1);
        }
        return string2;
    }

    public static String loadString(InputStream inputStream, String string) throws IOException {
        int n;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static void saveString(String string, String string2) throws IOException {
        FileUtil.saveString(string, new File(string2));
    }

    public static void saveString(String string, File file) throws IOException {
        FileUtil.saveString(string, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(String string, File file, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.saveString(string, fileOutputStream, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private static void saveString(String string, OutputStream outputStream, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string2);
        outputStreamWriter.write(string, 0, string.length());
        outputStreamWriter.flush();
    }

    public static byte[] loadBytes(String string) throws IOException {
        return FileUtil.loadBytes(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(fileInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray;
    }

    public static byte[] loadBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void saveBytes(byte[] byArray, String string) throws IOException {
        FileUtil.saveBytes(byArray, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBytes(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
            fileOutputStream.flush();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public static boolean isGzipped(String string) throws IOException {
        return FileUtil.isGzipped(new File(string));
    }

    public static boolean isGzipped(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = ((InputStream)fileInputStream).read();
        int n2 = ((InputStream)fileInputStream).read();
        ((InputStream)fileInputStream).close();
        return n == 31 && n2 == 139;
    }

    public static boolean isGzipped(byte[] byArray) {
        if (byArray.length <= 2) {
            return false;
        }
        return (byArray[0] & 0xFF) == 31 && (byArray[1] & 0xFF) == 139;
    }

    public static String loadGzippedString(String string) throws IOException {
        return FileUtil.loadGzippedString(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        try {
            string = FileUtil.loadGzippedString(fileInputStream, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        String string = null;
        try {
            string = FileUtil.loadGzippedString(inputStream, null);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string;
    }

    private static String loadGzippedString(InputStream inputStream, String string) throws IOException {
        int n;
        if (string == null) {
            string = FileUtil.defaultEncoding();
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new GZIPInputStream(inputStream), string);
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static String defaultEncoding() {
        block3: {
            if (platformDefaultEncoding != null) break block3;
            platformDefaultEncoding = new OutputStreamWriter(System.out).getEncoding();
            try {
                Charset charset = Charset.forName(platformDefaultEncoding);
                platformDefaultEncoding = charset.name();
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        return platformDefaultEncoding;
    }
}

