/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import java.util.StringTokenizer;

public final class JavaVersion
implements Comparable {
    private int major;
    private int minor1;
    private int minor2;
    private int patch;
    private static JavaVersion current;

    public static JavaVersion get() {
        String string;
        if (current == null && (string = System.getProperty("java.version")) != null) {
            current = JavaVersion.fromString(string);
        }
        return current;
    }

    public static JavaVersion fromString(String string) {
        int n;
        int n2;
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "._-");
        if (stringTokenizer.countTokens() < 3) {
            return null;
        }
        try {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        int n4 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return new JavaVersion(n3, n2, n, n4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public JavaVersion(int n, int n2, int n3, int n4) {
        if (n <= 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(Integer.toString(n3));
        }
        if (n4 < 0) {
            throw new IllegalArgumentException(Integer.toString(n4));
        }
        this.major = n;
        this.minor1 = n2;
        this.minor2 = n3;
        this.patch = n4;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JavaVersion)) {
            return false;
        }
        JavaVersion javaVersion = (JavaVersion)object;
        return this.major == javaVersion.major && this.minor1 == javaVersion.minor1 && this.minor2 == javaVersion.minor2 && this.patch == javaVersion.patch;
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof JavaVersion)) {
            return Integer.MAX_VALUE;
        }
        JavaVersion javaVersion = (JavaVersion)object;
        return 1000000 * this.major + 10000 * this.minor1 + 100 * this.minor2 + this.patch - (1000000 * javaVersion.major + 10000 * javaVersion.minor1 + 100 * javaVersion.minor2 + javaVersion.patch);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.major);
        stringBuffer.append('.');
        stringBuffer.append(this.minor1);
        stringBuffer.append('.');
        stringBuffer.append(this.minor2);
        if (this.patch > 0) {
            stringBuffer.append('_');
            String string = Integer.toString(this.patch);
            int n = string.length();
            while (n < 2) {
                stringBuffer.append('0');
                ++n;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

