/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;

public final class LinearHashtable
implements Cloneable,
Serializable {
    private transient Object[] table;

    public LinearHashtable() {
        this(3);
    }

    public LinearHashtable(int n) {
        this.table = new Object[2 * n];
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            if (this.table[n2] != null) {
                ++n;
            }
            n2 += 2;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        int n = 1;
        while (n < this.table.length) {
            if (this.table[n] == object) {
                return true;
            }
            n += 2;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        int n = LinearHashtable.indexOf(this.table, object);
        return n < 0 ? null : this.table[n + 1];
    }

    private static int indexOf(Object[] objectArray, Object object) {
        int n;
        int n2 = object.hashCode();
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n = 2 * (n2 % (objectArray.length / 2));
        do {
            if (objectArray[n3] == null || objectArray[n3].equals(object)) {
                return n3;
            }
            if ((n3 += 2) != objectArray.length) continue;
            n3 = 0;
        } while (n3 != n);
        return -1;
    }

    public Object put(Object object, Object object2) {
        Object[] objectArray;
        int n = LinearHashtable.indexOf(this.table, object);
        if (n < 0) {
            objectArray = new Object[2 * this.table.length];
            int n2 = 0;
            while (n2 < this.table.length) {
                Object object3 = this.table[n2];
                if (object3 != null) {
                    int n3 = LinearHashtable.indexOf(objectArray, object3);
                    objectArray[n3] = object3;
                    objectArray[n3 + 1] = this.table[n2 + 1];
                }
                n2 += 2;
            }
            this.table = objectArray;
            n = LinearHashtable.indexOf(this.table, object);
        }
        objectArray = this.table[n + 1];
        this.table[n] = object;
        this.table[n + 1] = object2;
        return objectArray;
    }

    public Object remove(Object object) {
        int n = LinearHashtable.indexOf(this.table, object);
        if (n < 0 || this.table[n] == null) {
            return null;
        }
        Object object2 = this.table[n + 1];
        this.table[n] = null;
        this.table[n + 1] = null;
        while (true) {
            if ((n += 2) == this.table.length) {
                n = 0;
            }
            if (this.table[n] == null) break;
            Object object3 = this.table[n];
            int n2 = LinearHashtable.indexOf(this.table, object3);
            if (this.table[n2] != null) continue;
            this.table[n2] = object3;
            this.table[n2 + 1] = this.table[n + 1];
            this.table[n] = null;
            this.table[n + 1] = null;
        }
        return object2;
    }

    public void clear() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
    }

    public Object clone() {
        LinearHashtable linearHashtable;
        try {
            linearHashtable = (LinearHashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        linearHashtable.table = new Object[this.table.length];
        System.arraycopy(this.table, 0, linearHashtable.table, 0, this.table.length);
        return linearHashtable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.table[n]);
                stringBuffer.append('=');
                stringBuffer.append(this.table[n + 1]);
            }
            n += 2;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void copyKeysInto(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            if (this.table[n2] != null) {
                objectArray[n++] = this.table[n2];
            }
            n2 += 2;
        }
    }

    public void copyElementsInto(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.table.length) {
            if (this.table[n2] != null) {
                objectArray[n++] = this.table[n2 + 1];
            }
            n2 += 2;
        }
    }

    public Enumeration keys() {
        return new KeyEnumeration();
    }

    public Enumeration elements() {
        return new ValueEnumeration();
    }

    public Enumeration entries() {
        return new EntryEnumeration();
    }

    public Object[] getKeyValueTable() {
        return this.table;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.table.length;
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(2 * this.size());
        int n2 = 0;
        while (n2 < n) {
            if (this.table[n2] != null) {
                objectOutputStream.writeObject(this.table[n2]);
                objectOutputStream.writeObject(this.table[n2 + 1]);
            }
            n2 += 2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.table = new Object[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            int n3 = LinearHashtable.indexOf(this.table, object);
            this.table[n3] = object;
            this.table[n3 + 1] = object2;
            n2 += 2;
        }
    }

    private final class EntryEnumeration
    implements Enumeration {
        private int index = 0;
        private Object[] entry = new Object[2];

        public EntryEnumeration() {
            this.next();
        }

        private void next() {
            while (this.index < LinearHashtable.this.table.length) {
                if (LinearHashtable.this.table[this.index] != null) break;
                this.index += 2;
            }
        }

        public boolean hasMoreElements() {
            return this.index < LinearHashtable.this.table.length;
        }

        public Object nextElement() {
            if (this.index < LinearHashtable.this.table.length) {
                this.entry[0] = LinearHashtable.this.table[this.index];
                this.entry[1] = LinearHashtable.this.table[this.index + 1];
                this.index += 2;
                this.next();
            } else {
                this.entry[0] = null;
                this.entry[1] = null;
            }
            return this.entry;
        }
    }

    private final class ValueEnumeration
    implements Enumeration {
        private int index = 0;

        public ValueEnumeration() {
            this.next();
        }

        private void next() {
            while (this.index < LinearHashtable.this.table.length) {
                if (LinearHashtable.this.table[this.index] != null) break;
                this.index += 2;
            }
        }

        public boolean hasMoreElements() {
            return this.index < LinearHashtable.this.table.length;
        }

        public Object nextElement() {
            Object object;
            if (this.index < LinearHashtable.this.table.length) {
                object = LinearHashtable.this.table[this.index + 1];
                this.index += 2;
                this.next();
            } else {
                object = null;
            }
            return object;
        }
    }

    private final class KeyEnumeration
    implements Enumeration {
        private int index = 0;

        public KeyEnumeration() {
            this.next();
        }

        private void next() {
            while (this.index < LinearHashtable.this.table.length) {
                if (LinearHashtable.this.table[this.index] != null) break;
                this.index += 2;
            }
        }

        public boolean hasMoreElements() {
            return this.index < LinearHashtable.this.table.length;
        }

        public Object nextElement() {
            Object object;
            if (this.index < LinearHashtable.this.table.length) {
                object = LinearHashtable.this.table[this.index];
                this.index += 2;
                this.next();
            } else {
                object = null;
            }
            return object;
        }
    }
}

