/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import com.xmlmind.xmledit.util.StringUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.print.Paper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class Preferences {
    protected Map map;

    public Preferences() {
        this(new MapImpl(null, null));
    }

    public Preferences(File file, String string) {
        this(new MapImpl(file, string));
    }

    public Preferences(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public void putString(String string, String string2) {
        this.map.putPreference(string, string2);
    }

    public String getString(String string, String string2) {
        String string3 = this.map.getPreference(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void putBoolean(String string, boolean bl) {
        this.map.putPreference(string, bl ? "true" : "false");
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return bl;
        }
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        return bl;
    }

    public void putInt(String string, int n) {
        this.map.putPreference(string, Integer.toString(n));
    }

    public int getInt(String string, int n, int n2, int n3) {
        int n4 = this.getInt(string, n3);
        if (n4 < n || n4 > n2) {
            return n3;
        }
        return n4;
    }

    public int getInt(String string, int n) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public void putDouble(String string, double d) {
        this.map.putPreference(string, Double.toString(d));
    }

    public double getDouble(String string, double d, double d2, double d3) {
        double d4 = this.getDouble(string, d3);
        if (d4 < d || d4 > d2) {
            return d3;
        }
        return d4;
    }

    public double getDouble(String string, double d) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public void putStrings(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.indexOf(38) >= 0) {
                string2 = StringUtil.replaceAll(string2, "&", "&amp;");
            }
            if (string2.indexOf(10) >= 0) {
                string2 = StringUtil.replaceAll(string2, "\n", "&#xA;");
            }
            if (n > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append(string2);
            ++n;
        }
        this.map.putPreference(string, stringBuffer.toString());
    }

    public String[] getStrings(String string, String[] stringArray) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return stringArray;
        }
        String[] stringArray2 = StringUtil.split(string2, '\n');
        int n = 0;
        while (n < stringArray2.length) {
            String string3 = stringArray2[n];
            if (string3.indexOf("&#xA;") >= 0) {
                string3 = StringUtil.replaceAll(string3, "&#xA;", "\n");
            }
            if (string3.indexOf("&amp;") >= 0) {
                string3 = StringUtil.replaceAll(string3, "&amp;", "&");
            }
            stringArray2[n] = string3;
            ++n;
        }
        return stringArray2;
    }

    public void putInts(String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        this.map.putPreference(string, stringBuffer.toString());
    }

    public int[] getInts(String string, int[] nArray) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int[] nArray2 = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (n < nArray2.length) {
            try {
                nArray2[n] = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return nArray;
            }
            ++n;
        }
        return nArray2;
    }

    public void putDoubles(String string, double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < dArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(dArray[n]);
            ++n;
        }
        this.map.putPreference(string, stringBuffer.toString());
    }

    public double[] getDoubles(String string, double[] dArray) {
        String string2 = this.map.getPreference(string);
        if (string2 == null) {
            return dArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        double[] dArray2 = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (n < dArray2.length) {
            try {
                dArray2[n] = Double.parseDouble(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return dArray;
            }
            ++n;
        }
        return dArray2;
    }

    public void putURL(String string, URL uRL) {
        this.putString(string, uRL.toExternalForm());
    }

    public URL getURL(String string, URL uRL) {
        String string2 = this.getString(string, null);
        if (string2 == null) {
            return uRL;
        }
        URL uRL2 = null;
        try {
            uRL2 = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL2 == null ? uRL : uRL2;
    }

    public void putColor(String string, Color color) {
        this.putInts(string, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
    }

    public Color getColor(String string, Color color) {
        int[] nArray = this.getInts(string, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
        if (nArray.length != 3 || nArray[0] < 0 || nArray[0] > 255 || nArray[1] < 0 || nArray[1] > 255 || nArray[2] < 0 || nArray[2] > 255) {
            return color;
        }
        return new Color(nArray[0], nArray[1], nArray[2]);
    }

    public void putRectangle(String string, Rectangle rectangle) {
        this.putInts(string, new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height});
    }

    public Rectangle getRectangle(String string, Rectangle rectangle) {
        int[] nArray = this.getInts(string, new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height});
        if (nArray.length != 4 || nArray[2] < 0 || nArray[3] < 0) {
            return rectangle;
        }
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void putPaper(String string, Paper paper) {
        this.putDoubles(string, new double[]{paper.getWidth(), paper.getHeight(), paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), paper.getImageableHeight()});
    }

    public Paper getPaper(String string, Paper paper) {
        double[] dArray = this.getDoubles(string, null);
        if (dArray == null) {
            return paper;
        }
        Paper paper2 = Preferences.newPaper(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        if (paper2 == null) {
            return paper;
        }
        return paper2;
    }

    public static final Paper newPaper(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d3 >= d || d4 < 0.0 || d4 >= d2 || d5 <= 0.0 || d5 > d - d3 || d6 <= 0.0 || d6 > d2 - d4) {
            return null;
        }
        Paper paper = new Paper();
        paper.setSize(d, d2);
        paper.setImageableArea(d3, d4, d5, d6);
        return paper;
    }

    public void remove(String string) {
        this.map.removePreference(string);
    }

    public void removeAll() {
        this.map.removeAllPreferences();
    }

    public String[] getAll() {
        return this.map.getAllPreferences();
    }

    public void putAll(Preferences preferences) {
        String[] stringArray = preferences.map.getAllPreferences();
        int n = 0;
        while (n < stringArray.length) {
            this.map.putPreference(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
    }

    public void putAll(Properties properties) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            this.map.putPreference((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean save() {
        return this.map.save();
    }

    public static final class MapImpl
    implements Map {
        private File file;
        private String header;
        private Properties properties;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MapImpl(File file, String string) {
            block4: {
                this.file = file;
                this.header = string;
                this.properties = new Properties();
                if (file == null) break block4;
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        this.properties.load(fileInputStream);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        fileInputStream.close();
                        throw throwable;
                    }
                    fileInputStream.close();
                    {
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public File getFile() {
            return this.file;
        }

        public String getHeader() {
            return this.header;
        }

        public String getPreference(String string) {
            return (String)this.properties.get(string);
        }

        public void putPreference(String string, String string2) {
            this.properties.put(string, string2);
        }

        public void removePreference(String string) {
            this.properties.remove(string);
        }

        public void removeAllPreferences() {
            this.properties.clear();
        }

        public String[] getAllPreferences() {
            String[] stringArray = new String[this.properties.size() * 2];
            int n = 0;
            Iterator<Map.Entry<Object, Object>> iterator = this.properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                stringArray[n] = (String)entry.getKey();
                stringArray[n + 1] = (String)entry.getValue();
                n += 2;
            }
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean save() {
            if (this.file == null) {
                return false;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                try {
                    this.properties.store(fileOutputStream, this.header == null ? "" : this.header);
                    fileOutputStream.flush();
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    fileOutputStream.close();
                    throw throwable;
                }
                fileOutputStream.close();
                {
                }
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }
    }

    public static interface Map {
        public String getPreference(String var1);

        public void putPreference(String var1, String var2);

        public void removePreference(String var1);

        public void removeAllPreferences();

        public String[] getAllPreferences();

        public boolean save();
    }
}

