/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.util;

import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    public static void zip(File file, FilenameFilter filenameFilter, File file2) throws IOException {
        ZipUtil.zip(file, filenameFilter, new FileOutputStream(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File file, FilenameFilter filenameFilter, OutputStream outputStream) throws IOException {
        file = file.getCanonicalFile();
        Archive archive = new Archive(new ZipOutputStream(outputStream));
        try {
            archive.addAll(file, filenameFilter, file);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            archive.close();
            throw throwable;
        }
        archive.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFromFile(File file, OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public static void unzip(File file, File file2) throws IOException {
        ZipUtil.unzip(new FileInputStream(file), file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File file) throws IOException {
        file = file.getCanonicalFile();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipUtil.unzip(zipInputStream, file);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            zipInputStream.close();
            throw throwable;
        }
        zipInputStream.close();
    }

    public static void unzip(ZipInputStream zipInputStream, File file) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            File file2 = new File(ZipUtil.fromZipEntryName(file, zipEntry.getName()));
            if (zipEntry.isDirectory()) {
                if (!file2.isDirectory() && !file2.mkdirs()) {
                    throw new IOException("cannot create directory '" + file2.getPath() + "'");
                }
            } else {
                File file3 = file2.getParentFile();
                if (!file3.isDirectory() && !file3.mkdirs()) {
                    throw new IOException("cannot create directory '" + file3.getPath() + "'");
                }
                ZipUtil.copyToFile(zipInputStream, file2);
            }
            zipInputStream.closeEntry();
        }
    }

    private static String fromZipEntryName(File file, String string) {
        int n = string.length();
        if (n > 1 && string.endsWith("/")) {
            string = string.substring(0, n - 1);
        }
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return file.getPath() + File.separatorChar + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            fileOutputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    public static final class Archive {
        private ZipOutputStream zip;
        private HashSet zipDirs;

        public Archive(ZipOutputStream zipOutputStream) {
            this.zip = zipOutputStream;
            this.zipDirs = new HashSet();
            if (zipOutputStream instanceof JarOutputStream) {
                this.zipDirs.add("META-INF/");
            }
        }

        public ZipOutputStream getZipOutputStream() {
            return this.zip;
        }

        public void add(File file, File file2) throws IOException, IllegalArgumentException {
            String string;
            String string2 = file2.getPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separatorChar;
            }
            if (!(string = file.getPath()).startsWith(string2)) {
                throw new IllegalArgumentException("'" + file2 + "' is not an ancestor directory of '" + file + "'");
            }
            String string3 = string.substring(string2.length());
            if (File.separatorChar != '/') {
                string3 = string3.replace(File.separatorChar, '/');
            }
            if (file.isDirectory()) {
                if (!string3.endsWith("/")) {
                    string3 = string3 + '/';
                }
                this.createZipDirs(string3);
            } else {
                this.createZipDirs(string3);
                ZipEntry zipEntry = new ZipEntry(string3);
                this.zip.putNextEntry(zipEntry);
                ZipUtil.copyFromFile(file, this.zip);
                this.zip.closeEntry();
            }
        }

        private void createZipDirs(String string) throws IOException {
            if ((string = URLPathUtil.dirName(string)) == null || string.length() == 0) {
                return;
            }
            if (this.zipDirs.contains(string)) {
                return;
            }
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String[] stringArray = StringUtil.split(string, '/');
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                stringBuffer.append(string2);
                stringBuffer.append('/');
                String string3 = stringBuffer.toString();
                if (!this.zipDirs.contains(string3)) {
                    ZipEntry zipEntry = new ZipEntry(string3);
                    this.zip.putNextEntry(zipEntry);
                    this.zip.closeEntry();
                    this.zipDirs.add(string3);
                }
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.zip.finish();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.zip.close();
                throw throwable;
            }
            this.zip.close();
        }

        public void addAll(File file, FilenameFilter filenameFilter, File file2) throws IOException {
            File[] fileArray = file.listFiles(filenameFilter);
            if (fileArray == null) {
                throw new IOException("cannot list directory '" + file + "'");
            }
            int n = 0;
            while (n < fileArray.length) {
                File file3 = fileArray[n];
                this.add(file3, file2);
                if (file3.isDirectory()) {
                    this.addAll(file3, filenameFilter, file2);
                }
                ++n;
            }
        }
    }
}

