/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xmlutil;

import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;

public final class Name
implements Serializable {
    public static Name XML_LANG;
    public static Name XML_SPACE;
    public static Name XML_BASE;
    public static Name XSI_TYPE;
    public static Name XSI_NIL;
    public static Name XSI_SCHEMA_LOCATION;
    public static Name XSI_NO_NAMESPACE_SCHEMA_LOCATION;
    public static Name XI_INCLUDE;
    public static Name XI_FALLBACK;
    private static Hashtable names;
    private static NameKey probe;
    private Namespace namespace;
    private String localPart;

    public static Name get(String string) {
        return Name.get(Namespace.NONE, string);
    }

    public static Name get(String string, String string2) {
        return Name.get(Namespace.get(string), string2);
    }

    public static Name get(Namespace namespace, String string) {
        if (namespace == null) {
            throw new IllegalArgumentException("null namespace");
        }
        if (string == null) {
            throw new IllegalArgumentException("null localPart");
        }
        Name.probe.namespace = namespace;
        Name.probe.localPart = string;
        Name name = (Name)names.get(probe);
        if (name == null) {
            name = new Name(namespace, string);
            names.put(new NameKey(namespace, string), name);
        }
        return name;
    }

    private Name(Namespace namespace, String string) {
        this.namespace = namespace;
        this.localPart = string;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static Name fromString(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        if (string.charAt(0) == '{' && (n = string.lastIndexOf(125)) > 0) {
            if (n + 1 == n2) {
                return null;
            }
            String string2 = string.substring(1, n);
            String string3 = string.substring(n + 1);
            if (string2.length() == 0) {
                if (!XMLUtil.isName(string3)) {
                    return null;
                }
                return Name.get(string3);
            }
            if (string2.trim().length() == 0 || !XMLUtil.isNCName(string3)) {
                return null;
            }
            return Name.get(string2, string3);
        }
        if (!XMLUtil.isName(string)) {
            return null;
        }
        return Name.get(string);
    }

    public String toString() {
        if (this.namespace == Namespace.NONE) {
            return this.localPart;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(this.namespace.getURI());
        stringBuffer.append('}');
        stringBuffer.append(this.localPart);
        return stringBuffer.toString();
    }

    public int compareTo(Name name) {
        if (this.namespace == name.namespace) {
            return this.localPart.compareTo(name.localPart);
        }
        return this.namespace.compareTo(name.namespace);
    }

    public static Name parse(String string, boolean bl, PrefixToNamespace prefixToNamespace) {
        Namespace namespace;
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n < 0) {
            string3 = "";
            string2 = string;
            if (!XMLUtil.isNCName(string2)) {
                return null;
            }
        } else {
            if (n == 0 || n == string.length() - 1) {
                return null;
            }
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (!XMLUtil.isNCName(string3) || !XMLUtil.isNCName(string2)) {
                return null;
            }
        }
        if (string3.length() == 0) {
            if (bl) {
                namespace = Namespace.NONE;
            } else {
                Namespace namespace2 = namespace = prefixToNamespace == null ? null : prefixToNamespace.prefixToNamespace("");
                if (namespace == null) {
                    namespace = Namespace.NONE;
                }
            }
        } else if ("xml".equals(string3)) {
            namespace = Namespace.XML;
        } else {
            Namespace namespace3 = namespace = prefixToNamespace == null ? null : prefixToNamespace.prefixToNamespace(string3);
            if (namespace == null) {
                return null;
            }
        }
        return Name.get(namespace, string2);
    }

    public String format(boolean bl, NamespaceToPrefixes namespaceToPrefixes) {
        Object object;
        Object object2;
        if (this.namespace == Namespace.NONE) {
            return this.localPart;
        }
        if (this.namespace == Namespace.XML) {
            object2 = "xml";
        } else {
            object = namespaceToPrefixes == null ? null : namespaceToPrefixes.namespaceToPrefixes(this.namespace);
            object2 = null;
            if (object != null) {
                int n = 0;
                while (n < ((Object)object).length) {
                    Object object3 = object[n];
                    if (((String)object3).length() > 0 || !bl) {
                        object2 = object3;
                        break;
                    }
                    ++n;
                }
            }
            if (object2 == null) {
                return this.toString();
            }
        }
        object = new StringBuffer();
        if (((String)object2).length() > 0) {
            ((StringBuffer)object).append((String)object2);
            ((StringBuffer)object).append(':');
        }
        ((StringBuffer)object).append(this.localPart);
        return ((StringBuffer)object).toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return Name.get(Namespace.get(this.namespace.getURI()), this.localPart);
    }

    static {
        names = new Hashtable();
        probe = new NameKey(null, null);
        XML_LANG = Name.get(Namespace.XML, "lang");
        XML_SPACE = Name.get(Namespace.XML, "space");
        XML_BASE = Name.get(Namespace.XML, "base");
        XSI_TYPE = Name.get(Namespace.XSI, "type");
        XSI_NIL = Name.get(Namespace.XSI, "nil");
        XSI_SCHEMA_LOCATION = Name.get(Namespace.XSI, "schemaLocation");
        XSI_NO_NAMESPACE_SCHEMA_LOCATION = Name.get(Namespace.XSI, "noNamespaceSchemaLocation");
        XI_INCLUDE = Name.get(Namespace.XI, "include");
        XI_FALLBACK = Name.get(Namespace.XI, "fallback");
    }

    private static final class NameKey {
        public Namespace namespace;
        public String localPart;

        public NameKey(Namespace namespace, String string) {
            this.namespace = namespace;
            this.localPart = string;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof NameKey)) {
                return false;
            }
            NameKey nameKey = (NameKey)object;
            return this.namespace == nameKey.namespace && this.localPart.equals(nameKey.localPart);
        }

        public int hashCode() {
            return System.identityHashCode(this.namespace) ^ this.localPart.hashCode();
        }
    }
}

