/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xmlutil;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.URIResolver;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.xml.sax.EntityResolver;

public final class XMLCatalogs {
    private static final URL[] NO_URLS = new URL[0];
    private static URL[] urls = NO_URLS;
    private static CatalogResolver catalogResolver = null;

    public static void set(URL[] uRLArray) {
        if (uRLArray == null) {
            uRLArray = NO_URLS;
        }
        urls = uRLArray;
        catalogResolver = null;
    }

    public static URL[] get() {
        return urls;
    }

    public static void setList(String string) throws MalformedURLException, IOException {
        if (string == null || (string = string.trim()).length() == 0) {
            XMLCatalogs.set(NO_URLS);
            return;
        }
        String[] stringArray = StringUtil.split(string, ';');
        ArrayList<URL> arrayList = new ArrayList<URL>();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n].trim();
            if (string2.length() != 0) {
                URL uRL = null;
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL == null) {
                    uRL = FileUtil.fileToURL(string2);
                }
                if (uRL != null) {
                    arrayList.add(uRL);
                }
            }
            ++n;
        }
        XMLCatalogs.set(arrayList.toArray(NO_URLS));
    }

    public static String getList() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < urls.length) {
            if (n > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(urls[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static URL resolveEntity(String string, String string2, URL uRL) throws MalformedURLException {
        XMLCatalogs.getCatalogResolver();
        String string3 = catalogResolver.getResolvedEntity(string, string2);
        URL uRL2 = string3 != null ? new URL(string3) : new URL(uRL, string2);
        return uRL2;
    }

    public static URL resolveURI(String string, URL uRL) throws MalformedURLException {
        String string2;
        String string3;
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        } else {
            string3 = string;
            string2 = null;
        }
        String string4 = XMLCatalogs.resolveURI(string3);
        URL uRL2 = string4 != null ? (string2 != null ? new URL(string4 + string2) : new URL(string4)) : new URL(uRL, string);
        return uRL2;
    }

    public static String resolveURI(String string) {
        XMLCatalogs.getCatalogResolver();
        String string2 = null;
        try {
            string2 = catalogResolver.getCatalog().resolveURI(string);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
        return string2;
    }

    public static EntityResolver getEntityResolver() {
        return XMLCatalogs.getCatalogResolver();
    }

    public static URIResolver getURIResolver() {
        return XMLCatalogs.getCatalogResolver();
    }

    private static CatalogResolver getCatalogResolver() {
        if (catalogResolver == null) {
            CatalogManager catalogManager = CatalogManager.getStaticManager();
            catalogManager.setIgnoreMissingProperties(true);
            catalogResolver = new CatalogResolver(true);
            Catalog catalog = catalogResolver.getCatalog();
            int n = 0;
            while (n < urls.length) {
                URL uRL = urls[n];
                try {
                    catalog.parseCatalog(uRL);
                }
                catch (IOException iOException) {
                }
                catch (Exception exception) {
                    System.err.println("Cannot parse XML catalog '" + uRL + "':\n" + MiscUtil.detailedReason(exception));
                }
                ++n;
            }
        }
        return catalogResolver;
    }

    public static void addRewriteURIEntry(String string, String string2) {
        CatalogResolver catalogResolver = XMLCatalogs.getCatalogResolver();
        Catalog catalog = catalogResolver.getCatalog();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' ?>\n");
        stringBuffer.append("<catalog");
        stringBuffer.append(" xmlns='urn:oasis:names:tc:entity:xmlns:xml:catalog'");
        stringBuffer.append(" prefer='public'>\n");
        stringBuffer.append("<rewriteURI uriStartString='");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("' rewritePrefix='");
        XMLUtil.escapeXML(string2, stringBuffer);
        stringBuffer.append("' />\n");
        stringBuffer.append("</catalog>\n");
        try {
            byte[] byArray = stringBuffer.toString().getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            catalog.parseCatalog("application/xml", byteArrayInputStream);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Internal error: cannot add rewriteURI entry");
            System.err.println("uriStartString='" + string + "' rewritePrefix='" + string2 + "':");
            System.err.println("--------------------------------------------");
            exception.printStackTrace();
            System.err.println("--------------------------------------------");
        }
    }

    static {
        if (System.getProperty("javax.xml.parsers.SAXParserFactory") == null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.jclark.xml.jaxp.SAXParserFactoryImpl");
        }
        try {
            XMLCatalogs.setList(System.getProperty("xml.catalog.files"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {}
    }
}

