/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xmlutil;

import java.util.StringTokenizer;

public class XMLUtil {
    private static int uniqueId = 0;

    public static final boolean isXMLSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static final boolean isXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
    }

    public static final String filterText(String string) {
        return XMLUtil.filterText(string, true);
    }

    public static final String filterText(String string, boolean bl) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            switch (c) {
                case '\t': 
                case '\n': {
                    cArray[n++] = c;
                    break;
                }
                case '\r': {
                    if (bl) {
                        if (n2 + 1 < cArray.length && cArray[n2 + 1] == '\n') {
                            ++n2;
                        }
                        cArray[n++] = 10;
                        break;
                    }
                    cArray[n++] = c;
                    break;
                }
                default: {
                    if ((c < ' ' || c > '\ud7ff') && (c < '\ue000' || c > '\ufffd')) break;
                    cArray[n++] = c;
                }
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public static final boolean isNCNameStartChar(char c) {
        switch (c) {
            case '_': 
            case '\u0386': 
            case '\u038c': 
            case '\u03da': 
            case '\u03dc': 
            case '\u03de': 
            case '\u03e0': 
            case '\u0559': 
            case '\u06d5': 
            case '\u093d': 
            case '\u09b2': 
            case '\u0a5e': 
            case '\u0a8d': 
            case '\u0abd': 
            case '\u0ae0': 
            case '\u0b3d': 
            case '\u0b9c': 
            case '\u0cde': 
            case '\u0e30': 
            case '\u0e84': 
            case '\u0e8a': 
            case '\u0e8d': 
            case '\u0ea5': 
            case '\u0ea7': 
            case '\u0eb0': 
            case '\u0ebd': 
            case '\u1100': 
            case '\u1109': 
            case '\u113c': 
            case '\u113e': 
            case '\u1140': 
            case '\u114c': 
            case '\u114e': 
            case '\u1150': 
            case '\u1159': 
            case '\u1163': 
            case '\u1165': 
            case '\u1167': 
            case '\u1169': 
            case '\u1175': 
            case '\u119e': 
            case '\u11a8': 
            case '\u11ab': 
            case '\u11ba': 
            case '\u11eb': 
            case '\u11f0': 
            case '\u11f9': 
            case '\u1f59': 
            case '\u1f5b': 
            case '\u1f5d': 
            case '\u1fbe': 
            case '\u2126': 
            case '\u212e': 
            case '\u3007': {
                return true;
            }
        }
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u00ff' || c >= '\u0100' && c <= '\u0131' || c >= '\u0134' && c <= '\u013e' || c >= '\u0141' && c <= '\u0148' || c >= '\u014a' && c <= '\u017e' || c >= '\u0180' && c <= '\u01c3' || c >= '\u01cd' && c <= '\u01f0' || c >= '\u01f4' && c <= '\u01f5' || c >= '\u01fa' && c <= '\u0217' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02bb' && c <= '\u02c1' || c >= '\u0388' && c <= '\u038a' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u040c' || c >= '\u040e' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0481' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c8' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0531' && c <= '\u0556' || c >= '\u0561' && c <= '\u0586' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f2' || c >= '\u0621' && c <= '\u063a' || c >= '\u0641' && c <= '\u064a' || c >= '\u0671' && c <= '\u06b7' || c >= '\u06ba' && c <= '\u06be' || c >= '\u06c0' && c <= '\u06ce' || c >= '\u06d0' && c <= '\u06d3' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u0905' && c <= '\u0939' || c >= '\u0958' && c <= '\u0961' || c >= '\u0985' && c <= '\u098c' || c >= '\u098f' && c <= '\u0990' || c >= '\u0993' && c <= '\u09a8' || c >= '\u09aa' && c <= '\u09b0' || c >= '\u09b6' && c <= '\u09b9' || c >= '\u09dc' && c <= '\u09dd' || c >= '\u09df' && c <= '\u09e1' || c >= '\u09f0' && c <= '\u09f1' || c >= '\u0a05' && c <= '\u0a0a' || c >= '\u0a0f' && c <= '\u0a10' || c >= '\u0a13' && c <= '\u0a28' || c >= '\u0a2a' && c <= '\u0a30' || c >= '\u0a32' && c <= '\u0a33' || c >= '\u0a35' && c <= '\u0a36' || c >= '\u0a38' && c <= '\u0a39' || c >= '\u0a59' && c <= '\u0a5c' || c >= '\u0a72' && c <= '\u0a74' || c >= '\u0a85' && c <= '\u0a8b' || c >= '\u0a8f' && c <= '\u0a91' || c >= '\u0a93' && c <= '\u0aa8' || c >= '\u0aaa' && c <= '\u0ab0' || c >= '\u0ab2' && c <= '\u0ab3' || c >= '\u0ab5' && c <= '\u0ab9' || c >= '\u0b05' && c <= '\u0b0c' || c >= '\u0b0f' && c <= '\u0b10' || c >= '\u0b13' && c <= '\u0b28' || c >= '\u0b2a' && c <= '\u0b30' || c >= '\u0b32' && c <= '\u0b33' || c >= '\u0b36' && c <= '\u0b39' || c >= '\u0b5c' && c <= '\u0b5d' || c >= '\u0b5f' && c <= '\u0b61' || c >= '\u0b85' && c <= '\u0b8a' || c >= '\u0b8e' && c <= '\u0b90' || c >= '\u0b92' && c <= '\u0b95' || c >= '\u0b99' && c <= '\u0b9a' || c >= '\u0b9e' && c <= '\u0b9f' || c >= '\u0ba3' && c <= '\u0ba4' || c >= '\u0ba8' && c <= '\u0baa' || c >= '\u0bae' && c <= '\u0bb5' || c >= '\u0bb7' && c <= '\u0bb9' || c >= '\u0c05' && c <= '\u0c0c' || c >= '\u0c0e' && c <= '\u0c10' || c >= '\u0c12' && c <= '\u0c28' || c >= '\u0c2a' && c <= '\u0c33' || c >= '\u0c35' && c <= '\u0c39' || c >= '\u0c60' && c <= '\u0c61' || c >= '\u0c85' && c <= '\u0c8c' || c >= '\u0c8e' && c <= '\u0c90' || c >= '\u0c92' && c <= '\u0ca8' || c >= '\u0caa' && c <= '\u0cb3' || c >= '\u0cb5' && c <= '\u0cb9' || c >= '\u0ce0' && c <= '\u0ce1' || c >= '\u0d05' && c <= '\u0d0c' || c >= '\u0d0e' && c <= '\u0d10' || c >= '\u0d12' && c <= '\u0d28' || c >= '\u0d2a' && c <= '\u0d39' || c >= '\u0d60' && c <= '\u0d61' || c >= '\u0e01' && c <= '\u0e2e' || c >= '\u0e32' && c <= '\u0e33' || c >= '\u0e40' && c <= '\u0e45' || c >= '\u0e81' && c <= '\u0e82' || c >= '\u0e87' && c <= '\u0e88' || c >= '\u0e94' && c <= '\u0e97' || c >= '\u0e99' && c <= '\u0e9f' || c >= '\u0ea1' && c <= '\u0ea3' || c >= '\u0eaa' && c <= '\u0eab' || c >= '\u0ead' && c <= '\u0eae' || c >= '\u0eb2' && c <= '\u0eb3' || c >= '\u0ec0' && c <= '\u0ec4' || c >= '\u0f40' && c <= '\u0f47' || c >= '\u0f49' && c <= '\u0f69' || c >= '\u10a0' && c <= '\u10c5' || c >= '\u10d0' && c <= '\u10f6' || c >= '\u1102' && c <= '\u1103' || c >= '\u1105' && c <= '\u1107' || c >= '\u110b' && c <= '\u110c' || c >= '\u110e' && c <= '\u1112' || c >= '\u1154' && c <= '\u1155' || c >= '\u115f' && c <= '\u1161' || c >= '\u116d' && c <= '\u116e' || c >= '\u1172' && c <= '\u1173' || c >= '\u11ae' && c <= '\u11af' || c >= '\u11b7' && c <= '\u11b8' || c >= '\u11bc' && c <= '\u11c2' || c >= '\u1e00' && c <= '\u1e9b' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u1f00' && c <= '\u1f15' || c >= '\u1f18' && c <= '\u1f1d' || c >= '\u1f20' && c <= '\u1f45' || c >= '\u1f48' && c <= '\u1f4d' || c >= '\u1f50' && c <= '\u1f57' || c >= '\u1f5f' && c <= '\u1f7d' || c >= '\u1f80' && c <= '\u1fb4' || c >= '\u1fb6' && c <= '\u1fbc' || c >= '\u1fc2' && c <= '\u1fc4' || c >= '\u1fc6' && c <= '\u1fcc' || c >= '\u1fd0' && c <= '\u1fd3' || c >= '\u1fd6' && c <= '\u1fdb' || c >= '\u1fe0' && c <= '\u1fec' || c >= '\u1ff2' && c <= '\u1ff4' || c >= '\u1ff6' && c <= '\u1ffc' || c >= '\u212a' && c <= '\u212b' || c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3' || c >= '\u4e00' && c <= '\u9fa5' || c >= '\u3021' && c <= '\u3029';
    }

    public static final boolean isNCNameOtherChar(char c) {
        switch (c) {
            case '-': 
            case '.': 
            case '\u00b7': 
            case '\u02d0': 
            case '\u02d1': 
            case '\u0387': 
            case '\u05bf': 
            case '\u05c4': 
            case '\u0640': 
            case '\u0670': 
            case '\u093c': 
            case '\u094d': 
            case '\u09bc': 
            case '\u09be': 
            case '\u09bf': 
            case '\u09d7': 
            case '\u0a02': 
            case '\u0a3c': 
            case '\u0a3e': 
            case '\u0a3f': 
            case '\u0abc': 
            case '\u0b3c': 
            case '\u0bd7': 
            case '\u0d57': 
            case '\u0e31': 
            case '\u0e46': 
            case '\u0eb1': 
            case '\u0ec6': 
            case '\u0f35': 
            case '\u0f37': 
            case '\u0f39': 
            case '\u0f3e': 
            case '\u0f3f': 
            case '\u0f97': 
            case '\u0fb9': 
            case '\u20e1': 
            case '\u3005': 
            case '\u3099': 
            case '\u309a': {
                return true;
            }
        }
        return c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0483' && c <= '\u0486' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c >= '\u05c1' && c <= '\u05c2' || c >= '\u064b' && c <= '\u0652' || c >= '\u06d6' && c <= '\u06dc' || c >= '\u06dd' && c <= '\u06df' || c >= '\u06e0' && c <= '\u06e4' || c >= '\u06e7' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u0901' && c <= '\u0903' || c >= '\u093e' && c <= '\u094c' || c >= '\u0951' && c <= '\u0954' || c >= '\u0962' && c <= '\u0963' || c >= '\u0981' && c <= '\u0983' || c >= '\u09c0' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c >= '\u09e2' && c <= '\u09e3' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a70' && c <= '\u0a71' || c >= '\u0a81' && c <= '\u0a83' || c >= '\u0abe' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c >= '\u0b01' && c <= '\u0b03' || c >= '\u0b3e' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c >= '\u0e34' && c <= '\u0e3a' || c >= '\u0e47' && c <= '\u0e4e' || c >= '\u0eb4' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebc' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0f18' && c <= '\u0f19' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c >= '\u20d0' && c <= '\u20dc' || c >= '\u302a' && c <= '\u302f' || c >= '0' && c <= '9' || c >= '\u0660' && c <= '\u0669' || c >= '\u06f0' && c <= '\u06f9' || c >= '\u0966' && c <= '\u096f' || c >= '\u09e6' && c <= '\u09ef' || c >= '\u0a66' && c <= '\u0a6f' || c >= '\u0ae6' && c <= '\u0aef' || c >= '\u0b66' && c <= '\u0b6f' || c >= '\u0be7' && c <= '\u0bef' || c >= '\u0c66' && c <= '\u0c6f' || c >= '\u0ce6' && c <= '\u0cef' || c >= '\u0d66' && c <= '\u0d6f' || c >= '\u0e50' && c <= '\u0e59' || c >= '\u0ed0' && c <= '\u0ed9' || c >= '\u0f20' && c <= '\u0f29' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    public static final boolean isNCName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLUtil.isNCNameStartChar(c)) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!XMLUtil.isNCNameStartChar(c) && !XMLUtil.isNCNameOtherChar(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean isName(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLUtil.isNCNameStartChar(c) && c != ':') {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            c = string.charAt(n2);
            if (!XMLUtil.isNCNameStartChar(c) && c != ':' && !XMLUtil.isNCNameOtherChar(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean isNmtoken(String string) {
        int n;
        if (string == null || (n = string.length()) == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!XMLUtil.isNCNameStartChar(c) && c != ':' && !XMLUtil.isNCNameOtherChar(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final boolean isPITarget(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return XMLUtil.isName(string) && !string.regionMatches(true, 0, "xml", 0, 3);
    }

    public static final String collapseWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.compressWhiteSpace(string, stringBuffer);
        int n = stringBuffer.length() - 1;
        if (n >= 0) {
            if (stringBuffer.charAt(n) == ' ') {
                stringBuffer.deleteCharAt(n);
                --n;
            }
            if (n >= 0 && stringBuffer.charAt(0) == ' ') {
                stringBuffer.deleteCharAt(0);
            }
        }
        return stringBuffer.toString();
    }

    public static final String compressWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.compressWhiteSpace(string, stringBuffer);
        return stringBuffer.toString();
    }

    private static void compressWhiteSpace(String string, StringBuffer stringBuffer) {
        int n = string.length();
        int n2 = 63;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string.charAt(n3);
            switch (n4) {
                case 9: 
                case 10: 
                case 13: {
                    n4 = 32;
                }
            }
            if (n4 == 32) {
                if (n2 != 32) {
                    stringBuffer.append((char)n4);
                    n2 = n4;
                }
            } else {
                stringBuffer.append((char)n4);
                n2 = n4;
            }
            ++n3;
        }
    }

    public static final String replaceWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 63;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            switch (c) {
                case '\t': 
                case '\r': {
                    stringBuffer.append(' ');
                    break;
                }
                case '\n': {
                    if (n2 == 13) break;
                    stringBuffer.append(' ');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            n2 = c;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final String[] splitList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\t");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static final String escapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.escapeXML(string, stringBuffer);
        return stringBuffer.toString();
    }

    public static final String quoteXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static final void escapeXML(String string, StringBuffer stringBuffer) {
        char[] cArray = string.toCharArray();
        XMLUtil.escapeXML(cArray, 0, cArray.length, stringBuffer);
    }

    public static final void escapeXML(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        XMLUtil.escapeXML(cArray, n, n2, stringBuffer, Integer.MAX_VALUE);
    }

    public static final void escapeXML(char[] cArray, int n, int n2, StringBuffer stringBuffer, int n3) {
        int n4 = n + n2;
        int n5 = n;
        while (n5 < n4) {
            char c = cArray[n5];
            switch (c) {
                case '\'': {
                    stringBuffer.append("&#39;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&#34;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&#60;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&#62;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&#38;");
                    break;
                }
                case '\u00a0': {
                    stringBuffer.append("&#160;");
                    break;
                }
                default: {
                    if (c > n3) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            ++n5;
        }
    }

    public static final String unescapeXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLUtil.unescapeXML(string, 0, string.length(), stringBuffer);
        return stringBuffer.toString();
    }

    public static final void unescapeXML(String string, int n, int n2, StringBuffer stringBuffer) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = string.charAt(n4);
            if (c == '&') {
                StringBuffer stringBuffer2 = new StringBuffer();
                ++n4;
                while (n4 < n3) {
                    c = string.charAt(n4);
                    if (c == ';') break;
                    stringBuffer2.append(c);
                    ++n4;
                }
                c = XMLUtil.parseCharRef(stringBuffer2.toString());
            }
            stringBuffer.append(c);
            ++n4;
        }
    }

    private static char parseCharRef(String string) {
        if (string.length() >= 2 && string.charAt(0) == '#') {
            int n;
            try {
                n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (n < 0 || n > 65535) {
                return '?';
            }
            return (char)n;
        }
        if (string.equals("amp")) {
            return '&';
        }
        if (string.equals("apos")) {
            return '\'';
        }
        if (string.equals("quot")) {
            return '\"';
        }
        if (string.equals("lt")) {
            return '<';
        }
        if (string.equals("gt")) {
            return '>';
        }
        return '?';
    }

    public static final String getUniqueId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("___");
        stringBuffer.append(Long.toString(System.currentTimeMillis(), 36));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(uniqueId++, 36));
        return stringBuffer.toString();
    }

    public static final String nameToLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        boolean bl = true;
        boolean bl2 = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '-': 
                case '.': 
                case '_': {
                    stringBuffer.append(' ');
                    bl2 = true;
                    break;
                }
                default: {
                    if (Character.isLetter(c2)) {
                        if (Character.isDigit(c) || Character.isUpperCase(c2) && Character.isLowerCase(c)) {
                            stringBuffer.append(' ');
                            bl2 = true;
                        }
                        if (bl) {
                            bl = false;
                            stringBuffer.append(Character.toUpperCase(c2));
                            break;
                        }
                        stringBuffer.append(Character.toLowerCase(c2));
                        break;
                    }
                    if (Character.isDigit(c2)) {
                        if (Character.isLetter(c)) {
                            stringBuffer.append(' ');
                            bl2 = true;
                        }
                        if (bl) {
                            bl = false;
                        }
                        stringBuffer.append(c2);
                        break;
                    }
                    if (bl) {
                        bl = false;
                    }
                    stringBuffer.append(c2);
                }
            }
            c = c2;
            ++n2;
        }
        String string2 = stringBuffer.toString();
        if (bl2) {
            string2 = XMLUtil.collapseWhiteSpace(string2);
        }
        return string2;
    }
}

