/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.net.URI;
import java.net.URISyntaxException;

public class AnyURIValue
extends Value {
    private URI uri;

    public static AnyURIValue parseAnyURI(String string) throws InvalidDataException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("anyURISyntax", string, MiscUtil.reason(uRISyntaxException)));
        }
        return new AnyURIValue(uRI);
    }

    public AnyURIValue(URI uRI) {
        this.uri = uRI;
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toASCIIString();
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AnyURIValue)) {
            return false;
        }
        AnyURIValue anyURIValue = (AnyURIValue)object;
        return this.uri.equals(anyURIValue.uri);
    }

    public int length() {
        return this.uri.toASCIIString().length();
    }
}

