/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;

public final class Base16 {
    private static final char[] toDigit = "0123456789ABCDEF".toCharArray();
    private static final int[] fromDigit = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    public static byte[] decode(String string) throws InvalidDataException {
        int n = string.length();
        if (n % 2 != 0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("oddHexStringLength"));
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            char c = string.charAt(n3);
            char c2 = string.charAt(n3 + 1);
            if (c < '0' || c > 'f' || (n5 = fromDigit[c - 48]) < 0) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("invalidHexChar", "#x" + Integer.toHexString(c)));
            }
            if (c2 < '0' || c2 > 'f' || (n4 = fromDigit[c2 - 48]) < 0) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("invalidHexChar", "#x" + Integer.toHexString(c2)));
            }
            byArray[n2++] = (byte)((n5 & 0xF) << 4 | n4 & 0xF);
            n3 += 2;
        }
        return byArray;
    }

    public static String encode(byte[] byArray) {
        char[] cArray = new char[2 * byArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            cArray[n++] = toDigit[by >>> 4 & 0xF];
            cArray[n++] = toDigit[by & 0xF];
            ++n2;
        }
        return new String(cArray);
    }
}

