/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.NumericValue;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.math.BigDecimal;

public class ByteValue
extends NumericValue {
    private byte number;

    public static ByteValue parseByte(String string) throws InvalidDataException {
        byte by;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            by = Byte.parseByte(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("byteSyntax", string));
        }
        return new ByteValue(by);
    }

    public ByteValue(byte by) {
        this.number = by;
    }

    public byte getByte() {
        return this.number;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(Byte.toString(this.number));
    }

    public String toString() {
        return Byte.toString(this.number);
    }

    public int hashCode() {
        return this.number;
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof ByteValue) {
            byte by = ((ByteValue)value).number;
            return this.number < by ? -1 : (this.number > by ? 1 : 0);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    public int totalDigits() {
        return Byte.toString(this.number).length();
    }

    public int fractionDigits() {
        return 0;
    }
}

