/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.DateTimeUtil;
import com.xmlmind.xmledit.xsd.datatype.DurationValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeValue
extends Value {
    int year;
    byte month;
    byte day;
    byte hour;
    byte minute;
    double second;
    byte tzSign;
    byte tzHour;
    byte tzMinute;

    public static DateTimeValue parseDateTime(String string) throws InvalidDataException {
        DateTimeValue dateTimeValue;
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = string.indexOf(45, n3)) < n3 + 4) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        int n4 = DateTimeUtil.parseInt(string, n3, n);
        if (bl) {
            n4 = -n4;
        }
        if ((n3 = n + 1) + 2 >= n2 || string.charAt(n3 + 2) != '-') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        int n5 = DateTimeUtil.parseInt(string, n3, n3 + 2);
        if ((n3 += 3) + 2 >= n2 || string.charAt(n3 + 2) != 'T') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        int n6 = DateTimeUtil.parseInt(string, n3, n3 + 2);
        if ((n3 += 3) + 2 >= n2 || string.charAt(n3 + 2) != ':') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        int n7 = DateTimeUtil.parseInt(string, n3, n3 + 2);
        if ((n3 += 3) + 2 >= n2 || string.charAt(n3 + 2) != ':') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        int n8 = DateTimeUtil.parseInt(string, n3, n3 + 2);
        n = DateTimeUtil.parseTimeZone(string, n3 += 3, nArray);
        if (n < n3 + 2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        double d = DateTimeUtil.parseDouble(string, n3, n);
        try {
            dateTimeValue = new DateTimeValue(n4, n5, n6, n7, n8, d, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateTimeSyntax", string));
        }
        return dateTimeValue;
    }

    DateTimeValue() {
    }

    public DateTimeValue(int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8) {
        if (n == 0) {
            throw new IllegalArgumentException("no year 0000");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("invalid month");
        }
        if (n3 < 1 || n3 > DateTimeUtil.lastDayOfMonth(n2, n)) {
            throw new IllegalArgumentException("invalid day");
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("invalid hour");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("invalid minute");
        }
        if (d < 0.0 || d > 60.0) {
            throw new IllegalArgumentException("invalid second");
        }
        switch (n6) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n7 < 0 || n7 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n8 < 0 || n8 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n6 == -1 && n7 == 0 && n8 == 0) {
            n6 = 1;
        }
        this.year = n;
        this.month = (byte)n2;
        this.day = (byte)n3;
        this.hour = (byte)n4;
        this.minute = (byte)n5;
        this.second = d;
        this.tzSign = (byte)n6;
        this.tzHour = (byte)n7;
        this.tzMinute = (byte)n8;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public double getSecond() {
        return this.second;
    }

    public int getTimeZoneSign() {
        return this.tzSign;
    }

    public int getTimeZoneHour() {
        return this.tzHour;
    }

    public int getTimeZoneMinute() {
        return this.tzMinute;
    }

    public Date toDate() {
        Calendar calendar;
        DateTimeValue dateTimeValue;
        if (this.tzSign == 0) {
            dateTimeValue = this;
            calendar = Calendar.getInstance();
        } else {
            dateTimeValue = this.withNormalizedTimeZone();
            calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        double d = Math.rint(dateTimeValue.second);
        int n = (int)((dateTimeValue.second - d) * 1000.0);
        calendar.set(dateTimeValue.year, dateTimeValue.month - 1, dateTimeValue.day, dateTimeValue.hour, dateTimeValue.minute, (int)d);
        calendar.set(14, n);
        return calendar.getTime();
    }

    public static DateTimeValue fromDate(Date date) {
        return DateTimeValue.fromDate(date, false);
    }

    public static DateTimeValue fromDate(Date date, boolean bl) {
        Calendar calendar = bl ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.year = calendar.get(1);
        dateTimeValue.month = (byte)(calendar.get(2) + 1);
        dateTimeValue.day = (byte)calendar.get(5);
        dateTimeValue.hour = (byte)calendar.get(11);
        dateTimeValue.minute = (byte)calendar.get(12);
        dateTimeValue.second = (double)calendar.get(13) + (double)calendar.get(14) / 1000.0;
        dateTimeValue.tzHour = 0;
        dateTimeValue.tzMinute = 0;
        dateTimeValue.tzSign = bl ? (byte)0 : 1;
        return dateTimeValue;
    }

    public DateTimeValue withNormalizedTimeZone() {
        if (this.tzSign == 0 || this.tzHour == 0 && this.tzMinute == 0) {
            return this;
        }
        return this.withTimeZone(this.tzSign, this.tzHour, this.tzMinute);
    }

    public DateTimeValue withTimeZone(int n, int n2, int n3) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n2 < 0 || n2 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        DurationValue durationValue = new DurationValue(0, 0, 0, n2, n3, 0.0);
        durationValue.setNegative(n == 1);
        DateTimeValue dateTimeValue = this.add(durationValue);
        dateTimeValue.tzSign = 1;
        dateTimeValue.tzHour = 0;
        dateTimeValue.tzMinute = 0;
        return dateTimeValue;
    }

    public DateTimeValue add(DurationValue durationValue) {
        int n = durationValue.isNegative() ? -1 : 1;
        DateTimeValue dateTimeValue = new DateTimeValue();
        int n2 = this.month + n * durationValue.getMonth();
        int n3 = DateTimeValue.modulo(n2, 1, 13);
        int n4 = DateTimeValue.quotient(n2, 1, 13);
        int n5 = this.year + n * durationValue.getYear() + n4;
        dateTimeValue.tzSign = this.tzSign;
        dateTimeValue.tzHour = this.tzHour;
        dateTimeValue.tzMinute = this.tzMinute;
        double d = this.second + (double)n * durationValue.getSecond();
        n4 = (int)DateTimeValue.fquotient(d, 60.0);
        dateTimeValue.second = d - (double)(n4 * 60);
        n2 = this.minute + n * durationValue.getMinute() + n4;
        n4 = DateTimeValue.quotient(n2, 60);
        dateTimeValue.minute = (byte)(n2 - n4 * 60);
        n2 = this.hour + n * durationValue.getHour() + n4;
        n4 = DateTimeValue.quotient(n2, 24);
        dateTimeValue.hour = (byte)(n2 - n4 * 24);
        int n6 = DateTimeValue.maxDayInMonth(n5, n3);
        int n7 = this.day > n6 ? n6 : (this.day < 1 ? 1 : (int)this.day);
        int n8 = n7 + n * durationValue.getDay() + n4;
        while (true) {
            if (n8 < 1) {
                n8 += DateTimeValue.maxDayInMonth(n5, n3 - 1);
                n4 = -1;
            } else {
                n6 = DateTimeValue.maxDayInMonth(n5, n3);
                if (n8 <= n6) break;
                n8 -= n6;
                n4 = 1;
            }
            n2 = n3 + n4;
            n3 = DateTimeValue.modulo(n2, 1, 13);
            n5 += DateTimeValue.quotient(n2, 1, 13);
        }
        dateTimeValue.day = (byte)n8;
        dateTimeValue.month = (byte)n3;
        dateTimeValue.year = n5;
        return dateTimeValue;
    }

    private static final double fquotient(double d, double d2) {
        return Math.floor(d / d2);
    }

    private static final double fmodulo(double d, double d2) {
        return d - Math.floor(d / d2) * d2;
    }

    private static final int quotient(int n, int n2) {
        if (n < 0) {
            if (n2 < 0) {
                return -n / -n2;
            }
            n = -n;
            return -((n + n2 - 1) / n2);
        }
        if (n2 < 0) {
            n2 = -n2;
            return -((n + n2 - 1) / n2);
        }
        return n / n2;
    }

    private static final int modulo(int n, int n2) {
        return n - DateTimeValue.quotient(n, n2) * n2;
    }

    private static final int quotient(int n, int n2, int n3) {
        return DateTimeValue.quotient(n - n2, n3 - n2);
    }

    private static final int modulo(int n, int n2, int n3) {
        return DateTimeValue.modulo(n - n2, n3 - n2) + n2;
    }

    private static final int maxDayInMonth(int n, int n2) {
        int n3 = DateTimeValue.modulo(n2, 1, 13);
        int n4 = n + DateTimeValue.quotient(n2, 1, 13);
        return DateTimeUtil.lastDayOfMonth(n3, n4);
    }

    public String toString() {
        return this.withNormalizedTimeZone().format();
    }

    public String format() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.year < 0) {
            stringBuffer.append('-');
            DateTimeUtil.appendPadded(-this.year, 4, stringBuffer);
        } else {
            DateTimeUtil.appendPadded(this.year, 4, stringBuffer);
        }
        stringBuffer.append('-');
        DateTimeUtil.appendPadded(this.month, 2, stringBuffer);
        stringBuffer.append('-');
        DateTimeUtil.appendPadded(this.day, 2, stringBuffer);
        stringBuffer.append('T');
        DateTimeUtil.appendPadded(this.hour, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeUtil.appendPadded(this.minute, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeUtil.appendPadded(this.second, 2, stringBuffer);
        DateTimeUtil.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public int hashCode() {
        DateTimeValue dateTimeValue = this.withNormalizedTimeZone();
        int n = 0;
        n ^= dateTimeValue.year;
        n ^= dateTimeValue.month;
        n ^= dateTimeValue.day;
        n ^= dateTimeValue.hour;
        n ^= dateTimeValue.minute;
        return n ^= (int)dateTimeValue.second;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DateTimeValue)) {
            return false;
        }
        return this.compareTo((DateTimeValue)object) == 0;
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof DateTimeValue)) {
            return -2;
        }
        DateTimeValue dateTimeValue = (DateTimeValue)value;
        if (this.tzSign == dateTimeValue.tzSign && this.tzHour == dateTimeValue.tzHour && this.tzMinute == dateTimeValue.tzMinute) {
            return DateTimeValue.doCompare(this, dateTimeValue);
        }
        DateTimeValue dateTimeValue2 = this.withNormalizedTimeZone();
        DateTimeValue dateTimeValue3 = dateTimeValue.withNormalizedTimeZone();
        if (dateTimeValue2.tzSign == 0 && dateTimeValue3.tzSign == 0 || dateTimeValue2.tzSign != 0 && dateTimeValue3.tzSign != 0) {
            return DateTimeValue.doCompare(dateTimeValue2, dateTimeValue3);
        }
        if (dateTimeValue2.tzSign != 0 && dateTimeValue3.tzSign == 0) {
            if (DateTimeValue.doCompare(dateTimeValue2, dateTimeValue3.withTimeZone(1, 14, 0)) == -1) {
                return -1;
            }
            if (DateTimeValue.doCompare(dateTimeValue2, dateTimeValue3.withTimeZone(-1, 14, 0)) == 1) {
                return 1;
            }
            return -2;
        }
        if (DateTimeValue.doCompare(dateTimeValue2.withTimeZone(-1, 14, 0), dateTimeValue3) == -1) {
            return -1;
        }
        if (DateTimeValue.doCompare(dateTimeValue2.withTimeZone(1, 14, 0), dateTimeValue3) == 1) {
            return 1;
        }
        return -2;
    }

    private static final int doCompare(DateTimeValue dateTimeValue, DateTimeValue dateTimeValue2) {
        if (dateTimeValue.year < dateTimeValue2.year) {
            return -1;
        }
        if (dateTimeValue.year > dateTimeValue2.year) {
            return 1;
        }
        if (dateTimeValue.month < dateTimeValue2.month) {
            return -1;
        }
        if (dateTimeValue.month > dateTimeValue2.month) {
            return 1;
        }
        if (dateTimeValue.day < dateTimeValue2.day) {
            return -1;
        }
        if (dateTimeValue.day > dateTimeValue2.day) {
            return 1;
        }
        if (dateTimeValue.hour < dateTimeValue2.hour) {
            return -1;
        }
        if (dateTimeValue.hour > dateTimeValue2.hour) {
            return 1;
        }
        if (dateTimeValue.minute < dateTimeValue2.minute) {
            return -1;
        }
        if (dateTimeValue.minute > dateTimeValue2.minute) {
            return 1;
        }
        if (dateTimeValue.second < dateTimeValue2.second) {
            return -1;
        }
        if (dateTimeValue.second > dateTimeValue2.second) {
            return 1;
        }
        return 0;
    }
}

