/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.DateTimeUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.Date;

public class DateValue
extends Value {
    private DateTimeValue dateTime;

    public static DateValue parseDate(String string) throws InvalidDataException {
        DateValue dateValue;
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateSyntax", string));
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = string.indexOf(45, n3)) < n3 + 4) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateSyntax", string));
        }
        int n4 = DateTimeUtil.parseInt(string, n3, n);
        if (bl) {
            n4 = -n4;
        }
        if ((n3 = n + 1) + 2 >= n2 || string.charAt(n3 + 2) != '-') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateSyntax", string));
        }
        int n5 = DateTimeUtil.parseInt(string, n3, n3 + 2);
        n = DateTimeUtil.parseTimeZone(string, n3 += 3, nArray);
        if (n != n3 + 2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateSyntax", string));
        }
        int n6 = DateTimeUtil.parseInt(string, n3, n);
        try {
            dateValue = new DateValue(n4, n5, n6, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("dateSyntax", string));
        }
        return dateValue;
    }

    public DateValue(int n, int n2, int n3, int n4, int n5, int n6) {
        this.dateTime = new DateTimeValue();
        this.dateTime.hour = 0;
        this.dateTime.minute = 0;
        this.dateTime.second = 0.0;
        if (n == 0) {
            throw new IllegalArgumentException("no year 0000");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("invalid month");
        }
        if (n3 < 1 || n3 > DateTimeUtil.lastDayOfMonth(n2, n)) {
            throw new IllegalArgumentException("invalid day");
        }
        switch (n4) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n5 < 0 || n5 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n4 == -1 && n5 == 0 && n6 == 0) {
            n4 = 1;
        }
        this.dateTime.year = n;
        this.dateTime.month = (byte)n2;
        this.dateTime.day = (byte)n3;
        this.dateTime.tzSign = (byte)n4;
        this.dateTime.tzHour = (byte)n5;
        this.dateTime.tzMinute = (byte)n6;
    }

    private DateValue(DateTimeValue dateTimeValue) {
        this.dateTime = dateTimeValue;
    }

    public DateTimeValue getDateTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return this.dateTime.toDate();
    }

    public static DateValue fromDate(Date date) {
        return DateValue.fromDate(date, false);
    }

    public static DateValue fromDate(Date date, boolean bl) {
        DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, bl);
        dateTimeValue.hour = 0;
        dateTimeValue.minute = 0;
        dateTimeValue.second = 0.0;
        return new DateValue(dateTimeValue);
    }

    public String toString() {
        return this.format();
    }

    public String format() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dateTime.year < 0) {
            stringBuffer.append('-');
            DateTimeUtil.appendPadded(-this.dateTime.year, 4, stringBuffer);
        } else {
            DateTimeUtil.appendPadded(this.dateTime.year, 4, stringBuffer);
        }
        stringBuffer.append('-');
        DateTimeUtil.appendPadded(this.dateTime.month, 2, stringBuffer);
        stringBuffer.append('-');
        DateTimeUtil.appendPadded(this.dateTime.day, 2, stringBuffer);
        DateTimeUtil.appendTimeZone(this.dateTime.tzSign, this.dateTime.tzHour, this.dateTime.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DateValue)) {
            return false;
        }
        DateValue dateValue = (DateValue)object;
        return this.dateTime.equals(dateValue.dateTime);
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof DateValue)) {
            return -2;
        }
        DateValue dateValue = (DateValue)value;
        return this.dateTime.compareTo(dateValue.dateTime);
    }
}

