/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.NumericValue;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.math.BigDecimal;

public class DecimalValue
extends NumericValue {
    private BigDecimal decimal;

    public static DecimalValue parseDecimal(String string) throws InvalidDataException {
        BigDecimal bigDecimal = null;
        try {
            if (DecimalValue.checkString(string)) {
                bigDecimal = new BigDecimal(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bigDecimal == null) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("decimalSyntax", string));
        }
        return new DecimalValue(bigDecimal);
    }

    private static final boolean checkString(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        switch (string.charAt(n2)) {
            case '+': 
            case '-': {
                if (++n2 != n) break;
                return false;
            }
        }
        boolean bl = false;
        if (string.charAt(n2) == '.') {
            bl = true;
            if (++n2 == n) {
                return false;
            }
        }
        do {
            switch (string.charAt(n2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (++n2 < n);
        return true;
    }

    public DecimalValue(BigDecimal bigDecimal) {
        this.decimal = bigDecimal;
    }

    public BigDecimal getBigDecimal() {
        return this.decimal;
    }

    public BigDecimal toBigDecimal() {
        return this.decimal;
    }

    public String toString() {
        String string = this.decimal.toString();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 >= 0) {
            if (string.charAt(n4) != '0') break;
            ++n2;
            ++n3;
            --n4;
        }
        boolean bl = false;
        while (n4 >= 0) {
            if (string.charAt(n4) == '.') {
                bl = true;
                break;
            }
            ++n3;
            --n4;
        }
        if (!bl) {
            return string + ".0";
        }
        if (n2 == n3) {
            --n2;
        }
        if (n2 > 0) {
            return string.substring(0, n - n2);
        }
        return string;
    }

    public int hashCode() {
        return this.decimal.intValue();
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        return this.decimal.compareTo(((NumericValue)value).toBigDecimal());
    }

    public int totalDigits() {
        String string = this.toString();
        int n = string.length();
        if (string.charAt(0) == '-') {
            --n;
        }
        n = string.endsWith(".0") ? (n -= 2) : --n;
        return n;
    }

    public int fractionDigits() {
        String string = this.toString();
        if (string.endsWith(".0")) {
            return 0;
        }
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            if (string.charAt(n2) == '.') break;
            ++n;
            --n2;
        }
        return n;
    }
}

