/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;

public class DoubleValue
extends Value {
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    public static final DoubleValue POSITIVE_INFINITY = new DoubleValue(Double.POSITIVE_INFINITY);
    public static final DoubleValue NEGATIVE_INFINITY = new DoubleValue(Double.NEGATIVE_INFINITY);
    private double number;

    public static DoubleValue parseDouble(String string) throws InvalidDataException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            if (string.equals("NaN")) {
                return NaN;
            }
            if (string.equals("INF")) {
                return POSITIVE_INFINITY;
            }
            if (string.equals("-INF")) {
                return NEGATIVE_INFINITY;
            }
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("doubleSyntax", string));
        }
        return new DoubleValue(d);
    }

    public DoubleValue(double d) {
        this.number = d;
    }

    public double getDouble() {
        return this.number;
    }

    public String toString() {
        if (this.number == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (this.number == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return Double.toString(this.number);
    }

    public int hashCode() {
        return (int)this.number;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DoubleValue)) {
            return false;
        }
        DoubleValue doubleValue = (DoubleValue)object;
        return this.number == doubleValue.number;
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof DoubleValue)) {
            return -2;
        }
        DoubleValue doubleValue = (DoubleValue)value;
        return this.number < doubleValue.number ? -1 : (this.number > doubleValue.number ? 1 : 0);
    }
}

