/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.DateTimeUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.Date;

public class GMonthValue
extends Value {
    private DateTimeValue dateTime;

    public static GMonthValue parseGMonth(String string) throws InvalidDataException {
        GMonthValue gMonthValue;
        int[] nArray = new int[3];
        if (!string.startsWith("--")) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthSyntax", string));
        }
        int n = 2;
        int n2 = DateTimeUtil.parseTimeZone(string, n, nArray);
        if (n2 != n + 2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthSyntax", string));
        }
        int n3 = DateTimeUtil.parseInt(string, n, n2);
        try {
            gMonthValue = new GMonthValue(n3, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gMonthSyntax", string));
        }
        return gMonthValue;
    }

    public GMonthValue(int n, int n2, int n3, int n4) {
        this.dateTime = new DateTimeValue();
        this.dateTime.year = 1980;
        this.dateTime.day = 1;
        this.dateTime.hour = 0;
        this.dateTime.minute = 0;
        this.dateTime.second = 0.0;
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("invalid month");
        }
        switch (n2) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n3 < 0 || n3 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n4 < 0 || n4 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n2 == -1 && n3 == 0 && n4 == 0) {
            n2 = 1;
        }
        this.dateTime.month = (byte)n;
        this.dateTime.tzSign = (byte)n2;
        this.dateTime.tzHour = (byte)n3;
        this.dateTime.tzMinute = (byte)n4;
    }

    private GMonthValue(DateTimeValue dateTimeValue) {
        this.dateTime = dateTimeValue;
    }

    public DateTimeValue getDateTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return this.dateTime.toDate();
    }

    public static GMonthValue fromDate(Date date) {
        return GMonthValue.fromDate(date, false);
    }

    public static GMonthValue fromDate(Date date, boolean bl) {
        DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, bl);
        dateTimeValue.year = 1980;
        dateTimeValue.day = 1;
        dateTimeValue.hour = 0;
        dateTimeValue.minute = 0;
        dateTimeValue.second = 0.0;
        return new GMonthValue(dateTimeValue);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--");
        DateTimeUtil.appendPadded(this.dateTime.month, 2, stringBuffer);
        DateTimeUtil.appendTimeZone(this.dateTime.tzSign, this.dateTime.tzHour, this.dateTime.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GMonthValue)) {
            return false;
        }
        GMonthValue gMonthValue = (GMonthValue)object;
        return this.dateTime.equals(gMonthValue.dateTime);
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof GMonthValue)) {
            return -2;
        }
        GMonthValue gMonthValue = (GMonthValue)value;
        return this.dateTime.compareTo(gMonthValue.dateTime);
    }
}

