/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.DateTimeUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.Date;

public class GYearValue
extends Value {
    private DateTimeValue dateTime;

    public static GYearValue parseGYear(String string) throws InvalidDataException {
        GYearValue gYearValue;
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearSyntax", string));
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = DateTimeUtil.parseTimeZone(string, n3, nArray)) < n3 + 4) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearSyntax", string));
        }
        int n4 = DateTimeUtil.parseInt(string, n3, n);
        if (bl) {
            n4 = -n4;
        }
        try {
            gYearValue = new GYearValue(n4, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("gYearSyntax", string));
        }
        return gYearValue;
    }

    public GYearValue(int n, int n2, int n3, int n4) {
        this.dateTime = new DateTimeValue();
        this.dateTime.month = 1;
        this.dateTime.day = 1;
        this.dateTime.hour = 0;
        this.dateTime.minute = 0;
        this.dateTime.second = 0.0;
        if (n == 0) {
            throw new IllegalArgumentException("no year 0000");
        }
        switch (n2) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n3 < 0 || n3 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n4 < 0 || n4 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n2 == -1 && n3 == 0 && n4 == 0) {
            n2 = 1;
        }
        this.dateTime.year = n;
        this.dateTime.tzSign = (byte)n2;
        this.dateTime.tzHour = (byte)n3;
        this.dateTime.tzMinute = (byte)n4;
    }

    private GYearValue(DateTimeValue dateTimeValue) {
        this.dateTime = dateTimeValue;
    }

    public DateTimeValue getDateTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return this.dateTime.toDate();
    }

    public static GYearValue fromDate(Date date) {
        return GYearValue.fromDate(date, false);
    }

    public static GYearValue fromDate(Date date, boolean bl) {
        DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, bl);
        dateTimeValue.month = 1;
        dateTimeValue.day = 1;
        dateTimeValue.hour = 0;
        dateTimeValue.minute = 0;
        dateTimeValue.second = 0.0;
        return new GYearValue(dateTimeValue);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dateTime.year < 0) {
            stringBuffer.append('-');
            DateTimeUtil.appendPadded(-this.dateTime.year, 4, stringBuffer);
        } else {
            DateTimeUtil.appendPadded(this.dateTime.year, 4, stringBuffer);
        }
        DateTimeUtil.appendTimeZone(this.dateTime.tzSign, this.dateTime.tzHour, this.dateTime.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GYearValue)) {
            return false;
        }
        GYearValue gYearValue = (GYearValue)object;
        return this.dateTime.equals(gYearValue.dateTime);
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof GYearValue)) {
            return -2;
        }
        GYearValue gYearValue = (GYearValue)value;
        return this.dateTime.compareTo(gYearValue.dateTime);
    }
}

