/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.NumericValue;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.math.BigDecimal;

public class IntValue
extends NumericValue {
    private int number;

    public static IntValue parseInt(String string) throws InvalidDataException {
        int n;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("intSyntax", string));
        }
        return new IntValue(n);
    }

    public IntValue(int n) {
        this.number = n;
    }

    public int getInt() {
        return this.number;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(Integer.toString(this.number));
    }

    public String toString() {
        return Integer.toString(this.number);
    }

    public int hashCode() {
        return this.number;
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof IntValue) {
            int n = ((IntValue)value).number;
            return this.number < n ? -1 : (this.number > n ? 1 : 0);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    public int totalDigits() {
        return Integer.toString(this.number).length();
    }

    public int fractionDigits() {
        return 0;
    }
}

