/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.doctype.UnparsedEntities;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.StringValue;
import com.xmlmind.xmledit.xsd.datatype.TokenType;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class LanguageType
extends TokenType {
    public static final LanguageType BASE = new LanguageType();
    public static final String[] LANGUAGE_LIST = new String[]{"aa", "ab", "af", "am", "ar", "as", "ay", "az", "ba", "be", "bg", "bh", "bi", "bn", "bo", "br", "ca", "co", "cs", "cy", "da", "de", "dz", "el", "en", "eo", "es", "et", "eu", "fa", "fi", "fj", "fo", "fr", "fy", "ga", "gd", "gl", "gn", "gu", "ha", "he", "hi", "hr", "hu", "hy", "ia", "id", "ie", "ik", "is", "it", "iu", "ja", "jw", "ka", "kk", "kl", "km", "kn", "ko", "ks", "ku", "ky", "la", "ln", "lo", "lt", "lv", "mg", "mi", "mk", "ml", "mn", "mo", "mr", "ms", "mt", "my", "na", "ne", "nl", "no", "oc", "om", "or", "pa", "pl", "ps", "pt", "qu", "rm", "rn", "ro", "ru", "rw", "sa", "sd", "sg", "sh", "si", "sk", "sl", "sm", "sn", "so", "sq", "sr", "ss", "st", "su", "sv", "sw", "ta", "te", "tg", "th", "ti", "tk", "tl", "tn", "to", "tr", "ts", "tt", "tw", "ug", "uk", "ur", "uz", "vi", "vo", "wo", "xh", "yi", "yo", "za", "zh", "zu"};
    private static Hashtable languages = new Hashtable();

    public static final boolean isKnownLanguage(String string) {
        return languages.containsKey(string);
    }

    protected LanguageType() {
    }

    private Object readResolve() throws ObjectStreamException {
        return this.baseType == null ? BASE : this;
    }

    protected Value doParse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        string = string.toLowerCase();
        int n = string.length();
        if (string.startsWith("i-") || string.startsWith("x-")) {
            if (n == 2) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("languageSyntax", string));
            }
        } else {
            if (n < 2 || languages.get(string.substring(0, 2)) == null) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("languageSyntax", string));
            }
            if (n > 2 && (string.charAt(2) != '-' || n == 3)) {
                throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("languageSyntax", string));
            }
        }
        return new StringValue(string);
    }

    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        return "language";
    }

    static {
        int n = 0;
        while (n < LANGUAGE_LIST.length) {
            String string = LANGUAGE_LIST[n];
            languages.put(string, string);
            ++n;
        }
    }
}

