/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.doctype.ListDataType;
import com.xmlmind.xmledit.doctype.UnparsedEntities;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.ListValue;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.NonStringType;
import com.xmlmind.xmledit.xsd.datatype.UnionType;
import com.xmlmind.xmledit.xsd.datatype.Value;

public class ListType
extends NonStringType
implements ListDataType {
    protected DataType itemType;
    private static final ListValue EMPTY_LIST = new ListValue(new Value[0]);

    public ListType(DataType dataType) {
        this.itemType = dataType;
    }

    public DataType getItemType() {
        return this.itemType;
    }

    public int getSupportedFacets() {
        return 63;
    }

    public void checkFacets() throws InvalidTypeException {
        if (ListType.findListType(this.itemType)) {
            throw new InvalidTypeException("cos-list-of-atomic", Msg.msg("nonAtomicListItem"));
        }
    }

    private static final boolean findListType(DataType dataType) {
        if (dataType instanceof ListType) {
            return true;
        }
        if (dataType instanceof UnionType) {
            DataType[] dataTypeArray = ((UnionType)dataType).getMemberTypes();
            int n = 0;
            while (n < dataTypeArray.length) {
                DataType dataType2 = dataTypeArray[n];
                if (ListType.findListType(dataType2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected int rootTypeHashCode() {
        return this.itemType.hashCode();
    }

    protected boolean sameRootType(DataType dataType) {
        if (!(dataType instanceof ListType)) {
            return false;
        }
        return this.itemType.equals(((ListType)dataType).itemType);
    }

    protected Value doParse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        if (string.length() == 0) {
            return EMPTY_LIST;
        }
        String[] stringArray = StringUtil.split(string, ' ');
        Value[] valueArray = new Value[stringArray.length];
        int n = 0;
        while (n < valueArray.length) {
            valueArray[n] = this.itemType.parse(stringArray[n], prefixToNamespace, unparsedEntities);
            ++n;
        }
        return new ListValue(valueArray);
    }

    public boolean isContextDependentDataType() {
        return this.itemType.isContextDependentDataType();
    }

    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Msg.msg("list"));
        stringBuffer.append(" ");
        stringBuffer.append(this.itemType.getDataTypeLabel(namespaceToPrefixes));
        UnionType.appendEnumeration(this.itemType, namespaceToPrefixes, stringBuffer);
        return stringBuffer.toString();
    }

    public com.xmlmind.xmledit.doctype.DataType getItemDataType() {
        return this.itemType;
    }

    public int getListMinLength() {
        if ((this.facets & 2) != 0) {
            return this.minLength;
        }
        return 0;
    }

    public int getListMaxLength() {
        if ((this.facets & 4) != 0) {
            return this.maxLength;
        }
        return -1;
    }
}

