/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.xsdregex.RegexSyntaxException;
import com.xmlmind.xmledit.xsd.datatype.xsdregex.Translator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

public final class Pattern
implements Serializable {
    private String pattern;
    private transient Matcher matcher;

    public Pattern(String string) {
        this.pattern = string;
        this.matcher = Pattern.createMatcher(string);
    }

    private static Matcher createMatcher(String string) {
        Matcher matcher = null;
        try {
            java.util.regex.Pattern pattern = java.util.regex.Pattern.compile(Translator.translate(string));
            matcher = pattern.matcher("dummy");
        }
        catch (RegexSyntaxException regexSyntaxException) {
            throw new IllegalArgumentException(regexSyntaxException.getMessage());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException(patternSyntaxException.getMessage());
        }
        return matcher;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.matcher = Pattern.createMatcher(this.pattern);
    }

    public boolean matches(String string) {
        this.matcher.reset(string);
        return this.matcher.matches();
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Pattern)) {
            return false;
        }
        return this.pattern.equals(((Pattern)object).pattern);
    }

    public String toString() {
        return this.pattern;
    }
}

