/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.NumericValue;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.math.BigDecimal;

public class ShortValue
extends NumericValue {
    private short number;

    public static ShortValue parseShort(String string) throws InvalidDataException {
        short s;
        if (string.length() > 0 && string.charAt(0) == '+') {
            string = string.substring(1);
        }
        try {
            s = Short.parseShort(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("shortSyntax", string));
        }
        return new ShortValue(s);
    }

    public ShortValue(short s) {
        this.number = s;
    }

    public short getShort() {
        return this.number;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(Short.toString(this.number));
    }

    public String toString() {
        return Short.toString(this.number);
    }

    public int hashCode() {
        return this.number;
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        if (value instanceof ShortValue) {
            short s = ((ShortValue)value).number;
            return this.number < s ? -1 : (this.number > s ? 1 : 0);
        }
        return this.toBigDecimal().compareTo(((NumericValue)value).toBigDecimal());
    }

    public int totalDigits() {
        return Short.toString(this.number).length();
    }

    public int fractionDigits() {
        return 0;
    }
}

