/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.xsd.datatype.DateTimeUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.Date;

public class TimeValue
extends Value {
    private DateTimeValue dateTime;

    public static TimeValue parseTime(String string) throws InvalidDataException {
        TimeValue timeValue;
        int[] nArray = new int[3];
        int n = 0;
        int n2 = string.length();
        if (n + 2 >= n2 || string.charAt(n + 2) != ':') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("timeSyntax", string));
        }
        int n3 = DateTimeUtil.parseInt(string, n, n + 2);
        if ((n += 3) + 2 >= n2 || string.charAt(n + 2) != ':') {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("timeSyntax", string));
        }
        int n4 = DateTimeUtil.parseInt(string, n, n + 2);
        int n5 = DateTimeUtil.parseTimeZone(string, n += 3, nArray);
        if (n5 < n + 2) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("timeSyntax", string));
        }
        double d = DateTimeUtil.parseDouble(string, n, n5);
        try {
            timeValue = new TimeValue(n3, n4, d, nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("timeSyntax", string));
        }
        return timeValue;
    }

    public TimeValue(int n, int n2, double d, int n3, int n4, int n5) {
        this.dateTime = new DateTimeValue();
        this.dateTime.year = 1980;
        this.dateTime.month = 1;
        this.dateTime.day = 1;
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("invalid hour");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("invalid minute");
        }
        if (d < 0.0 || d > 60.0) {
            throw new IllegalArgumentException("invalid second");
        }
        switch (n3) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid tzSign");
            }
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("invalid tzHour");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("invalid tzMinute");
        }
        if (n3 == -1 && n4 == 0 && n5 == 0) {
            n3 = 1;
        }
        this.dateTime.hour = (byte)n;
        this.dateTime.minute = (byte)n2;
        this.dateTime.second = d;
        this.dateTime.tzSign = (byte)n3;
        this.dateTime.tzHour = (byte)n4;
        this.dateTime.tzMinute = (byte)n5;
    }

    private TimeValue(DateTimeValue dateTimeValue) {
        this.dateTime = dateTimeValue;
    }

    public DateTimeValue getDateTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return this.dateTime.toDate();
    }

    public static TimeValue fromDate(Date date) {
        return TimeValue.fromDate(date, false);
    }

    public static TimeValue fromDate(Date date, boolean bl) {
        DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, bl);
        dateTimeValue.year = 1980;
        dateTimeValue.month = 1;
        dateTimeValue.day = 1;
        return new TimeValue(dateTimeValue);
    }

    public String toString() {
        return TimeValue.format(this.dateTime.withNormalizedTimeZone());
    }

    public String format() {
        return TimeValue.format(this.dateTime);
    }

    private static String format(DateTimeValue dateTimeValue) {
        StringBuffer stringBuffer = new StringBuffer();
        DateTimeUtil.appendPadded(dateTimeValue.hour, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeUtil.appendPadded(dateTimeValue.minute, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeUtil.appendPadded(dateTimeValue.second, 2, stringBuffer);
        DateTimeUtil.appendTimeZone(dateTimeValue.tzSign, dateTimeValue.tzHour, dateTimeValue.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TimeValue)) {
            return false;
        }
        TimeValue timeValue = (TimeValue)object;
        return this.dateTime.equals(timeValue.dateTime);
    }

    public int compareTo(Value value) {
        if (value == null || !(value instanceof TimeValue)) {
            return -2;
        }
        TimeValue timeValue = (TimeValue)value;
        return this.dateTime.compareTo(timeValue.dateTime);
    }
}

