/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.datatype;

import com.xmlmind.xmledit.doctype.UnparsedEntities;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Msg;
import com.xmlmind.xmledit.xsd.datatype.Value;
import java.util.ArrayList;

public class UnionType
extends DataType {
    protected DataType[] memberTypes;

    public UnionType(DataType[] dataTypeArray) {
        ArrayList arrayList = new ArrayList();
        this.expandMemberTypes(dataTypeArray, arrayList);
        dataTypeArray = new DataType[arrayList.size()];
        arrayList.toArray(dataTypeArray);
        this.memberTypes = dataTypeArray;
    }

    private void expandMemberTypes(DataType[] dataTypeArray, ArrayList arrayList) {
        int n = 0;
        while (n < dataTypeArray.length) {
            DataType dataType = dataTypeArray[n];
            if (dataType instanceof UnionType) {
                this.expandMemberTypes(((UnionType)dataType).memberTypes, arrayList);
            } else if (!arrayList.contains(dataType)) {
                arrayList.add(dataType);
            }
            ++n;
        }
    }

    public DataType[] getMemberTypes() {
        return this.memberTypes;
    }

    public int getSupportedFacets() {
        return 24;
    }

    protected int rootTypeHashCode() {
        int n = this.memberTypes[0].hashCode();
        int n2 = 1;
        while (n2 < this.memberTypes.length) {
            n ^= this.memberTypes[n2].hashCode();
            ++n2;
        }
        return n;
    }

    protected boolean sameRootType(DataType dataType) {
        if (!(dataType instanceof UnionType)) {
            return false;
        }
        UnionType unionType = (UnionType)dataType;
        int n = this.memberTypes.length;
        if (n != unionType.memberTypes.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.memberTypes[n2].equals(unionType.memberTypes[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Value doParse(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws InvalidDataException {
        int n = 0;
        while (n < this.memberTypes.length) {
            Value value;
            DataType dataType = this.memberTypes[n];
            try {
                value = dataType.valueOf(string, prefixToNamespace, unparsedEntities);
            }
            catch (InvalidDataException invalidDataException) {
                value = null;
            }
            if (value != null) {
                return value;
            }
            ++n;
        }
        throw new InvalidDataException("cvc-datatype-valid.1.2.3", Msg.msg("unionMemberSyntax", string));
    }

    public boolean isContextDependentDataType() {
        int n = 0;
        while (n < this.memberTypes.length) {
            if (this.memberTypes[n].isContextDependentDataType()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Msg.msg("union"));
        int n = 0;
        while (n < this.memberTypes.length) {
            DataType dataType = this.memberTypes[n];
            if (n > 0) {
                stringBuffer.append(", ");
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append(dataType.getDataTypeLabel(namespaceToPrefixes));
            UnionType.appendEnumeration(dataType, namespaceToPrefixes, stringBuffer);
            ++n;
        }
        return stringBuffer.toString();
    }

    static final void appendEnumeration(DataType dataType, NamespaceToPrefixes namespaceToPrefixes, StringBuffer stringBuffer) {
        if (dataType.hasFacet(16) && !dataType.getRootType().hasFacet(16)) {
            Value[] valueArray = dataType.getEnumeration();
            stringBuffer.append('{');
            int n = 0;
            while (n < valueArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("\"");
                stringBuffer.append(valueArray[n].toString(namespaceToPrefixes));
                stringBuffer.append("\"");
                ++n;
            }
            stringBuffer.append('}');
        }
    }
}

