/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.dtdtoxsd;

import com.xmlmind.xmledit.doc.AttributeDefaultValue;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.dtdtoxsd.Msg;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.net.URL;

public class DTD
extends Schema {
    private Name documentTypeName;
    private String publicId;
    private String systemId;
    private URL externalSubsetURL;

    public DTD(Name name, String string, String string2, URL uRL) {
        this.documentTypeName = name;
        this.publicId = string;
        this.systemId = string2;
        this.externalSubsetURL = uRL;
    }

    public Name getDocumentTypeName() {
        return this.documentTypeName;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public URL getExternalSubsetURL() {
        return this.externalSubsetURL;
    }

    public ValidationError[] validate(Document document, boolean bl) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(document, bl, validationErrors);
        return validationErrors.toArray();
    }

    public Object validate(Document document, ValidationErrors validationErrors) {
        return this.validate(document, true, validationErrors);
    }

    public Object validate(Document document, boolean bl, ValidationErrors validationErrors) {
        Element element = document.getRootElement();
        Object object = this.validate(element, true, validationErrors);
        if (object != null && !this.checkIds(element, validationErrors)) {
            object = null;
        }
        Name name = element.getName();
        if (bl && name != this.documentTypeName) {
            validationErrors.append(element, "x-root-element-type", Msg.msg("badRootElement", name, this.documentTypeName));
            object = null;
        }
        return object;
    }

    public Type findElementType(Element element) {
        ElementDeclaration elementDeclaration = this.getElementDeclaration(element.getName());
        return elementDeclaration == null ? null : elementDeclaration.getType();
    }

    public ElementDeclaration findElementDeclaration(Element element) {
        return this.getElementDeclaration(element.getName());
    }

    public AttributeDeclaration findAttributeDeclaration(Element element, Name name) {
        ElementDeclaration elementDeclaration = this.getElementDeclaration(element.getName());
        if (elementDeclaration == null) {
            return null;
        }
        return ((ComplexType)elementDeclaration.getType()).getAttributeDeclaration(name);
    }

    public Type getElementLocalType(Element element) {
        return null;
    }

    public boolean isDTD() {
        return true;
    }

    public Diagnostic[] checkDocument(Document document) {
        return this.validate(document, false);
    }

    public String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        while (element != null) {
            String string = this.getElementAttribute(element, name, attributeDefaultValue);
            if (string != null) {
                return string;
            }
            element = element.getParentElement();
        }
        return null;
    }
}

